/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.task;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.services.security.ConversationState;

public abstract class AbstractForumTask {
    private final ConversationState state = ConversationState.getCurrent();

    public ConversationState getState() {
        return this.state;
    }

    protected static JCRDataStorage getJCRDataStorage() {
        return (JCRDataStorage)CommonsUtils.getService(JCRDataStorage.class);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public abstract void process() throws Exception;

    public static class SendNotificationTask
    extends AbstractForumTask {
        private final Topic topic;
        private final Post post;
        private final String nodePath;
        private final boolean isApprovePost;
        private final MessageBuilder messageBuilder;

        public SendNotificationTask(String nodePath, Topic topic, Post post, MessageBuilder messageBuilder, boolean isApprovePost) {
            this.topic = topic;
            this.post = post;
            this.nodePath = nodePath;
            this.messageBuilder = messageBuilder;
            this.isApprovePost = isApprovePost;
        }

        @Override
        public void process() throws Exception {
            SendNotificationTask.getJCRDataStorage().sendNotification(this.nodePath, this.topic, this.post, this.messageBuilder, this.isApprovePost);
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            if (o instanceof SendNotificationTask) {
                SendNotificationTask that = (SendNotificationTask)o;
                if (this.isApprovePost != that.isApprovePost) {
                    return false;
                }
                if (this.nodePath != null ? !this.nodePath.equals(that.nodePath) : that.nodePath != null) {
                    return false;
                }
                if (this.post != null ? !this.post.getId().equals(that.post == null ? "" : that.post.getId()) : that.post != null) {
                    return false;
                }
                return !(this.topic != null ? !this.topic.getId().equals(that.topic == null ? "" : that.topic.getId()) : that.topic != null);
            }
            return false;
        }
    }

    public static class QueryLastPostTask
    extends AbstractForumTask {
        private final String forumPath;

        public QueryLastPostTask(String forumPath) {
            this.forumPath = forumPath;
        }

        @Override
        public void process() throws Exception {
            QueryLastPostTask.getJCRDataStorage().queryLastPostForum(this.forumPath);
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            if (o instanceof QueryLastPostTask) {
                QueryLastPostTask that = (QueryLastPostTask)o;
                return !(this.forumPath != null ? !this.forumPath.equals(that.forumPath) : that.forumPath != null);
            }
            return false;
        }
    }
}

