/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.websocket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.exoplatform.commons.api.websocket.AbstractEndpoint;
import org.exoplatform.commons.api.websocket.FilterDefinitionPlugin;
import org.exoplatform.commons.api.websocket.WSFilterDefinition;

public class ExtensibleWSFilter {
    private volatile List<WSFilterDefinition> filters = Collections.unmodifiableList(new ArrayList());

    public void addFilterDefinitions(FilterDefinitionPlugin plugin) {
        this.addFilterDefinitions(plugin.getFilterDefinitions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFilterDefinitions(List<WSFilterDefinition> pluginFilters) {
        if (pluginFilters == null || pluginFilters.isEmpty()) {
            return;
        }
        ExtensibleWSFilter extensibleWSFilter = this;
        synchronized (extensibleWSFilter) {
            ArrayList<WSFilterDefinition> result = new ArrayList<WSFilterDefinition>(this.filters);
            result.addAll(pluginFilters);
            this.filters = Collections.unmodifiableList(result);
        }
    }

    public void onOpen(Session wsSession, EndpointConfig config, AbstractEndpoint delegate) {
        ExtensibleFilterChain efChain = new ExtensibleFilterChain(this.filters, delegate);
        efChain.onOpen(wsSession, config);
    }

    public void onClose(Session wsSession, CloseReason closeReason, AbstractEndpoint delegate) {
        ExtensibleFilterChain efChain = new ExtensibleFilterChain(this.filters, delegate);
        efChain.onClose(wsSession, closeReason);
    }

    public void onError(Session wsSession, Throwable failure, AbstractEndpoint delegate) {
        ExtensibleFilterChain efChain = new ExtensibleFilterChain(this.filters, delegate);
        efChain.onError(wsSession, failure);
    }

    public void onMessage(String message, AbstractEndpoint delegate) {
        ExtensibleFilterChain efChain = new ExtensibleFilterChain(this.filters, delegate);
        efChain.onMessage(delegate._session, message);
    }

    public void onMessage(String message, boolean arg1, AbstractEndpoint delegate) {
        ExtensibleFilterChain efChain = new ExtensibleFilterChain(this.filters, delegate);
        efChain.onMessage(delegate._session, message, arg1);
    }

    public class ExtensibleFilterChain {
        private final Iterator<WSFilterDefinition> filters;
        private final AbstractEndpoint delegate;

        public ExtensibleFilterChain(List<WSFilterDefinition> filters, AbstractEndpoint delegate) {
            this.filters = filters.iterator();
            this.delegate = delegate;
        }

        public void onMessage(Session wsSession, String message, boolean arg1) {
            while (this.filters.hasNext()) {
                WSFilterDefinition filterDef = this.filters.next();
                if (!filterDef.match(wsSession.getRequestURI().getPath())) continue;
                filterDef.getFilter().onMessage(wsSession, message, arg1, this);
                return;
            }
            this.delegate.doMessage(wsSession, message, arg1);
        }

        public void onMessage(Session wsSession, String message) {
            while (this.filters.hasNext()) {
                WSFilterDefinition filterDef = this.filters.next();
                if (!filterDef.match(wsSession.getRequestURI().getPath())) continue;
                filterDef.getFilter().onMessage(wsSession, message, this);
                return;
            }
            this.delegate.doMessage(wsSession, message);
        }

        public void onError(Session wsSession, Throwable failure) {
            while (this.filters.hasNext()) {
                WSFilterDefinition filterDef = this.filters.next();
                if (!filterDef.match(wsSession.getRequestURI().getPath())) continue;
                filterDef.getFilter().onError(wsSession, failure, this);
                return;
            }
            this.delegate.doError(wsSession, failure);
        }

        public void onClose(Session wsSession, CloseReason closeReason) {
            while (this.filters.hasNext()) {
                WSFilterDefinition filterDef = this.filters.next();
                if (!filterDef.match(wsSession.getRequestURI().getPath())) continue;
                filterDef.getFilter().onClose(wsSession, closeReason, this);
                return;
            }
            this.delegate.doClose(wsSession, closeReason);
        }

        public void onOpen(Session wsSession, EndpointConfig config) {
            while (this.filters.hasNext()) {
                WSFilterDefinition filterDef = this.filters.next();
                if (!filterDef.match(wsSession.getRequestURI().getPath())) continue;
                filterDef.getFilter().onOpen(wsSession, config, this);
                return;
            }
            this.delegate.doOpen(wsSession, config);
        }
    }
}

