/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.gatein.common.io.IOTools;
import org.gatein.common.util.Tools;

public class CompositeReader
extends Reader {
    private Iterator<Reader> compounds;
    private Reader current;

    public CompositeReader(Reader ... compounds) throws NullPointerException {
        this(Tools.iterator((Object[])compounds));
    }

    public CompositeReader(Iterable<Reader> compounds) throws NullPointerException {
        this(compounds.iterator());
    }

    public CompositeReader(Iterator<Reader> compounds) throws NullPointerException {
        this.compounds = compounds;
        this.current = null;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = 0;
        while (len > 0) {
            if (this.current == null) {
                if (this.compounds.hasNext()) {
                    this.current = this.compounds.next();
                    continue;
                }
                if (read != 0) break;
                read = -1;
                break;
            }
            int tmp = this.current.read(cbuf, off, len);
            if (tmp == -1) {
                Reader reader = this.current;
                this.current = null;
                reader.close();
                continue;
            }
            off += tmp;
            len -= tmp;
            read += tmp;
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        if (this.current != null) {
            IOTools.safeClose((Closeable)this.current);
            this.current = null;
        }
        while (this.compounds.hasNext()) {
            IOTools.safeClose((Closeable)this.compounds.next());
        }
        this.compounds = null;
    }
}

