/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api.wiki;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.PortalWiki;
import org.exoplatform.wiki.mow.core.api.wiki.WikiContainer;
import org.exoplatform.wiki.utils.Utils;

@PrimaryType(name="wiki:portalwikis")
public abstract class PortalWikiContainer
extends WikiContainer<PortalWiki> {
    @OneToOne
    @MappedBy(value="portalwikis")
    public abstract WikiStoreImpl getMultiWiki();

    @Override
    public PortalWiki addWiki(String wikiOwner) {
        return this.getWikiObject(wikiOwner, true);
    }

    @Override
    protected PortalWiki getWikiObject(String wikiOwner, boolean createIfNonExist) {
        Node wikiNode;
        ChromatticSession session;
        boolean isCreatedWikiObject;
        block7: {
            isCreatedWikiObject = false;
            if ((wikiOwner = this.validateWikiOwner(wikiOwner)) == null) {
                return null;
            }
            session = this.getMultiWiki().getSession();
            wikiNode = null;
            try {
                Node wikisNode = (Node)session.getJCRSession().getItem(Utils.getPortalWikisPath());
                try {
                    wikiNode = wikisNode.getNode(wikiOwner);
                }
                catch (PathNotFoundException e) {
                    if (createIfNonExist) {
                        wikiNode = wikisNode.addNode(wikiOwner, "wiki:portalwiki");
                        wikisNode.save();
                        isCreatedWikiObject = true;
                        break block7;
                    }
                    return null;
                }
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
        }
        PortalWiki pwiki = (PortalWiki)session.findByNode(PortalWiki.class, wikiNode);
        pwiki.setWikiService(this.getwService());
        pwiki.setPortalWikis(this);
        if (isCreatedWikiObject) {
            pwiki.setOwner(wikiOwner);
            pwiki.getPreferences();
            session.save();
        }
        return pwiki;
    }
}

