/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api;

import java.util.Arrays;
import java.util.List;
import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSignature {
    private static final String[] NO_PARAMETERS = new String[0];
    private final String name;
    private final String[] parameterRawNames;

    public MethodSignature(String name, Class<?> ... parameterTypes) {
        String[] parameterRawNames;
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (parameterTypes == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (parameterTypes.length == 0) {
            parameterRawNames = NO_PARAMETERS;
        } else {
            parameterRawNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> parameterType = parameterTypes[i];
                if (parameterType == null) {
                    throw new IllegalArgumentException("No null parameter type allowed");
                }
                parameterRawNames[i] = parameterType.getName();
            }
        }
        this.name = name;
        this.parameterRawNames = parameterRawNames;
    }

    public MethodSignature(String name, List<TypeInfo> parameterTypes) {
        String[] parameterRawNames;
        if (name == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (parameterTypes == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (parameterTypes.size() == 0) {
            parameterRawNames = NO_PARAMETERS;
        } else {
            parameterRawNames = new String[parameterTypes.size()];
            int j = 0;
            for (TypeInfo parameterType : parameterTypes) {
                if (parameterType == null) {
                    throw new IllegalArgumentException("No null parameter type allowed");
                }
                parameterRawNames[j++] = this.computeRawName(parameterType);
            }
        }
        this.name = name;
        this.parameterRawNames = parameterRawNames;
    }

    public String getName() {
        return this.name;
    }

    private String computeRawName(TypeInfo type) {
        if (type instanceof ClassTypeInfo) {
            return ((ClassTypeInfo)type).getName();
        }
        if (type instanceof ParameterizedTypeInfo) {
            return this.computeRawName(((ParameterizedTypeInfo)type).getRawType());
        }
        if (type instanceof TypeVariableInfo) {
            return this.computeRawName(((TypeVariableInfo)type).getBounds().get(0));
        }
        if (type instanceof ArrayTypeInfo) {
            return "[L" + this.computeRawName(((ArrayTypeInfo)type).getComponentType()) + ";";
        }
        throw new AssertionError();
    }

    public int hashCode() {
        return this.name.hashCode() ^ Arrays.hashCode(this.parameterRawNames);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodSignature) {
            MethodSignature that = (MethodSignature)obj;
            return this.name.equals(that.name) && Arrays.equals(this.parameterRawNames, that.parameterRawNames);
        }
        return false;
    }

    public String toString() {
        return "MethodSignature[name=" + this.name + ",parameterRawNames=" + Arrays.toString(this.parameterRawNames) + "]";
    }
}

