/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.ext_util;

import com.tonicsystems.jarjar.ext_util.EntryStruct;
import com.tonicsystems.jarjar.ext_util.IoUtil;
import com.tonicsystems.jarjar.ext_util.JarProcessor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class StandaloneJarProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(File from, File to, JarProcessor proc) throws IOException {
        byte[] buf = new byte[8192];
        File tmp = null;
        if (from.equals(to)) {
            tmp = File.createTempFile("jarjar", null);
            IoUtil.copy(from, tmp, buf);
            from = tmp;
        }
        JarFile in = new JarFile(from);
        JarOutputStream out = new JarOutputStream(new FileOutputStream(to));
        HashSet<String> entries = new HashSet<String>();
        try {
            EntryStruct struct = new EntryStruct();
            Enumeration<JarEntry> e = in.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                struct.name = entry.getName();
                struct.time = entry.getTime();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IoUtil.pipe(in.getInputStream(entry), baos, buf);
                struct.data = baos.toByteArray();
                if (!proc.process(struct)) continue;
                if (entries.add(struct.name)) {
                    entry = new JarEntry(struct.name);
                    entry.setTime(struct.time);
                    entry.setCompressedSize(-1L);
                    out.putNextEntry(entry);
                    out.write(struct.data);
                    continue;
                }
                if (struct.name.endsWith("/")) continue;
                throw new IllegalArgumentException("Duplicate jar entries: " + struct.name);
            }
        }
        finally {
            out.close();
            if (tmp != null) {
                tmp.delete();
            }
        }
    }
}

