/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import javax.inject.Qualifier;
import juzu.Scope;
import juzu.impl.common.Tools;
import juzu.impl.inject.spi.Injector;

public abstract class BeanDescriptor {
    private final Class<?> declaredType;
    private final Scope scope;
    private final List<Annotation> qualifiers;
    private final Class<?> implementationType;

    private BeanDescriptor(Class<?> declaredType, Scope scope, List<Annotation> qualifiers, Class<?> implementationType) throws NullPointerException, IllegalArgumentException {
        if (declaredType == null) {
            throw new NullPointerException("No null declared type accepted");
        }
        if (qualifiers != null) {
            for (Annotation qualifier : qualifiers) {
                if (qualifier.annotationType().getAnnotation(Qualifier.class) != null) continue;
                throw new IllegalArgumentException("Qualifier annotation " + qualifier + " is not annotated with @Qualifier");
            }
        }
        this.declaredType = declaredType;
        this.scope = scope;
        this.qualifiers = qualifiers;
        this.implementationType = implementationType;
    }

    public static <T> BeanDescriptor createFromProviderType(final Class<T> declaredType, Scope scope, List<Annotation> qualifiers, final Class<? extends Provider<T>> implementationType) throws NullPointerException, IllegalArgumentException {
        return new BeanDescriptor(declaredType, scope, qualifiers, implementationType){

            @Override
            public void bind(Injector builder) {
                builder.declareProvider(declaredType, this.getScope(), this.getQualifiers(), implementationType);
            }
        };
    }

    public static <T> BeanDescriptor createFromProvider(final Class<T> declaredType, Scope scope, List<Annotation> qualifiers, final Provider<? extends T> implementationType) throws NullPointerException, IllegalArgumentException {
        return new BeanDescriptor(declaredType, scope, qualifiers, null){

            @Override
            public void bind(Injector builder) {
                builder.bindProvider(declaredType, this.getScope(), this.getQualifiers(), implementationType);
            }
        };
    }

    public static <T> BeanDescriptor createFromImpl(final Class<T> declaredType, Scope scope, List<Annotation> qualifiers, final Class<? extends T> implementationType) throws NullPointerException, IllegalArgumentException {
        return new BeanDescriptor(declaredType, scope, qualifiers, implementationType){

            @Override
            public void bind(Injector builder) {
                builder.declareBean(declaredType, this.getScope(), this.getQualifiers(), implementationType);
            }
        };
    }

    public static <T> BeanDescriptor createFromBean(final Class<T> declaredType, Scope scope, List<Annotation> qualifiers) throws NullPointerException, IllegalArgumentException {
        return new BeanDescriptor(declaredType, scope, qualifiers, null){

            @Override
            public void bind(Injector builder) {
                builder.declareBean(declaredType, this.getScope(), this.getQualifiers(), null);
            }
        };
    }

    public Class<?> getDeclaredType() {
        return this.declaredType;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<?> getImplementationType() {
        return this.implementationType;
    }

    public abstract void bind(Injector var1);

    public static Iterable<Annotation> appendProvidedQualifiers(Iterable<Annotation> qualifiers, Class<? extends Provider> providerClass) {
        try {
            Method getMethod = providerClass.getMethod("get", new Class[0]);
            Annotation[] annotations = getMethod.getAnnotations();
            return BeanDescriptor.appendQualifiers(qualifiers, annotations);
        }
        catch (NoSuchMethodException e) {
            return qualifiers;
        }
    }

    public static Iterable<Annotation> appendQualifiers(Iterable<Annotation> qualifiers, Class<?> beanClass) {
        return BeanDescriptor.appendQualifiers(qualifiers, beanClass.getAnnotations());
    }

    private static Iterable<Annotation> appendQualifiers(Iterable<Annotation> qualifiers, Annotation[] annotations) {
        Iterable<Annotation> next = null;
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            if (next == null) {
                next = new ArrayList<Annotation>();
                if (qualifiers != null) {
                    Tools.addAll(next, qualifiers);
                }
            }
            next.add((Annotation)annotation);
        }
        return next != null ? next : qualifiers;
    }
}

