/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.beans.Introspector;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;

public class VariableScopeVisitor
extends ClassCodeVisitorSupport {
    private VariableScope currentScope = null;
    private VariableScope headScope = new VariableScope();
    private ClassNode currentClass = null;
    private SourceUnit source;
    private boolean inClosure = false;
    private boolean inPropertyExpression = false;
    private boolean isSpecialConstructorCall = false;
    private boolean inConstructor = false;
    private LinkedList stateStack = new LinkedList();

    public VariableScopeVisitor(SourceUnit source) {
        this.source = source;
        this.currentScope = this.headScope;
    }

    private void pushState(boolean isStatic) {
        this.stateStack.add(new StateStackElement());
        this.currentScope = new VariableScope(this.currentScope);
        this.currentScope.setInStaticContext(isStatic);
    }

    private void pushState() {
        this.pushState(this.currentScope.isInStaticContext());
    }

    private void popState() {
        if (this.inClosure) {
            this.currentScope.setInStaticContext(false);
        }
        StateStackElement element = (StateStackElement)this.stateStack.removeLast();
        this.currentScope = element.scope;
        this.currentClass = element.clazz;
        this.inClosure = element.closure;
        this.inConstructor = element.inConstructor;
    }

    private void declare(Parameter[] parameters, ASTNode node) {
        for (Parameter parameter : parameters) {
            if (parameter.hasInitialExpression()) {
                parameter.getInitialExpression().visit(this);
            }
            this.declare(parameter, node);
        }
    }

    private void declare(VariableExpression vex) {
        vex.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(vex, (ASTNode)vex);
        vex.setAccessedVariable(vex);
    }

    private void declare(Variable var, ASTNode expr) {
        String scopeType = "scope";
        String variableType = "variable";
        if (expr.getClass() == FieldNode.class) {
            scopeType = "class";
            variableType = "field";
        } else if (expr.getClass() == PropertyNode.class) {
            scopeType = "class";
            variableType = "property";
        }
        StringBuffer msg = new StringBuffer();
        msg.append("The current ").append(scopeType);
        msg.append(" already contains a ").append(variableType);
        msg.append(" of the name ").append(var.getName());
        if (this.currentScope.getDeclaredVariable(var.getName()) != null) {
            this.addError(msg.toString(), expr);
            return;
        }
        for (VariableScope scope = this.currentScope.getParent(); scope != null && scope.getClassScope() == null; scope = scope.getParent()) {
            if (scope.getDeclaredVariable(var.getName()) == null) continue;
            this.addError(msg.toString(), expr);
            break;
        }
        this.currentScope.putDeclaredVariable(var);
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private Variable findClassMember(ClassNode cn, String name) {
        if (cn == null) {
            return null;
        }
        if (cn.isScript()) {
            return new DynamicVariable(name, false);
        }
        for (FieldNode fn : cn.getFields()) {
            if (!fn.getName().equals(name)) continue;
            return fn;
        }
        for (MethodNode mn : cn.getMethods()) {
            String pName = this.getPropertyName(mn);
            if (pName == null || !pName.equals(name)) continue;
            return new PropertyNode(pName, mn.getModifiers(), this.getPropertyType(mn), cn, null, null, null);
        }
        for (PropertyNode pn : cn.getProperties()) {
            if (!pn.getName().equals(name)) continue;
            return pn;
        }
        Variable ret = this.findClassMember(cn.getSuperClass(), name);
        if (ret != null) {
            return ret;
        }
        return this.findClassMember(cn.getOuterClass(), name);
    }

    private ClassNode getPropertyType(MethodNode m) {
        if (m.getReturnType() != ClassHelper.VOID_TYPE) {
            return m.getReturnType();
        }
        return m.getParameters()[0].getType();
    }

    private String getPropertyName(MethodNode m) {
        String name = m.getName();
        if (!name.startsWith("set") && !name.startsWith("get")) {
            return null;
        }
        String pname = name.substring(3);
        if (pname.length() == 0) {
            return null;
        }
        pname = Introspector.decapitalize(pname);
        if (name.startsWith("get") && (m.getReturnType() == ClassHelper.VOID_TYPE || m.getParameters().length != 0)) {
            return null;
        }
        if (name.startsWith("set") && m.getParameters().length != 1) {
            return null;
        }
        return pname;
    }

    private Variable checkVariableNameForDeclaration(String name, Expression expression) {
        if ("super".equals(name) || "this".equals(name)) {
            return null;
        }
        VariableScope scope = this.currentScope;
        Variable var = new DynamicVariable(name, this.currentScope.isInStaticContext());
        while (true) {
            Variable var1;
            if ((var1 = scope.getDeclaredVariable(var.getName())) != null) {
                var = var1;
                break;
            }
            var1 = scope.getReferencedLocalVariable(var.getName());
            if (var1 != null) {
                var = var1;
                break;
            }
            var1 = scope.getReferencedClassVariable(var.getName());
            if (var1 != null) {
                var = var1;
                break;
            }
            ClassNode classScope = scope.getClassScope();
            if (classScope != null) {
                Variable member = this.findClassMember(classScope, var.getName());
                if (member == null) break;
                boolean staticScope = this.currentScope.isInStaticContext() || this.isSpecialConstructorCall;
                boolean staticMember = member.isInStaticContext();
                if (staticScope && !staticMember) break;
                var = member;
                break;
            }
            scope = scope.getParent();
        }
        VariableScope end = scope;
        for (scope = this.currentScope; scope != end; scope = scope.getParent()) {
            if (end.isClassScope() || end.isReferencedClassVariable(name) && end.getDeclaredVariable(name) == null) {
                scope.putReferencedClassVariable(var);
                continue;
            }
            var.setClosureSharedVariable(var.isClosureSharedVariable() || this.inClosure);
            scope.putReferencedLocalVariable(var);
        }
        return var;
    }

    private void checkPropertyOnExplicitThis(PropertyExpression pe) {
        if (!this.currentScope.isInStaticContext()) {
            return;
        }
        Expression object = pe.getObjectExpression();
        if (!(object instanceof VariableExpression)) {
            return;
        }
        VariableExpression ve = (VariableExpression)object;
        if (!ve.getName().equals("this")) {
            return;
        }
        String name = pe.getPropertyAsString();
        if (name.equals("class")) {
            return;
        }
        if (name == null) {
            return;
        }
        Variable member = this.findClassMember(this.currentClass, name);
        if (member == null) {
            return;
        }
        this.checkVariableContextAccess(member, pe);
    }

    private void checkVariableContextAccess(Variable v, Expression expr) {
        if (this.inPropertyExpression || v.isInStaticContext() || !this.currentScope.isInStaticContext()) {
            return;
        }
        String msg = v.getName() + " is declared in a dynamic context, but you tried to" + " access it from a static context.";
        this.addError(msg, expr);
        DynamicVariable v2 = new DynamicVariable(v.getName(), this.currentScope.isInStaticContext());
        this.currentScope.putDeclaredVariable(v2);
    }

    public void visitBlockStatement(BlockStatement block) {
        this.pushState();
        block.setVariableScope(this.currentScope);
        super.visitBlockStatement(block);
        this.popState();
    }

    public void visitForLoop(ForStatement forLoop) {
        this.pushState();
        forLoop.setVariableScope(this.currentScope);
        Parameter p = forLoop.getVariable();
        p.setInStaticContext(this.currentScope.isInStaticContext());
        if (p != ForStatement.FOR_LOOP_DUMMY) {
            this.declare(p, (ASTNode)forLoop);
        }
        super.visitForLoop(forLoop);
        this.popState();
    }

    public void visitIfElse(IfStatement ifElse) {
        ifElse.getBooleanExpression().visit(this);
        this.pushState();
        ifElse.getIfBlock().visit(this);
        this.popState();
        this.pushState();
        ifElse.getElseBlock().visit(this);
        this.popState();
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        expression.getRightExpression().visit(this);
        if (expression.isMultipleAssignmentDeclaration()) {
            ArgumentListExpression list = (ArgumentListExpression)expression.getLeftExpression();
            for (Expression e : list.getExpressions()) {
                VariableExpression exp = (VariableExpression)e;
                this.declare(exp);
            }
        } else {
            this.declare(expression.getVariableExpression());
        }
    }

    public void visitVariableExpression(VariableExpression expression) {
        String name = expression.getName();
        Variable v = this.checkVariableNameForDeclaration(name, expression);
        if (v == null) {
            return;
        }
        expression.setAccessedVariable(v);
        this.checkVariableContextAccess(v, expression);
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        boolean ipe = this.inPropertyExpression;
        this.inPropertyExpression = true;
        expression.getObjectExpression().visit(this);
        this.inPropertyExpression = false;
        expression.getProperty().visit(this);
        this.checkPropertyOnExplicitThis(expression);
        this.inPropertyExpression = ipe;
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.pushState();
        this.inClosure = true;
        expression.setVariableScope(this.currentScope);
        if (expression.isParameterSpecified()) {
            Parameter[] parameters;
            for (Parameter parameter : parameters = expression.getParameters()) {
                parameter.setInStaticContext(this.currentScope.isInStaticContext());
                if (parameter.hasInitialExpression()) {
                    parameter.getInitialExpression().visit(this);
                }
                this.declare(parameter, (ASTNode)expression);
            }
        } else if (expression.getParameters() != null) {
            Parameter var = new Parameter(ClassHelper.OBJECT_TYPE, "it");
            var.setInStaticContext(this.currentScope.isInStaticContext());
            this.currentScope.putDeclaredVariable(var);
        }
        super.visitClosureExpression(expression);
        this.popState();
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.pushState();
        Parameter p = statement.getVariable();
        p.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(p, (ASTNode)statement);
        super.visitCatchStatement(statement);
        this.popState();
    }

    public void visitFieldExpression(FieldExpression expression) {
        String name = expression.getFieldName();
        Variable v = this.checkVariableNameForDeclaration(name, expression);
        this.checkVariableContextAccess(v, expression);
    }

    public void visitClass(ClassNode node) {
        InnerClassNode in;
        if (node instanceof InnerClassNode && (in = (InnerClassNode)node).isAnonymous()) {
            return;
        }
        this.pushState();
        this.currentClass = node;
        this.currentScope.setClassScope(node);
        super.visitClass(node);
        this.popState();
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        Parameter[] parameters;
        this.pushState(node.isStatic());
        this.inConstructor = isConstructor;
        node.setVariableScope(this.currentScope);
        this.visitAnnotations(node);
        for (Parameter parameter : parameters = node.getParameters()) {
            this.visitAnnotations(parameter);
        }
        this.declare(node.getParameters(), (ASTNode)node);
        this.visitClassCodeContainer(node.getCode());
        this.popState();
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        if (call.isImplicitThis() && call.getMethod() instanceof ConstantExpression) {
            ConstantExpression methodNameConstant = (ConstantExpression)call.getMethod();
            String value = methodNameConstant.getText();
            if (!(value instanceof String)) {
                throw new GroovyBugError("tried to make a method call with a non-String constant method name.");
            }
            String methodName = value;
            Variable v = this.checkVariableNameForDeclaration(methodName, call);
            if (v != null && !(v instanceof DynamicVariable)) {
                this.checkVariableContextAccess(v, call);
            }
            if (v instanceof VariableExpression || v instanceof Parameter) {
                VariableExpression object = new VariableExpression(v);
                object.setSourcePosition(methodNameConstant);
                call.setObjectExpression(object);
                ConstantExpression method = new ConstantExpression("call");
                method.setSourcePosition(methodNameConstant);
                call.setMethod(method);
            }
        }
        super.visitMethodCallExpression(call);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.isSpecialConstructorCall = call.isSpecialCall();
        super.visitConstructorCallExpression(call);
        this.isSpecialConstructorCall = false;
        if (!call.isUsingAnonymousInnerClass()) {
            return;
        }
        this.pushState();
        InnerClassNode innerClass = (InnerClassNode)call.getType();
        innerClass.setVariableScope(this.currentScope);
        for (MethodNode method : innerClass.getMethods()) {
            Parameter[] parameters = method.getParameters();
            if (parameters.length == 0) {
                parameters = null;
            }
            ClosureExpression cl = new ClosureExpression(parameters, method.getCode());
            this.visitClosureExpression(cl);
        }
        boolean ic = this.inClosure;
        this.inClosure = true;
        for (FieldNode field : innerClass.getFields()) {
            Expression expression = field.getInitialExpression();
            if (expression == null) continue;
            expression.visit(this);
        }
        for (Statement statement : innerClass.getObjectInitializerStatements()) {
            statement.visit(this);
        }
        this.inClosure = ic;
        this.popState();
    }

    public void visitProperty(PropertyNode node) {
        this.pushState(node.isStatic());
        super.visitProperty(node);
        this.popState();
    }

    public void visitField(FieldNode node) {
        this.pushState(node.isStatic());
        super.visitField(node);
        this.popState();
    }

    public void visitAnnotations(AnnotatedNode node) {
        List<AnnotationNode> annotations = node.getAnnotations();
        if (annotations.isEmpty()) {
            return;
        }
        for (AnnotationNode an : annotations) {
            if (an.isBuiltIn()) continue;
            for (Map.Entry<String, Expression> member : an.getMembers().entrySet()) {
                Expression annMemberValue = member.getValue();
                annMemberValue.visit(this);
            }
        }
    }

    private class StateStackElement {
        VariableScope scope;
        ClassNode clazz;
        boolean closure;
        boolean inConstructor;

        StateStackElement() {
            this.scope = VariableScopeVisitor.this.currentScope;
            this.clazz = VariableScopeVisitor.this.currentClass;
            this.closure = VariableScopeVisitor.this.inClosure;
            this.inConstructor = VariableScopeVisitor.this.inConstructor;
        }
    }
}

