/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.js.Block;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.plugin.templates.TemplateCompiler;
import com.google.caja.plugin.templates.TemplateSanitizer;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Lists;
import com.google.caja.util.Multimap;
import com.google.caja.util.Multimaps;
import com.google.caja.util.Pair;
import com.google.caja.util.Pipeline;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CompileHtmlStage
implements Pipeline.Stage<Jobs> {
    private final CssSchema cssSchema;
    private final HtmlSchema htmlSchema;

    public CompileHtmlStage(CssSchema cssSchema, HtmlSchema htmlSchema) {
        if (null == cssSchema) {
            throw new NullPointerException();
        }
        if (null == htmlSchema) {
            throw new NullPointerException();
        }
        this.cssSchema = cssSchema;
        this.htmlSchema = htmlSchema;
    }

    @Override
    public boolean apply(Jobs jobs) {
        Multimap<JobCache.Keys, Job> byKey = Multimaps.newListHashMultimap();
        Iterator<Job> jobIt = jobs.getJobs().iterator();
        while (jobIt.hasNext()) {
            Job job = jobIt.next();
            switch (job.getType()) {
                case CSS: 
                case HTML: {
                    byKey.put(job.getCacheKeys(), job);
                    jobIt.remove();
                    break;
                }
            }
        }
        for (JobCache.Keys cacheKeys : byKey.keySet()) {
            URI baseUri = null;
            List<Pair<Node, URI>> ihtmlRoots = Lists.newArrayList();
            List<CssTree.StyleSheet> stylesheets = Lists.newArrayList();
            block9: for (Job job : byKey.get(cacheKeys)) {
                switch (job.getType()) {
                    case HTML: {
                        ihtmlRoots.add(Pair.pair(((Dom)job.getRoot()).getValue(), job.getBaseUri()));
                        if (baseUri != null) continue block9;
                        baseUri = job.getBaseUri();
                        continue block9;
                    }
                    case CSS: {
                        stylesheets.add((CssTree.StyleSheet)job.getRoot());
                        continue block9;
                    }
                }
                throw new SomethingWidgyHappenedError(job.getType().name());
            }
            if (baseUri == null) {
                baseUri = InputSource.UNKNOWN.getUri();
            }
            MessageQueue mq = jobs.getMessageQueue();
            TemplateSanitizer ts = new TemplateSanitizer(this.htmlSchema, mq);
            for (Pair pair : ihtmlRoots) {
                ts.sanitize((Node)pair.a);
            }
            TemplateCompiler tc = new TemplateCompiler(ihtmlRoots, stylesheets, this.cssSchema, this.htmlSchema, jobs.getPluginMeta(), jobs.getMessageContext(), mq);
            Pair<Node, List<Block>> pair = tc.getSafeHtml(DomParser.makeDocument(null, null));
            Job outJob = this.makeJobFromHtml(cacheKeys, (Node)pair.a, baseUri);
            jobs.getJobs().add(outJob);
            for (Block bl : (List)pair.b) {
                jobs.getJobs().add(Job.jsJob(cacheKeys, bl, baseUri));
            }
        }
        return jobs.hasNoFatalErrors();
    }

    abstract Job makeJobFromHtml(JobCache.Keys var1, Node var2, URI var3);
}

