/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.template;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.template.DigestorService;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.utils.TimeConvertUtils;

public class DigestorServiceImpl
implements DigestorService {
    private static final Log LOG = ExoLogger.getLogger(DigestorServiceImpl.class);
    private static final Pattern LI_PATTERN = Pattern.compile("<li([^>]+)>(.+?)</li>");

    public MessageInfo buildMessage(NotificationContext jobContext, Map<PluginKey, List<NotificationInfo>> notificationData, UserSetting userSetting) {
        MessageInfo messageInfo = null;
        if (notificationData == null || notificationData.size() == 0) {
            return messageInfo;
        }
        long startTime = System.currentTimeMillis();
        try {
            messageInfo = new MessageInfo();
            List activePlugins = jobContext.getPluginSettingService().getActivePluginIds("MAIL_CHANNEL");
            NotificationContext nCtx = NotificationContextImpl.cloneInstance();
            StringWriter writer = new StringWriter();
            AbstractChannel channel = nCtx.getChannelManager().getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
            for (String pluginId : activePlugins) {
                List<NotificationInfo> messages = notificationData.get(PluginKey.key((String)pluginId));
                if (messages == null || messages.size() == 0) continue;
                nCtx.setNotificationInfos(messages);
                channel.getTemplateBuilder(PluginKey.key((String)pluginId)).buildDigest(nCtx, (Writer)writer);
            }
            StringBuffer sb = writer.getBuffer();
            if (sb.length() == 0) {
                return null;
            }
            String digestMessageList = sb.toString();
            int totalDigestMsg = 0;
            Matcher matcher = LI_PATTERN.matcher(digestMessageList);
            String li_attribute = null;
            while (matcher.find()) {
                ++totalDigestMsg;
                li_attribute = matcher.group(1);
            }
            if (totalDigestMsg == 1) {
                int beginIndex = li_attribute.indexOf("margin");
                int endIndex = li_attribute.indexOf(";", beginIndex) + 1;
                String replacedStr = li_attribute.substring(beginIndex, endIndex);
                digestMessageList = digestMessageList.replace(replacedStr, "margin: 0; background-color: #F9F9F9; padding: 15px 20px;");
            }
            DigestInfo digestInfo = new DigestInfo(jobContext, userSetting);
            TemplateContext ctx = TemplateContext.newChannelInstance((ChannelKey)channel.getKey(), (String)digestInfo.getPluginId(), (String)digestInfo.getLocale().getLanguage());
            ctx.put((Object)"FIRSTNAME", (Object)digestInfo.getFirstName());
            ctx.put((Object)"PORTAL_NAME", (Object)digestInfo.getPortalName());
            ctx.put((Object)"PORTAL_HOME", (Object)digestInfo.getPortalHome());
            ctx.put((Object)"PERIOD", (Object)digestInfo.getPeriodType());
            ctx.put((Object)"FROM_TO", (Object)digestInfo.getFromTo());
            String subject = TemplateUtils.processSubject(ctx);
            ctx.put((Object)"FOOTER_LINK", (Object)digestInfo.getFooterLink());
            ctx.put((Object)"DIGEST_MESSAGES_LIST", (Object)digestMessageList);
            ctx.put((Object)"HAS_ONE_MESSAGE", (Object)(totalDigestMsg == 1 ? 1 : 0));
            String body = TemplateUtils.processGroovy(ctx);
            messageInfo.from(NotificationPluginUtils.getFrom(null)).subject(subject).body(body).to(digestInfo.getSendTo());
        }
        catch (Exception e) {
            LOG.error((Object)"Can not build template of DigestorProviderImpl ", (Throwable)e);
            return null;
        }
        LOG.debug((Object)("End build template of DigestorProviderImpl ... " + (System.currentTimeMillis() - startTime) + " ms"));
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        if (stats) {
            NotificationContextFactory.getInstance().getStatisticsCollector().createDigestCount(messageInfo.getPluginId());
        }
        return messageInfo;
    }

    private class DigestInfo {
        private String firstName;
        private String portalName;
        private String portalHome;
        private String sendTo;
        private String footerLink;
        private String fromTo;
        private String periodType;
        private String pluginId;
        private Locale locale;
        private Boolean isWeekly;

        public DigestInfo(NotificationContext context, UserSetting userSetting) {
            this.periodType = this.fromTo = "Today";
            this.pluginId = "DigestDailyPlugin";
            this.firstName = NotificationPluginUtils.getFirstName((String)userSetting.getUserId());
            this.sendTo = NotificationPluginUtils.getTo((String)userSetting.getUserId());
            this.portalName = NotificationPluginUtils.getBrandingPortalName();
            String language = NotificationPluginUtils.getLanguage((String)userSetting.getUserId());
            this.portalHome = NotificationUtils.getPortalHome(this.portalName);
            this.footerLink = NotificationUtils.getProfileUrl(userSetting.getUserId());
            this.locale = NotificationUtils.getLocale(language);
            this.isWeekly = (Boolean)context.value(NotificationJob.JOB_WEEKLY);
            if (this.isWeekly.booleanValue() && userSetting.getWeeklyPlugins().size() > 0) {
                this.pluginId = "DigestWeeklyPlugin";
                this.periodType = "Weekly";
                Calendar periodFrom = userSetting.getLastUpdateTime();
                long t = System.currentTimeMillis() - 604800000L;
                if (t > periodFrom.getTimeInMillis()) {
                    periodFrom.setTimeInMillis(t);
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(TimeConvertUtils.getFormatDate((Date)periodFrom.getTime(), (String)"mmmm dd", (Locale)this.locale)).append(" - ").append(TimeConvertUtils.getFormatDate((Date)Calendar.getInstance().getTime(), (String)"mmmm dd, yyyy", (Locale)this.locale));
                this.fromTo = buffer.toString();
            }
        }

        public String getFromTo() {
            return this.fromTo;
        }

        public String getPeriodType() {
            return this.periodType;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getPortalName() {
            return this.portalName;
        }

        public String getPortalHome() {
            return this.portalHome;
        }

        public String getSendTo() {
            return this.sendTo;
        }

        public String getFooterLink() {
            return this.footerLink;
        }

        public Boolean isWeekly() {
            return this.isWeekly;
        }
    }
}

