/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class CalendarDataInitialize
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(CalendarDataInitialize.class);
    public static final String ANY = "*.*".intern();
    public static final String SLASH_COLON = "/:".intern();
    public static final String SLASH = "/".intern();
    public static final String COLON = ":".intern();
    public static final String SPLITER = "://".intern();
    public static final String PUBLIC_TYPE = "2".intern();
    public static final String SPACE_CALENDAR_ID_SUFFIX = "_space_calendar";
    private final InitParams params;

    public CalendarDataInitialize(InitParams params) {
        this.params = params;
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        String portletName = "";
        if (this.params.getValueParam("portletName") != null) {
            portletName = this.params.getValueParam("portletName").getValue();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initparam is not configured for portletName property");
        }
        if (!portletName.equals(event.getSource())) {
            return;
        }
        try {
            Calendar calendar;
            String calendarId;
            String groupId;
            CalendarService calService;
            Space space;
            block9: {
                space = event.getSpace();
                calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                groupId = space.getGroupId();
                calendarId = Utils.getCalendarIdFromSpace((String)groupId);
                calendar = null;
                try {
                    calendar = calService.getGroupCalendar(calendarId);
                }
                catch (Exception pfe) {
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.warn((Object)("Desired calendar for " + space.getPrettyName() + " is not exist, create a new calendar."));
                }
            }
            if (calendar == null) {
                calendar = new Calendar();
                calendar.setId(calendarId);
                calendar.setPublic(false);
                calendar.setGroups(new String[]{space.getGroupId()});
                calendar.setName(space.getDisplayName());
                calendar.setEditPermission(new String[]{space.getGroupId() + SLASH_COLON + ANY});
                calendar.setCalendarOwner(groupId);
                calendar.setCalendarColor(Calendar.COLORS[0]);
                calService.savePublicCalendar(calendar, true);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Couldn't save calendar to public area (group calendar).\n Cause by: ", (Throwable)e);
        }
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
        Space space = event.getSpace();
        String calendarId = Utils.getCalendarIdFromSpace((String)space.getGroupId());
        Calendar calendar = null;
        try {
            calendar = calService.getGroupCalendar(calendarId);
            calendar.setName(space.getDisplayName());
            calService.savePublicCalendar(calendar, false);
        }
        catch (Exception pfe) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)("Can not rename calendar " + space.getDisplayName()));
            }
            return;
        }
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }
}

