/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest.services.SuggestPeoplePortlet;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/homepage/intranet/people/")
@Produces(value={"application/json"})
public class PeopleRestServices
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(PeopleRestServices.class);
    private static final CacheControl cacheControl;
    private static final String DEFAULT_AVATAR = "/eXoSkin/skin/images/themes/default/social/skin/ShareImages/UserAvtDefault.png";
    private UserACL userACL;
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;

    public PeopleRestServices(UserACL userACL, IdentityManager identityManager, RelationshipManager relationshipManager) {
        this.userACL = userACL;
        this.identityManager = identityManager;
        this.relationshipManager = relationshipManager;
    }

    @GET
    @Path(value="contacts/pending")
    public Response getPending(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            List relations = this.relationshipManager.getPending(identity);
            JSONArray jsonArray = new JSONArray();
            for (Relationship relation : relations) {
                Identity senderId = relation.getSender();
                Profile senderProfile = senderId.getProfile();
                Identity receiverId = relation.getReceiver();
                Profile receiverProfile = receiverId.getProfile();
                JSONObject json = new JSONObject();
                json.put("senderName", (Object)senderProfile.getFullName());
                json.put("senderId", (Object)senderId.getId());
                json.put("receiverName", (Object)receiverProfile.getFullName());
                json.put("receiverId", (Object)receiverId.getId());
                json.put("status", (Object)relation.getStatus());
                jsonArray.put((Object)json);
            }
            return Response.ok((Object)jsonArray.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in people pending rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="contacts/incoming")
    public Response getIncoming(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            List relations = this.relationshipManager.getIncoming(identity);
            JSONArray jsonArray = new JSONArray();
            for (Relationship relation : relations) {
                Identity senderId = relation.getSender();
                String avatar = senderId.getProfile().getAvatarImageSource();
                if (avatar == null) {
                    avatar = "/eXoSkin/skin/images/system/Avatar.gif";
                }
                JSONObject json = new JSONObject();
                json.put("senderName", (Object)senderId.getProfile().getFullName());
                json.put("relationId", (Object)relation.getId());
                json.put("avatar", (Object)avatar);
                json.put("profile", (Object)senderId.getProfile().getUrl());
                jsonArray.put((Object)json);
            }
            return Response.ok((Object)jsonArray.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in people incoming rest service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="contacts/confirm/{relationId}")
    public Response confirm(@PathParam(value="relationId") String relationId, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            log.debug((Object)"request accepted.");
            this.relationshipManager.confirm(this.relationshipManager.getRelationshipById(relationId));
            return Response.ok((Object)"Confirmed", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in people accept rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="contacts/deny/{relationId}")
    public Response deny(@PathParam(value="relationId") String relationId, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            this.relationshipManager.deny(this.relationshipManager.getRelationshipById(relationId));
            return Response.ok((Object)"Denied", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in people deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="contacts/connect/{relationId}")
    public Response connect(@PathParam(value="relationId") String relationId, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId);
            this.relationshipManager.invite(identity, this.identityManager.getIdentity(relationId));
            return Response.ok((Object)"Connected", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in people connect rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"Error", (String)"application/json").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="contacts/suggestions")
    public Response getSuggestions(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            Map<Identity, Integer> suggestions;
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId, false);
            ListAccess connectionList = this.relationshipManager.getConnections(identity);
            int size = connectionList.getSize();
            if (size > 0) {
                suggestions = this.relationshipManager.getSuggestions(identity, 20, 50, 10);
                if (suggestions.size() == 1 && ((Identity)suggestions.keySet().iterator().next()).getRemoteId().equals(this.userACL.getSuperUser())) {
                    suggestions = Collections.emptyMap();
                }
            } else {
                suggestions = Collections.emptyMap();
            }
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            if (suggestions.isEmpty()) {
                List identities = this.identityManager.getLastIdentities(10);
                suggestions = new HashMap();
                for (Identity id : identities) {
                    if (identity.equals((Object)id) || this.relationshipManager.get(identity, id) != null) continue;
                    suggestions.put(id, new Integer(0));
                }
            }
            for (Map.Entry suggestion : suggestions.entrySet()) {
                String position;
                Identity id;
                id = (Identity)suggestion.getKey();
                if (id.getRemoteId().equals(this.userACL.getSuperUser())) continue;
                JSONObject json = new JSONObject();
                Profile socialProfile = id.getProfile();
                String avatar = socialProfile.getAvatarUrl();
                if (avatar == null) {
                    avatar = DEFAULT_AVATAR;
                }
                if ((position = socialProfile.getPosition()) == null) {
                    position = "";
                }
                json.put("suggestionName", (Object)socialProfile.getFullName());
                json.put("suggestionId", (Object)id.getId());
                json.put("contacts", this.relationshipManager.getConnections(id).getSize());
                json.put("avatar", (Object)avatar);
                json.put("profile", (Object)socialProfile.getUrl());
                json.put("title", (Object)position);
                json.put("number", suggestion.getValue());
                json.put("createdDate", socialProfile.getCreatedTime());
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("items", (Object)jsonArray);
            jsonGlobal.put("noConnections", size);
            return Response.ok((Object)jsonGlobal.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in getting GS progress: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (NullPointerException e) {
            return this.getViewerId(uriInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getViewerId(UriInfo uriInfo) {
        String[] queryParts;
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        for (String queryPart : queryParts = requestString.split("&")) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            return queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
        }
        return null;
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }
}

