/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;

public class CacheUserProfileFilter
extends AbstractFilter {
    public static final String USER_PROFILE = "UserProfile";
    private static Log log = ExoLogger.getLogger(CacheUserProfileFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException {
        ConversationState state = ConversationState.getCurrent();
        try {
            if (state != null && !state.getIdentity().getUserId().equals(IdentityConstants.ANONIM)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Conversation State found, save user profile to Conversation State.");
                }
                if (state.getAttribute(USER_PROFILE) == null) {
                    OrganizationService orgService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
                    this.begin(orgService);
                    User user = null;
                    try {
                        user = orgService.getUserHandler().findUserByName(state.getIdentity().getUserId());
                    }
                    finally {
                        this.end(orgService);
                    }
                    state.setAttribute(USER_PROFILE, (Object)user);
                }
            }
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            log.warn((Object)"An error occured while cache user profile", (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void begin(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    public void end(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

