/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataMoveVisitor
extends ItemDataTraversingVisitor {
    protected List<ItemState> deleteStates = new ArrayList<ItemState>();
    private InternalQName destNodeName;
    protected Stack<NodeData> parents;
    protected NodeData srcParent;
    protected List<ItemState> addStates = new ArrayList<ItemState>();
    protected boolean keepIdentifiers;
    protected NodeTypeDataManager ntManager;
    protected QPath ancestorToSave;
    protected Boolean triggerEventsForDescendants;
    private int maxDescendantNodesAllowed;
    private int totalVisitedNodes;
    private int sizeOfAddStatesAfterRootLevel;
    private int sizeOfDeleteStatesAfterRootLevel;
    private ItemState pathChangedState;

    public ItemDataMoveVisitor(NodeData parent, InternalQName dstNodeName, NodeData srcParent, NodeTypeDataManager nodeTypeManager, SessionDataManager srcDataManager, boolean keepIdentifiers, Boolean triggerEventsForDescendants, int maxDescendantNodesAllowed) {
        super(srcDataManager, triggerEventsForDescendants == null || triggerEventsForDescendants != false ? -1 : 0);
        this.keepIdentifiers = keepIdentifiers;
        this.ntManager = nodeTypeManager;
        this.destNodeName = dstNodeName;
        this.parents = new Stack();
        this.parents.add(parent);
        this.srcParent = srcParent;
        this.triggerEventsForDescendants = triggerEventsForDescendants;
        this.maxDescendantNodesAllowed = maxDescendantNodesAllowed;
    }

    @Override
    protected void entering(NodeData node, int level) throws RepositoryException {
        int destOrderNum;
        int destIndex;
        InternalQName qname;
        if (this.ancestorToSave == null) {
            this.ancestorToSave = QPath.getCommonAncestorPath(this.curParent().getQPath(), node.getQPath());
        }
        NodeData destParent = this.curParent();
        if (level == 0) {
            List<NodeData> srcChilds;
            qname = this.destNodeName;
            List<NodeData> destChilds = this.dataManager.getChildNodesData(destParent);
            destIndex = 1;
            destOrderNum = 0;
            for (NodeData child : destChilds) {
                if (child.getOrderNumber() + 1 <= destOrderNum) continue;
                destOrderNum = child.getOrderNumber() + 1;
            }
            if (destParent == this.srcParent) {
                srcChilds = destChilds;
            } else {
                srcChilds = this.dataManager.getChildNodesData(this.srcParent);
                for (NodeData dchild : destChilds) {
                    if (!dchild.getQPath().getName().equals((Object)this.destNodeName)) continue;
                    ++destIndex;
                }
            }
            int srcIndex = 1;
            for (int i = 0; i < srcChilds.size(); ++i) {
                NodeData child = srcChilds.get(i);
                if (child.getIdentifier().equals(node.getIdentifier())) continue;
                if (child.getQPath().getName().getAsString().equals(node.getQPath().getName().getAsString())) {
                    int persistedVersion = child.getPersistedVersion();
                    if (srcIndex == node.getQPath().getIndex() && persistedVersion == node.getPersistedVersion() - 1) {
                        ++persistedVersion;
                    }
                    QPath siblingPath = QPath.makeChildPath(this.srcParent.getQPath(), child.getQPath().getName(), srcIndex);
                    TransientNodeData sibling = new TransientNodeData(siblingPath, child.getIdentifier(), persistedVersion, child.getPrimaryTypeName(), child.getMixinTypeNames(), child.getOrderNumber(), child.getParentIdentifier(), child.getACL());
                    this.addStates.add(new ItemState(sibling, 2, true, this.ancestorToSave, false, true));
                    ++srcIndex;
                }
                if (srcChilds != destChilds || !child.getQPath().getName().equals((Object)this.destNodeName)) continue;
                ++destIndex;
            }
        } else {
            qname = node.getQPath().getName();
            destIndex = node.getQPath().getIndex();
            destOrderNum = node.getOrderNumber();
        }
        String id = this.keepIdentifiers ? node.getIdentifier() : IdGenerator.generate();
        QPath qpath = QPath.makeChildPath(destParent.getQPath(), qname, destIndex);
        AccessControlList acl = destParent.getACL();
        boolean isPrivilegeable = this.ntManager.isNodeType(Constants.EXO_PRIVILEGEABLE, node.getPrimaryTypeName(), node.getMixinTypeNames());
        boolean isOwneable = this.ntManager.isNodeType(Constants.EXO_OWNEABLE, node.getPrimaryTypeName(), node.getMixinTypeNames());
        if (isPrivilegeable || isOwneable) {
            ArrayList<AccessControlEntry> permissionEntries = new ArrayList<AccessControlEntry>();
            permissionEntries.addAll((isPrivilegeable ? node.getACL() : destParent.getACL()).getPermissionEntries());
            String owner = isOwneable ? node.getACL().getOwner() : destParent.getACL().getOwner();
            acl = new AccessControlList(owner, permissionEntries);
        }
        TransientNodeData newNode = new TransientNodeData(qpath, id, -1, node.getPrimaryTypeName(), node.getMixinTypeNames(), destOrderNum, destParent.getIdentifier(), acl);
        this.parents.push(newNode);
        this.addStates.add(new ItemState(newNode, 32, level == 0, this.ancestorToSave, false, level == 0));
        this.deleteStates.add(new ItemState(node, 4, level == 0, this.ancestorToSave, false, false));
        if (this.triggerEventsForDescendants == null) {
            if (level == 0) {
                this.sizeOfAddStatesAfterRootLevel = this.addStates.size();
                this.sizeOfDeleteStatesAfterRootLevel = this.deleteStates.size();
                this.pathChangedState = new ItemState(newNode, 64, false, this.ancestorToSave, false, false, node.getQPath());
            }
            if (!this.isInterrupted() && ++this.totalVisitedNodes > this.maxDescendantNodesAllowed) {
                int i;
                this.interrupted = true;
                for (i = this.addStates.size() - 1; i >= this.sizeOfAddStatesAfterRootLevel; --i) {
                    this.addStates.remove(i);
                }
                for (i = this.deleteStates.size() - 1; i >= this.sizeOfDeleteStatesAfterRootLevel; --i) {
                    this.deleteStates.remove(i);
                }
                this.addStates.add(0, this.pathChangedState);
            }
        } else if (!this.triggerEventsForDescendants.booleanValue()) {
            this.addStates.add(0, new ItemState(newNode, 64, false, this.ancestorToSave, false, false, node.getQPath()));
        }
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        List<ValueData> values;
        InternalQName qname = property.getQPath().getName();
        if (this.ntManager.isNodeType(Constants.MIX_REFERENCEABLE, this.curParent().getPrimaryTypeName(), this.curParent().getMixinTypeNames()) && qname.equals((Object)Constants.JCR_UUID)) {
            values = new ArrayList<ValueData>(1);
            values.add(new TransientValueData(this.curParent().getIdentifier()));
        } else {
            values = property.getValues();
        }
        TransientPropertyData newProperty = new TransientPropertyData(QPath.makeChildPath(this.curParent().getQPath(), qname), this.keepIdentifiers ? property.getIdentifier() : IdGenerator.generate(), -1, property.getType(), this.curParent().getIdentifier(), property.isMultiValued(), values);
        this.addStates.add(new ItemState(newProperty, 32, false, this.ancestorToSave, false, false));
        this.deleteStates.add(new ItemState(property, 4, false, this.ancestorToSave, false, false));
    }

    public List<ItemState> getAllStates() {
        List<ItemState> list = this.getItemDeletedStates(true);
        list.addAll(this.getItemAddStates());
        return list;
    }

    public List<ItemState> getItemDeletedStates(boolean isInverse) {
        if (isInverse) {
            Collections.reverse(this.deleteStates);
        }
        return this.deleteStates;
    }

    protected NodeData curParent() {
        return this.parents.peek();
    }

    @Override
    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    @Override
    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.parents.pop();
    }

    public List<ItemState> getItemAddStates() {
        return this.addStates;
    }
}

