/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.dataflow.NameValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public class NamePersistedValueData
extends NameValueData
implements PersistedValueData {
    public NamePersistedValueData() {
        super(0, null);
    }

    public NamePersistedValueData(int orderNumber, InternalQName value) {
        super(orderNumber, value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderNumber = in.readInt();
        byte[] data = new byte[in.readInt()];
        if (data.length > 0) {
            in.readFully(data);
            try {
                this.value = InternalQName.parse(new String(data, "UTF-8"));
            }
            catch (IllegalNameException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.orderNumber);
        byte[] data = this.value.getAsString().getBytes("UTF-8");
        out.writeInt(data.length);
        if (data.length > 0) {
            out.write(data);
        }
    }
}

