/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.account;

import java.util.Collection;
import javax.servlet.http.HttpSession;
import org.exoplatform.portal.account.UIAccountSetting;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;
import org.gatein.security.oauth.spi.AccessTokenContext;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;
import org.gatein.security.oauth.spi.SocialNetworkService;

@ComponentConfig(lifecycle=Lifecycle.class, template="system:/groovy/portal/webui/portal/UIAccountSocial.gtmpl", events={@EventConfig(listeners={UnlinkSocialAccountActionListener.class})})
public class UIAccountSocial
extends UIForm {
    private static final Logger log = LoggerFactory.getLogger(UIAccountSocial.class);
    private static final String PARAM_PROVIDER_FOR_UNLINK = "_paramProviderForUnlink";

    public UIAccountSocial() throws Exception {
        for (OAuthProviderType oauthPrType : this.getOAuthProviderTypes()) {
            UIFormStringInput uiInput = new UIFormStringInput(oauthPrType.getUserNameAttrName(), null);
            uiInput.setReadOnly(true);
            this.addUIFormInput((UIFormInput)uiInput);
        }
        this.updateUIFields();
    }

    public Collection<OAuthProviderType> getOAuthProviderTypes() {
        return ((OAuthProviderTypeRegistry)this.getApplicationComponent(OAuthProviderTypeRegistry.class)).getEnabledOAuthProviders();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.updateUIFields();
        super.processRender(context);
    }

    void requestActive() {
        UIAccountSetting uiAccountSetting = (UIAccountSetting)this.getAncestorOfType(UIAccountSetting.class);
        if (uiAccountSetting != null) {
            uiAccountSetting.setActiveChildId(this.getId());
        }
    }

    private void updateUIFields() {
        UserProfile userProfile = (UserProfile)Util.getPortalRequestContext().getAttribute("PortalUserProfile");
        if (userProfile == null) {
            return;
        }
        for (OAuthProviderType oauthPrType : this.getOAuthProviderTypes()) {
            String usernameAttrName = oauthPrType.getUserNameAttrName();
            String oauthUsername = userProfile.getAttribute(usernameAttrName);
            this.getUIStringInput(usernameAttrName).setValue((Object)oauthUsername);
        }
    }

    public void saveURLAfterLinkSocialAccount() {
        PortalRequestContext prContext = Util.getPortalRequestContext();
        HttpSession session = prContext.getRequest().getSession();
        session.setAttribute("_urlToRedirectAfterLinkSocialAccount", (Object)prContext.getRequestURI());
    }

    public String getLinkSocialAccountURL(OAuthProviderType oauthPrType) {
        PortalRequestContext prc = Util.getPortalRequestContext();
        String requestURI = prc.getRequestURI() + "?" + "accountSettingActiveTab" + "=" + this.getId();
        return oauthPrType.getInitOAuthURL(prc.getRequestContextPath(), requestURI);
    }

    public String getUnlinkSocialAccountURL(OAuthProviderType oauthPrType) throws Exception {
        Parameter[] params = new Parameter[]{new Parameter(PARAM_PROVIDER_FOR_UNLINK, oauthPrType.getKey())};
        return super.event("UnlinkSocialAccount", null, params);
    }

    public static class UnlinkSocialAccountActionListener
    extends EventListener<UIAccountSocial> {
        public void execute(Event<UIAccountSocial> event) throws Exception {
            UIAccountSocial uiForm = (UIAccountSocial)((Object)event.getSource());
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIApplication uiApp = context.getUIApplication();
            uiForm.requestActive();
            ConversationState state = ConversationState.getCurrent();
            String userName = ((User)state.getAttribute("UserProfile")).getUserName();
            User user = service.getUserHandler().findUserByName(userName);
            if (user != null) {
                UserProfile userProfile = (UserProfile)prContext.getAttribute("PortalUserProfile");
                String unlinkProviderKey = prContext.getRequestParameter(UIAccountSocial.PARAM_PROVIDER_FOR_UNLINK);
                OAuthProviderType oauthProviderTypeToUnlink = ((OAuthProviderTypeRegistry)uiForm.getApplicationComponent(OAuthProviderTypeRegistry.class)).getOAuthProvider(unlinkProviderKey, AccessTokenContext.class);
                AccessTokenContext accessToken = ((SocialNetworkService)uiForm.getApplicationComponent(SocialNetworkService.class)).getOAuthAccessToken(oauthProviderTypeToUnlink, userName);
                if (oauthProviderTypeToUnlink != null) {
                    userProfile.setAttribute(oauthProviderTypeToUnlink.getUserNameAttrName(), null);
                } else {
                    log.warn((Object)"Social account field to unlink not found");
                }
                service.getUserProfileHandler().saveUserProfile(userProfile, true);
                if (accessToken != null) {
                    try {
                        oauthProviderTypeToUnlink.getOauthProviderProcessor().revokeToken(accessToken);
                    }
                    catch (OAuthException oe) {
                        if (OAuthExceptionCode.TOKEN_REVOCATION_FAILED.equals((Object)oe.getExceptionCode())) {
                            Throwable t = oe.getCause() != null ? oe.getCause() : oe;
                            ApplicationMessage appMessage = new ApplicationMessage("UIAccountSocial.msg.failed-revoke", null, 1);
                            appMessage.setArgsLocalized(false);
                            uiApp.addMessage(appMessage);
                            log.warn((Object)("Revocation of accessToken failed for user " + userName + ". Details: " + t.getClass() + ": " + t.getMessage()));
                        }
                        throw oe;
                    }
                }
                Object[] args = new Object[]{oauthProviderTypeToUnlink.getFriendlyName(), userName};
                ApplicationMessage appMessage = new ApplicationMessage("UIAccountSocial.msg.successful-unlink", args);
                appMessage.setArgsLocalized(false);
                uiApp.addMessage(appMessage);
                prContext.setAttribute("PortalUserProfile", userProfile);
                uiForm.updateUIFields();
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiForm);
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChild(UIWorkingWorkspace.class);
                uiWorkingWS.updatePortletsByName("UserInfoPortlet");
                uiWorkingWS.updatePortletsByName("OrganizationPortlet");
            } else {
                JavascriptManager jsManager = Util.getPortalRequestContext().getJavascriptManager();
                jsManager.require("SHARED/base").addScripts("if(confirm('" + Util.getPortalRequestContext().getApplicationResourceBundle().getString("UIAccountProfiles.msg.NotExistingAccount") + "')) {eXo.portal.logout();}");
            }
        }
    }
}

