/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.util.SAXHelper;
import org.exoplatform.commons.utils.QName;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OpenOfficeDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.OpenOfficeDocumentReader");

    public String[] getMimeTypes() {
        return new String[]{"application/vnd.oasis.opendocument.database", "application/vnd.oasis.opendocument.formula", "application/vnd.oasis.opendocument.graphics", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.text"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        try {
            String string;
            ZipEntry ze;
            ZipInputStream zis;
            block25: {
                zis = new ZipInputStream(is);
                ze = zis.getNextEntry();
                if (ze != null) break block25;
                String string2 = "";
                try {
                    zis.close();
                    return string2;
                }
                catch (IOException e) {
                    if (!LOG.isTraceEnabled()) return string2;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
                return string2;
            }
            try {
                while (!ze.getName().equals("content.xml")) {
                    ze = zis.getNextEntry();
                }
                OpenOfficeContentHandler contentHandler = new OpenOfficeContentHandler();
                XMLReader xmlReader = SAXHelper.newXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                xmlReader.setContentHandler(contentHandler);
                xmlReader.parse(new InputSource(zis));
                string = contentHandler.getContent();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zis.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) throw throwable;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException e) {
                    throw new DocumentReadException(e.getMessage(), e);
                }
                catch (SAXException e) {
                    throw new DocumentReadException(e.getMessage(), e);
                }
            }
            try {
                zis.close();
                return string;
            }
            catch (IOException e) {
                if (!LOG.isTraceEnabled()) return string;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
            return string;
        }
        finally {
            block26: {
                try {
                    is.close();
                }
                catch (IOException e) {
                    if (!LOG.isTraceEnabled()) break block26;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
        }
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        try {
            Properties properties;
            ZipInputStream zis = new ZipInputStream(is);
            try {
                ZipEntry ze = zis.getNextEntry();
                while (!ze.getName().equals("meta.xml")) {
                    ze = zis.getNextEntry();
                }
                OpenOfficeMetaHandler metaHandler = new OpenOfficeMetaHandler();
                XMLReader xmlReader = SAXHelper.newXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader.setContentHandler(metaHandler);
                xmlReader.parse(new InputSource(zis));
                properties = metaHandler.getProperties();
            }
            catch (Throwable throwable) {
                try {
                    zis.close();
                    throw throwable;
                }
                catch (ParserConfigurationException e) {
                    throw new DocumentReadException(e.getMessage(), e);
                }
                catch (SAXException e) {
                    throw new DocumentReadException(e.getMessage(), e);
                }
            }
            zis.close();
            return properties;
        }
        finally {
            block15: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block15;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
    }

    private class OpenOfficeMetaHandler
    extends DefaultHandler {
        private Properties props = new Properties();
        private QName curPropertyName;
        private StringBuilder curPropertyValue = new StringBuilder();

        public Properties getProperties() {
            return this.props;
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (namespaceURI.equals("http://purl.org/dc/elements/1.1/")) {
                this.curPropertyName = new QName("http://purl.org/dc/elements/1.1/", localName);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.curPropertyName != null) {
                this.curPropertyValue.append(ch, start, length);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.curPropertyName != null) {
                this.props.put(this.curPropertyName, this.curPropertyValue.toString());
                this.curPropertyValue = new StringBuilder();
                this.curPropertyName = null;
            }
        }
    }

    private class OpenOfficeContentHandler
    extends DefaultHandler {
        private StringBuilder content = new StringBuilder();
        private boolean appendChar = false;

        public String getContent() {
            return this.content.toString();
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            if (rawName.startsWith("text:")) {
                this.appendChar = true;
                if (this.content.length() > 0) {
                    this.content.append(' ');
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.appendChar) {
                this.content.append(ch, start, length);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.appendChar = false;
        }
    }
}

