/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms.scripts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBCleaningScripts {
    protected String itemTableName;
    protected String valueTableName;
    protected String refTableName;
    protected String itemTableSuffix;
    protected String valueTableSuffix;
    protected String refTableSuffix;
    protected boolean useSequence;
    protected final String dialect;
    protected final String workspaceName;
    protected final boolean multiDb;
    protected final List<String> cleaningScripts = new ArrayList<String>();
    protected final List<String> committingScripts = new ArrayList<String>();
    protected final List<String> rollbackingScripts = new ArrayList<String>();
    protected final WorkspaceEntry wsEntry;

    DBCleaningScripts(String dialect, RepositoryEntry rEntry) throws DBCleanException {
        for (WorkspaceEntry wsEntry : rEntry.getWorkspaceEntries()) {
            try {
                if (!DBInitializerHelper.getDatabaseType(wsEntry).isMultiDatabase()) continue;
                throw new DBCleanException("Not supported operation.");
            }
            catch (RepositoryConfigurationException e) {
                throw new DBCleanException(e);
            }
        }
        this.multiDb = false;
        this.workspaceName = null;
        this.dialect = dialect;
        this.wsEntry = rEntry.getWorkspaceEntries().get(0);
        this.initTableNames(this.wsEntry);
    }

    DBCleaningScripts(String dialect, WorkspaceEntry wsEntry) throws DBCleanException {
        try {
            this.multiDb = DBInitializerHelper.getDatabaseType(wsEntry).isMultiDatabase();
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanException(e);
        }
        this.workspaceName = wsEntry.getName();
        this.dialect = dialect;
        this.wsEntry = wsEntry;
        this.initTableNames(wsEntry);
    }

    public Collection<String> getCleaningScripts() {
        return this.cleaningScripts;
    }

    public Collection<String> getCommittingScripts() {
        return this.committingScripts;
    }

    public Collection<String> getRollbackingScripts() {
        return this.rollbackingScripts;
    }

    protected void prepareRenamingApproachScripts() throws DBCleanException {
        this.cleaningScripts.addAll(this.getTablesRenamingScripts());
        this.cleaningScripts.addAll(this.getDBInitializationScripts());
        this.cleaningScripts.addAll(this.getFKRemovingScripts());
        this.cleaningScripts.addAll(this.getConstraintsRemovingScripts());
        this.cleaningScripts.addAll(this.getIndexesDroppingScripts());
        this.committingScripts.addAll(this.getOldTablesDroppingScripts());
        this.committingScripts.addAll(this.getIndexesAddingScripts());
        this.committingScripts.addAll(this.getConstraintsAddingScripts());
        this.committingScripts.addAll(this.getFKAddingScripts());
        this.rollbackingScripts.addAll(this.getTablesDroppingScripts());
        this.rollbackingScripts.addAll(this.getOldTablesRenamingScripts());
    }

    protected void prepareDroppingTablesApproachScripts() throws DBCleanException {
        this.cleaningScripts.addAll(this.getTablesDroppingScripts());
        this.cleaningScripts.addAll(this.getDBInitializationScripts());
        this.cleaningScripts.addAll(this.getFKRemovingScripts());
        this.cleaningScripts.addAll(this.getIndexesDroppingScripts());
        this.committingScripts.addAll(this.getIndexesAddingScripts());
        this.committingScripts.addAll(this.getFKAddingScripts());
    }

    protected void prepareSimpleCleaningApproachScripts() {
        this.cleaningScripts.addAll(this.getFKRemovingScripts());
        this.cleaningScripts.addAll(this.getSingleDbWorkspaceCleaningScripts());
        this.committingScripts.addAll(this.getFKAddingScripts());
        this.rollbackingScripts.addAll(this.getFKAddingScripts());
    }

    protected Collection<String> getConstraintsAddingScripts() {
        return new ArrayList<String>();
    }

    protected Collection<String> getConstraintsRemovingScripts() {
        return new ArrayList<String>();
    }

    protected Collection<String> getOldTablesRenamingScripts() throws DBCleanException {
        return new ArrayList<String>();
    }

    protected Collection<String> getTablesRenamingScripts() {
        return new ArrayList<String>();
    }

    protected Collection<String> getIndexesDroppingScripts() {
        return new ArrayList<String>();
    }

    protected Collection<String> getIndexesAddingScripts() throws DBCleanException {
        return new ArrayList<String>();
    }

    protected Collection<String> getFKRemovingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        String constraintName = "JCR_FK_" + this.itemTableSuffix + "_PARENT";
        scripts.add("ALTER TABLE " + this.itemTableName + " " + this.constraintDroppingSyntax() + " " + constraintName);
        return scripts;
    }

    protected Collection<String> getFKAddingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        String constraintName = "JCR_FK_" + this.itemTableSuffix + "_PARENT FOREIGN KEY(PARENT_ID) REFERENCES " + this.itemTableName + "(ID)";
        scripts.add("ALTER TABLE " + this.itemTableName + " ADD CONSTRAINT " + constraintName);
        return scripts;
    }

    protected Collection<String> getOldTablesDroppingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("DROP TABLE " + this.valueTableName + "_OLD");
        scripts.add("DROP TABLE " + this.refTableName + "_OLD");
        scripts.add("DROP TABLE " + this.itemTableName + "_OLD");
        return scripts;
    }

    protected Collection<String> getTablesDroppingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("DROP TABLE " + this.valueTableName);
        scripts.add("DROP TABLE " + this.refTableName);
        scripts.add("DROP TABLE " + this.itemTableName);
        return scripts;
    }

    protected Collection<String> getSingleDbWorkspaceCleaningScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("delete from JCR_SVALUE where PROPERTY_ID IN (select ID from JCR_SITEM where CONTAINER_NAME='" + this.workspaceName + "')");
        scripts.add("delete from JCR_SREF where PROPERTY_ID IN (select ID from JCR_SITEM where CONTAINER_NAME='" + this.workspaceName + "')");
        scripts.add("delete from JCR_SITEM where CONTAINER_NAME='" + this.workspaceName + "'");
        return scripts;
    }

    protected Collection<String> getDBInitializationScripts() throws DBCleanException {
        String dbScripts;
        try {
            dbScripts = DBInitializerHelper.prepareScripts(this.wsEntry, this.dialect);
        }
        catch (IOException e) {
            throw new DBCleanException(e);
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanException(e);
        }
        ArrayList<String> scripts = new ArrayList<String>();
        for (String query : JDBCUtils.splitWithSQLDelimiter((String)dbScripts)) {
            if (query.contains(this.itemTableName + "_SEQ") || query.contains(this.itemTableName + "_NEXT_VAL")) continue;
            scripts.add(JDBCUtils.cleanWhitespaces((String)query));
        }
        scripts.add(DBInitializerHelper.getRootNodeInitializeScript(this.itemTableName, this.multiDb));
        return scripts;
    }

    protected String constraintDroppingSyntax() {
        return "DROP CONSTRAINT";
    }

    private void initTableNames(WorkspaceEntry wsConfig) throws DBCleanException {
        try {
            this.itemTableName = DBInitializerHelper.getItemTableName(wsConfig);
            this.refTableName = DBInitializerHelper.getRefTableName(wsConfig);
            this.valueTableName = DBInitializerHelper.getValueTableName(wsConfig);
            this.itemTableSuffix = DBInitializerHelper.getItemTableSuffix(wsConfig);
            this.valueTableSuffix = DBInitializerHelper.getValueTableSuffix(wsConfig);
            this.refTableSuffix = DBInitializerHelper.getRefTableSuffix(wsConfig);
            this.useSequence = DBInitializerHelper.useSequenceForOrderNumber(wsConfig, this.dialect);
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanException(e);
        }
    }
}

