/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.infinispan;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.exoplatform.services.database.utils.DialectDetecter;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.checker.DummyRepair;
import org.exoplatform.services.jcr.impl.checker.InspectionQuery;
import org.exoplatform.services.jcr.impl.core.lock.AbstractLockTableHandler;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ISPNLockTableHandler
extends AbstractLockTableHandler {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ISPNLockTableHandler");

    public ISPNLockTableHandler(WorkspaceEntry workspaceEntry, DataSource ds) {
        super(workspaceEntry, ds);
    }

    protected InspectionQuery getSelectQuery() throws SQLException {
        return new InspectionQuery("SELECT * FROM " + this.getTableName(), new String[]{this.getIdColumn()}, "Locks table match", new DummyRepair());
    }

    public InspectionQuery getDeleteQuery(String nodeId) throws SQLException {
        return new InspectionQuery("DELETE FROM " + this.getTableName() + " WHERE " + this.getIdColumn() + "='" + nodeId + "'", new String[0], "", new DummyRepair());
    }

    private String getIdColumn() throws SQLException {
        try {
            return this.lockManagerEntry.getParameterValue("infinispan-cl-cache.jdbc.id.column");
        }
        catch (RepositoryConfigurationException e) {
            throw new SQLException(e);
        }
    }

    private String getTableName() throws SQLException {
        try {
            String dialect = this.getDialect();
            String quote = "\"";
            if (dialect.startsWith("MYSQL")) {
                quote = "`";
            }
            return quote + this.lockManagerEntry.getParameterValue("infinispan-cl-cache.jdbc.table.name") + "_" + "L" + this.workspaceEntry.getUniqueName().replace("_", "").replace("-", "_") + quote;
        }
        catch (RepositoryConfigurationException e) {
            throw new SQLException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDialect() throws SQLException {
        String string;
        block2: {
            Connection jdbcConn = null;
            try {
                jdbcConn = this.openConnection();
                string = DialectDetecter.detect((DatabaseMetaData)jdbcConn.getMetaData());
                Object var4_3 = null;
                if (jdbcConn == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_4 = null;
                    if (jdbcConn == null) break block3;
                    jdbcConn.close();
                }
                throw throwable;
            }
            jdbcConn.close();
        }
        return string;
    }

    protected String extractNodeId(String value) {
        return value;
    }
}

