/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.xpath;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.DerefQueryNode;
import org.exoplatform.services.jcr.impl.core.query.ExactQueryNode;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyFunctionQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryConstants;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;
import org.exoplatform.services.jcr.impl.core.query.xpath.XPathQueryBuilder;
import org.exoplatform.services.jcr.impl.util.ISO9075;

class QueryFormat
implements QueryNodeVisitor,
QueryConstants {
    private final LocationFactory resolver;
    private final String statement;
    private final List<Exception> exceptions = new ArrayList<Exception>();

    private QueryFormat(QueryRootNode root, LocationFactory resolver) throws RepositoryException {
        this.resolver = resolver;
        this.statement = root.accept(this, new StringBuilder()).toString();
        if (this.exceptions.size() > 0) {
            Exception e = this.exceptions.get(0);
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public static String toString(QueryRootNode root, LocationFactory resolver) throws InvalidQueryException {
        try {
            return new QueryFormat(root, resolver).toString();
        }
        catch (RepositoryException e) {
            throw new InvalidQueryException((Throwable)e);
        }
    }

    public String toString() {
        return this.statement;
    }

    public Object visit(QueryRootNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        node.getLocationNode().accept(this, data);
        InternalQName[] selectProps = node.getSelectProperties();
        if (selectProps.length > 0) {
            boolean union;
            sb.append('/');
            boolean bl = union = selectProps.length > 1;
            if (union) {
                sb.append('(');
            }
            String pipe = "";
            for (int i = 0; i < selectProps.length; ++i) {
                try {
                    sb.append(pipe);
                    sb.append('@');
                    sb.append(this.resolver.createJCRName(QueryFormat.encode(selectProps[i])).getAsString());
                    pipe = "|";
                    continue;
                }
                catch (NamespaceException e) {
                    this.exceptions.add((Exception)((Object)e));
                }
            }
            if (union) {
                sb.append(')');
            }
        }
        if (node.getOrderNode() != null) {
            node.getOrderNode().accept(this, data);
        }
        return data;
    }

    public Object visit(OrQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        boolean bracket = false;
        if (node.getParent() instanceof AndQueryNode) {
            bracket = true;
        }
        if (bracket) {
            sb.append("(");
        }
        String or = "";
        QueryNode[] operands = node.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            sb.append(or);
            operands[i].accept(this, sb);
            or = " or ";
        }
        if (bracket) {
            sb.append(")");
        }
        return sb;
    }

    public Object visit(AndQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        String and = "";
        QueryNode[] operands = node.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            sb.append(and);
            operands[i].accept(this, sb);
            and = " and ";
        }
        return sb;
    }

    public Object visit(NotQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        QueryNode[] operands = node.getOperands();
        if (operands.length > 0) {
            try {
                sb.append(this.resolver.createJCRName(XPathQueryBuilder.FN_NOT_10).getAsString());
                sb.append("(");
                operands[0].accept(this, sb);
                sb.append(")");
            }
            catch (NamespaceException e) {
                this.exceptions.add((Exception)((Object)e));
            }
        }
        return sb;
    }

    public Object visit(ExactQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        sb.append("@");
        try {
            InternalQName name = QueryFormat.encode(node.getPropertyName());
            sb.append(this.resolver.createJCRName(name).getAsString());
            sb.append("='");
            sb.append(this.resolver.createJCRName(node.getValue()).getAsString());
        }
        catch (NamespaceException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        sb.append("'");
        return sb;
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        return data;
    }

    public Object visit(TextsearchQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        try {
            sb.append(this.resolver.createJCRName(XPathQueryBuilder.JCR_CONTAINS).getAsString());
            sb.append("(");
            QPath relPath = node.getRelativePath();
            if (relPath == null) {
                sb.append(".");
            } else {
                QPathEntry[] elements = relPath.getEntries();
                String slash = "";
                for (int i = 0; i < elements.length; ++i) {
                    sb.append(slash);
                    slash = "/";
                    if (node.getReferencesProperty() && i == elements.length - 1) {
                        sb.append("@");
                    }
                    if (elements[i].equals((Object)RelationQueryNode.STAR_NAME_TEST)) {
                        sb.append("*");
                    } else {
                        InternalQName n = QueryFormat.encode(elements[i]);
                        sb.append(this.resolver.createJCRName(n).getAsString());
                    }
                    if (elements[i].getIndex() == 0) continue;
                    sb.append("[").append(elements[i].getIndex()).append("]");
                }
            }
            sb.append(", '");
            sb.append(node.getQuery().replaceAll("'", "''"));
            sb.append("')");
        }
        catch (NamespaceException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        return sb;
    }

    public Object visit(PathQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        if (node.isAbsolute()) {
            sb.append("/");
        }
        LocationStepQueryNode[] steps = node.getPathSteps();
        String slash = "";
        for (int i = 0; i < steps.length; ++i) {
            sb.append(slash);
            steps[i].accept(this, sb);
            slash = "/";
        }
        return sb;
    }

    public Object visit(LocationStepQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        if (node.getIncludeDescendants()) {
            sb.append('/');
        }
        final InternalQName[] nodeType = new InternalQName[1];
        node.acceptOperands(new DefaultQueryNodeVisitor(){

            public Object visit(NodeTypeQueryNode node, Object data) {
                nodeType[0] = node.getValue();
                return data;
            }
        }, null);
        if (nodeType[0] != null) {
            sb.append("element(");
        }
        if (node.getNameTest() == null) {
            sb.append("*");
        } else {
            try {
                if (node.getNameTest().getName().length() == 0) {
                    sb.append(this.resolver.createJCRName(XPathQueryBuilder.JCR_ROOT).getAsString());
                } else {
                    sb.append(this.resolver.createJCRName(QueryFormat.encode(node.getNameTest())).getAsString());
                }
            }
            catch (NamespaceException e) {
                this.exceptions.add((Exception)((Object)e));
            }
        }
        if (nodeType[0] != null) {
            sb.append(", ");
            try {
                sb.append(this.resolver.createJCRName(QueryFormat.encode(nodeType[0])).getAsString());
            }
            catch (NamespaceException e) {
                this.exceptions.add((Exception)((Object)e));
            }
            sb.append(")");
        }
        if (node.getIndex() != -2147483647) {
            sb.append('[').append(node.getIndex()).append(']');
        }
        QueryNode[] predicates = node.getPredicates();
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i].getType() == 6) continue;
            sb.append('[');
            predicates[i].accept(this, sb);
            sb.append(']');
        }
        return sb;
    }

    public Object visit(DerefQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        try {
            sb.append(this.resolver.createJCRName(XPathQueryBuilder.JCR_DEREF).getAsString());
            sb.append("(@");
            sb.append(this.resolver.createJCRName(QueryFormat.encode(node.getRefProperty())).getAsString());
            sb.append(", '");
            if (node.getNameTest() == null) {
                sb.append("*");
            } else {
                sb.append(this.resolver.createJCRName(QueryFormat.encode(node.getNameTest())).getAsString());
            }
            sb.append("')");
        }
        catch (NamespaceException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        return sb;
    }

    public Object visit(RelationQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        try {
            StringBuilder propPath = new StringBuilder();
            QPath relPath = node.getRelativePath();
            if (relPath == null) {
                propPath.append(".");
            } else if (relPath.getName().equals((Object)XPathQueryBuilder.FN_POSITION_FULL)) {
                propPath.append(this.resolver.createJCRName(XPathQueryBuilder.FN_POSITION_FULL).getAsString());
            } else {
                QPathEntry[] elements = relPath.getEntries();
                String slash = "";
                for (int i = 0; i < elements.length; ++i) {
                    propPath.append(slash);
                    slash = "/";
                    if (i == elements.length - 1 && node.getOperation() != 28) {
                        propPath.append("@");
                    }
                    if (elements[i].equals((Object)RelationQueryNode.STAR_NAME_TEST)) {
                        propPath.append("*");
                    } else {
                        propPath.append(this.resolver.createJCRName(QueryFormat.encode(elements[i])).getAsString());
                    }
                    if (elements[i].getIndex() == 0) continue;
                    propPath.append("[").append(elements[i].getIndex()).append("]");
                }
            }
            node.acceptOperands(this, propPath);
            if (node.getOperation() == 11) {
                sb.append((CharSequence)propPath).append(" eq ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 12) {
                sb.append((CharSequence)propPath).append(" = ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 20) {
                sb.append((CharSequence)propPath).append(" >= ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 19) {
                sb.append((CharSequence)propPath).append(" ge ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 18) {
                sb.append((CharSequence)propPath).append(" > ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 17) {
                sb.append((CharSequence)propPath).append(" gt ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 22) {
                sb.append((CharSequence)propPath).append(" <= ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 21) {
                sb.append((CharSequence)propPath).append(" le ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 23) {
                sb.append(this.resolver.createJCRName(XPathQueryBuilder.JCR_LIKE).getAsString());
                sb.append("(").append((CharSequence)propPath).append(", ");
                this.appendValue(node, sb);
                sb.append(")");
            } else if (node.getOperation() == 16) {
                sb.append((CharSequence)propPath).append(" < ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 15) {
                sb.append((CharSequence)propPath).append(" lt ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 14) {
                sb.append((CharSequence)propPath).append(" != ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 13) {
                sb.append((CharSequence)propPath).append(" ne ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 26) {
                sb.append(this.resolver.createJCRName(XPathQueryBuilder.FN_NOT).getAsString());
                sb.append("(").append((CharSequence)propPath).append(")");
            } else if (node.getOperation() == 27) {
                sb.append((CharSequence)propPath);
            } else if (node.getOperation() == 28) {
                sb.append(this.resolver.createJCRName(XPathQueryBuilder.REP_SIMILAR).getAsString());
                sb.append("(").append((CharSequence)propPath).append(", ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 29) {
                sb.append(this.resolver.createJCRName(XPathQueryBuilder.REP_SPELLCHECK).getAsString());
                sb.append("(");
                this.appendValue(node, sb);
                sb.append(")");
            } else {
                this.exceptions.add((Exception)((Object)new InvalidQueryException("Invalid operation: " + node.getOperation())));
            }
        }
        catch (NamespaceException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        return sb;
    }

    public Object visit(OrderQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        sb.append(" order by");
        OrderQueryNode.OrderSpec[] specs = node.getOrderSpecs();
        String comma = "";
        try {
            for (int i = 0; i < specs.length; ++i) {
                sb.append(comma);
                QPath propPath = specs[i].getPropertyPath();
                QPathEntry[] elements = propPath.getEntries();
                sb.append(" ");
                String slash = "";
                for (int j = 0; j < elements.length; ++j) {
                    sb.append(slash);
                    slash = "/";
                    QPathEntry element = elements[j];
                    InternalQName name = QueryFormat.encode(element);
                    if (j == elements.length - 1) {
                        sb.append("@");
                    }
                    sb.append(this.resolver.createJCRName(name).getAsString());
                }
                if (!specs[i].isAscending()) {
                    sb.append(" descending");
                }
                comma = ",";
            }
        }
        catch (NamespaceException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        return data;
    }

    public Object visit(PropertyFunctionQueryNode node, Object data) throws RepositoryException {
        StringBuilder sb = (StringBuilder)data;
        String functionName = node.getFunctionName();
        try {
            if (functionName.equals("lower-case")) {
                sb.insert(0, this.resolver.createJCRName(XPathQueryBuilder.FN_LOWER_CASE).getAsString() + "(");
                sb.append(")");
            } else if (functionName.equals("upper-case")) {
                sb.insert(0, this.resolver.createJCRName(XPathQueryBuilder.FN_UPPER_CASE).getAsString() + "(");
                sb.append(")");
            } else {
                this.exceptions.add((Exception)((Object)new InvalidQueryException("Unsupported function: " + functionName)));
            }
        }
        catch (NamespaceException e) {
            this.exceptions.add((Exception)((Object)e));
        }
        return sb;
    }

    private void appendValue(RelationQueryNode node, StringBuilder b) throws RepositoryException {
        if (node.getValueType() == 1) {
            b.append(node.getLongValue());
        } else if (node.getValueType() == 2) {
            b.append(node.getDoubleValue());
        } else if (node.getValueType() == 3) {
            b.append("'").append(node.getStringValue().replaceAll("'", "''")).append("'");
        } else if (node.getValueType() == 4 || node.getValueType() == 5) {
            Calendar cal = Calendar.getInstance(Tools.getTimeZone((String)"UTC"));
            cal.setTime(node.getDateValue());
            b.append(this.resolver.createJCRName(XPathQueryBuilder.XS_DATETIME).getAsString());
            b.append("('").append(ISO8601.format((Calendar)cal)).append("')");
        } else if (node.getValueType() == 6) {
            if (node.getPositionValue() == Integer.MIN_VALUE) {
                b.append("last()");
            } else {
                b.append(node.getPositionValue());
            }
        } else {
            this.exceptions.add((Exception)((Object)new InvalidQueryException("Invalid type: " + node.getValueType())));
        }
    }

    private static InternalQName encode(InternalQName name) {
        String encoded = ISO9075.encode(name.getName());
        if (encoded.equals(name.getName())) {
            return name;
        }
        return new InternalQName(name.getNamespace(), encoded);
    }
}

