/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.util.Calendar;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CalendarPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;

public abstract class CalendarValueData
extends AbstractValueData {
    protected Calendar value;

    protected CalendarValueData(int orderNumber, Calendar value) {
        super(orderNumber);
        this.value = value;
    }

    protected boolean internalEquals(ValueData another) {
        if (another instanceof CalendarValueData) {
            Calendar that = ((CalendarValueData)another).value;
            return that.getTimeInMillis() == this.value.getTimeInMillis() && that.isLenient() == this.value.isLenient() && that.getFirstDayOfWeek() == this.value.getFirstDayOfWeek() && that.getMinimalDaysInFirstWeek() == this.value.getMinimalDaysInFirstWeek() && that.get(15) + that.get(16) == this.value.get(15) + this.value.get(16);
        }
        return false;
    }

    protected byte[] spoolInternalValue() {
        return JCRDateFormat.format(this.value).getBytes();
    }

    public String toString() {
        return this.getString();
    }

    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new CalendarPersistedValueData(orderNumber, this.value);
    }

    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    protected Long getLong() {
        return this.value.getTimeInMillis();
    }

    protected Double getDouble() {
        return new Double(this.value.getTimeInMillis());
    }

    protected String getString() {
        return JCRDateFormat.format(this.value);
    }

    protected Calendar getDate() {
        return this.value;
    }
}

