/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.lang.ref.SoftReference;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.RepositoryException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManagerListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionableResourceManager
implements XAResource {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.TransactionableResourceManager");
    private final ThreadLocal<TransactionContext> contexts = new ThreadLocal();
    private final TransactionManager tm;
    private final ExoContainer container;
    private volatile LocalWorkspaceDataManagerStub workspaceDataManager;
    private int txTimeout;

    public TransactionableResourceManager(ExoContainerContext ctx) {
        this(ctx, null);
    }

    public TransactionableResourceManager(ExoContainerContext ctx, TransactionService tService) {
        this.tm = tService == null ? null : tService.getTransactionManager();
        this.container = ctx.getContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalWorkspaceDataManagerStub getWorkspaceDataManager() {
        if (this.workspaceDataManager == null) {
            TransactionableResourceManager transactionableResourceManager = this;
            synchronized (transactionableResourceManager) {
                if (this.workspaceDataManager == null) {
                    LocalWorkspaceDataManagerStub workspaceDataManager = (LocalWorkspaceDataManagerStub)this.container.getComponentInstanceOfType(LocalWorkspaceDataManagerStub.class);
                    if (workspaceDataManager == null) {
                        throw new IllegalStateException("The workspace data manager cannot be found");
                    }
                    this.workspaceDataManager = workspaceDataManager;
                }
            }
        }
        return this.workspaceDataManager;
    }

    public boolean isGlobalTxActive() {
        try {
            TransactionContext ctx = this.contexts.get();
            return ctx != null && ctx.getXidContext() != null && this.tm.getStatus() != 6;
        }
        catch (SystemException e) {
            log.warn((Object)"Could not check if a global Tx has been started", (Throwable)e);
            return false;
        }
    }

    public void putSharedObject(String key, Object value) {
        TransactionContext ctx = this.contexts.get();
        if (ctx == null) {
            throw new IllegalStateException("There is no active transaction context");
        }
        XidContext xidCtx = ctx.getXidContext();
        if (xidCtx == null) {
            throw new IllegalStateException("There is no active xid context");
        }
        xidCtx.putSharedObject(key, value);
    }

    public <T> T getSharedObject(String key) {
        TransactionContext ctx = this.contexts.get();
        if (ctx == null) {
            throw new IllegalStateException("There is no active transaction context");
        }
        XidContext xidCtx = ctx.getXidContext();
        if (xidCtx == null) {
            throw new IllegalStateException("There is no active xid context");
        }
        return xidCtx.getSharedObject(key);
    }

    public boolean canEnrollChangeToGlobalTx(final SessionImpl session, final PlainChangesLog changes) {
        try {
            int status;
            if (this.tm != null && (status = this.tm.getStatus()) != 6) {
                if (status != 0 && status != 7) {
                    throw new IllegalStateException("The session cannot be enrolled in the current global transaction due to an invalidate state, the current status is " + status + " and only ACTIVE and PREPARING are allowed");
                }
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        TransactionableResourceManager.this.add(session, changes);
                        return null;
                    }
                });
                return true;
            }
        }
        catch (PrivilegedActionException e) {
            log.warn((Object)"Could not check if a global Tx has been started or register the session into the resource manager", (Throwable)e);
        }
        catch (SystemException e) {
            log.warn((Object)"Could not check if a global Tx has been started or register the session into the resource manager", (Throwable)e);
        }
        return false;
    }

    public void addListener(TransactionableResourceManagerListener listener) {
        TransactionContext ctx = this.contexts.get();
        if (ctx == null) {
            throw new IllegalStateException("There is no active transaction context");
        }
        XidContext xidCtx = ctx.getXidContext();
        if (xidCtx == null) {
            throw new IllegalStateException("There is no active xid context");
        }
        xidCtx.addListener(listener);
    }

    private void add(SessionImpl session, PlainChangesLog changes) throws SystemException, IllegalStateException, RollbackException {
        Transaction tx = this.tm.getTransaction();
        if (tx == null) {
            return;
        }
        TransactionContext ctx = this.getOrCreateTransactionContext();
        ctx.registerTransaction(tx);
        ctx.add(session, changes);
    }

    private TransactionContext getOrCreateTransactionContext() {
        TransactionContext ctx = this.contexts.get();
        if (ctx == null) {
            ctx = new TransactionContext();
            this.contexts.set(ctx);
        }
        return ctx;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        TransactionContext ctx;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Commit. Xid:" + xid + ", onePhase: " + onePhase + ": " + this));
        }
        if ((ctx = this.contexts.get()) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not find the context");
            }
            return;
        }
        XidContext xidCtx = ctx.getXidContext(xid);
        if (xidCtx != null) {
            boolean failed = false;
            List<TransactionableResourceManagerListener> listeners = xidCtx.getListeners();
            int length = listeners.size();
            for (int i = 0; i < length; ++i) {
                TransactionableResourceManagerListener listener = listeners.get(i);
                try {
                    listener.onCommit(onePhase);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Could not execute the method onCommit(" + onePhase + ")"), (Throwable)e);
                    failed = true;
                    break;
                }
            }
            if (failed) {
                if (onePhase) {
                    this.abort(listeners);
                    throw new XAException(100);
                }
                throw new XAException(-3);
            }
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End. Xid:" + xid + ", " + flags + ": " + this));
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Forget. Xid:" + xid + ": " + this));
        }
        this.abort(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GetTransactionTimeout. : " + this));
        }
        return this.txTimeout;
    }

    private long getTransactionTimeoutMillis() {
        return (long)this.txTimeout * 1000L;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("IsSameRM. XAResource:" + xares + ": " + this));
        }
        return xares == this;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Prepare. Xid:" + xid + ": " + this));
        }
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Recover. flag:" + flag + ": " + this));
        }
        return new Xid[0];
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rollback. Xid:" + xid + ": " + this));
        }
        this.abort(xid);
    }

    private void abort(Xid xid) throws XAException {
        TransactionContext ctx = this.contexts.get();
        if (ctx == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not find the context");
            }
            return;
        }
        XidContext xidCtx = ctx.getXidContext(xid);
        if (xidCtx != null) {
            List<TransactionableResourceManagerListener> listeners = xidCtx.getListeners();
            this.abort(listeners);
        }
    }

    private void abort(List<TransactionableResourceManagerListener> listeners) throws XAException {
        boolean exception = false;
        int length = listeners.size();
        for (int i = 0; i < length; ++i) {
            TransactionableResourceManagerListener listener = listeners.get(i);
            try {
                listener.onAbort();
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Could not execute the method onAbort", (Throwable)e);
                exception = true;
            }
        }
        if (exception) {
            throw new XAException(-3);
        }
    }

    @Override
    public boolean setTransactionTimeout(int txTimeout) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SetTransactionTimeout. " + txTimeout + ": " + this));
        }
        this.txTimeout = txTimeout;
        TransactionContext ctx = this.contexts.get();
        if (ctx == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not find the context");
            }
            return true;
        }
        Set<SessionImpl> sessions = ctx.getSessions();
        if (sessions != null) {
            for (SessionImpl session : sessions) {
                session.setTimeout(this.getTransactionTimeoutMillis());
            }
        }
        return true;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start. Xid:" + xid + ", " + flags + ": " + this));
        }
        TransactionContext ctx = this.getOrCreateTransactionContext();
        ctx.setXid(xid);
    }

    private void setRollbackOnly() {
        try {
            this.tm.getTransaction().setRollbackOnly();
        }
        catch (IllegalStateException e) {
            log.warn((Object)"Could not set the status of the tx to 'rollback-only'", (Throwable)e);
        }
        catch (SystemException e) {
            log.warn((Object)"Could not set the status of the tx to 'rollback-only'", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XidContext {
        private final List<TransactionableResourceManagerListener> listeners = new ArrayList<TransactionableResourceManagerListener>();
        private final Map<PlainChangesLog, SessionImpl> mapChanges = new LinkedHashMap<PlainChangesLog, SessionImpl>();
        private final Map<String, Object> sharedObjects = new HashMap<String, Object>();

        private XidContext() {
        }

        public List<TransactionableResourceManagerListener> getListeners() {
            return this.listeners;
        }

        public void addListener(TransactionableResourceManagerListener listener) {
            this.listeners.add(listener);
        }

        public Map<PlainChangesLog, SessionImpl> getMapChanges() {
            return this.mapChanges;
        }

        public void put(PlainChangesLog changes, SessionImpl session) {
            this.mapChanges.put(changes, session);
        }

        public void putSharedObject(String key, Object value) {
            this.sharedObjects.put(key, value);
        }

        public <T> T getSharedObject(String key) {
            return (T)this.sharedObjects.get(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransactionContext {
        private SoftReference<Transaction> srTx;
        private SoftReference<Xid> srXid;
        private Map<Xid, XidContext> xidContexts;

        private TransactionContext() {
        }

        public void registerTransaction(Transaction tx) throws SystemException, IllegalStateException, RollbackException {
            if (!tx.equals(this.getTransaction())) {
                this.setTransaction(tx);
                tx.enlistResource((XAResource)TransactionableResourceManager.this);
            }
        }

        public XidContext getXidContext() {
            Xid xid = this.getXid();
            if (xid == null || this.xidContexts == null) {
                return null;
            }
            return this.xidContexts.get(xid);
        }

        public XidContext getXidContext(Xid xid) {
            if (xid == null || this.xidContexts == null) {
                return null;
            }
            return this.xidContexts.get(xid);
        }

        public Map<PlainChangesLog, SessionImpl> getChanges(Xid xid) {
            XidContext ctx = this.getXidContext(xid);
            if (ctx == null) {
                return null;
            }
            return ctx.getMapChanges();
        }

        private void setTransaction(Transaction tx) {
            this.srTx = new SoftReference<Transaction>(tx);
        }

        public Transaction getTransaction() {
            return this.srTx == null ? null : this.srTx.get();
        }

        public void setXid(Xid xid) {
            this.srXid = new SoftReference<Xid>(xid);
        }

        private Xid getXid() {
            return this.srXid == null ? null : this.srXid.get();
        }

        public Set<SessionImpl> getSessions() {
            Xid xid = this.getXid();
            if (xid == null) {
                return null;
            }
            return this.getSessions(xid);
        }

        private Set<SessionImpl> getSessions(Xid xid) {
            Map<PlainChangesLog, SessionImpl> changes = this.getChanges(xid);
            return changes == null ? null : new HashSet<SessionImpl>(changes.values());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(SessionImpl session, PlainChangesLog changes) throws IllegalStateException, RollbackException, SystemException {
            Xid xid;
            if (this.xidContexts == null) {
                this.xidContexts = new WeakHashMap<Xid, XidContext>();
            }
            if ((xid = this.getXid()) == null) {
                throw new IllegalStateException("Threre is no active branch");
            }
            XidContext ctx = this.xidContexts.get(xid);
            if (ctx == null) {
                ctx = new XidContext();
                this.xidContexts.put(xid, ctx);
                boolean registered = false;
                try {
                    this.getTransaction().registerSynchronization((Synchronization)new TransactionableResourceManagerSynchronization(xid));
                    registered = true;
                    Object var7_6 = null;
                    if (!registered) {
                        this.remove(xid);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!registered) {
                        this.remove(xid);
                    }
                    throw throwable;
                }
            }
            if (TransactionableResourceManager.this.txTimeout > 0) {
                session.setTimeout(TransactionableResourceManager.this.getTransactionTimeoutMillis());
            }
            if (changes != null) {
                ctx.put(changes, session);
                session.getTransientNodesManager().getTransactManager().start();
            }
        }

        public void remove(Xid xid) {
            if (this.xidContexts != null) {
                this.xidContexts.remove(xid);
                if (this.xidContexts.isEmpty()) {
                    TransactionableResourceManager.this.contexts.set(null);
                }
            }
        }
    }

    private class TransactionableResourceManagerSynchronization
    implements Synchronization {
        private final Xid xid;
        private final AtomicBoolean isLastAfterCompletion = new AtomicBoolean(true);

        public TransactionableResourceManagerSynchronization(Xid xid) {
            this.xid = xid;
        }

        public void beforeCompletion() {
            TransactionContext ctx;
            if (log.isDebugEnabled()) {
                log.debug((Object)("BeforeCompletion Xid:" + this.xid + ": " + this));
            }
            if ((ctx = (TransactionContext)TransactionableResourceManager.this.contexts.get()) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not find the context");
                }
                return;
            }
            ctx.setXid(this.xid);
            Map<PlainChangesLog, SessionImpl> changes = ctx.getChanges(this.xid);
            if (changes == null || changes.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"There is no change to apply");
                }
                return;
            }
            try {
                TransactionChangesLog allChanges = new TransactionChangesLog();
                for (Map.Entry<PlainChangesLog, SessionImpl> entry : changes.entrySet()) {
                    SessionImpl session = entry.getValue();
                    if (session.hasExpired()) {
                        throw new RepositoryException("The tx was too long, at least one session has expired.");
                    }
                    allChanges.addLog(entry.getKey());
                }
                TransactionableResourceManager.this.getWorkspaceDataManager().save((CompositeChangesLog)allChanges, true);
            }
            catch (RepositoryException e) {
                log.error((Object)"Could not apply changes", (Throwable)e);
                TransactionableResourceManager.this.setRollbackOnly();
                return;
            }
            try {
                TransactionableResourceManager.this.tm.getTransaction().registerSynchronization(new Synchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        TransactionableResourceManagerSynchronization.this.afterCompletion(status);
                    }
                });
                this.isLastAfterCompletion.set(false);
            }
            catch (RollbackException e) {
                log.error((Object)"Could not register the second synchronization", (Throwable)e);
            }
            catch (IllegalStateException e) {
                log.error((Object)"Could not register the second synchronization", (Throwable)e);
            }
            catch (SystemException e) {
                log.error((Object)"Could not register the second synchronization", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("AfterCompletion Xid:" + this.xid + ", " + status + ", " + this.isLastAfterCompletion.get() + ": " + this));
            }
            if (!this.isLastAfterCompletion.get()) {
                this.isLastAfterCompletion.set(true);
                return;
            }
            TransactionContext ctx = (TransactionContext)TransactionableResourceManager.this.contexts.get();
            if (ctx == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not find the context");
                }
                return;
            }
            XidContext xidCtx = ctx.getXidContext(this.xid);
            if (xidCtx == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not find the xid context");
                }
                return;
            }
            try {
                List<TransactionableResourceManagerListener> listeners = xidCtx.getListeners();
                int length = listeners.size();
                for (int i = 0; i < length; ++i) {
                    TransactionableResourceManagerListener listener = listeners.get(i);
                    try {
                        listener.onAfterCompletion(status);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not execute the method onAfterCompletion for the status " + status), (Throwable)e);
                    }
                }
                Map<PlainChangesLog, SessionImpl> changes = xidCtx.getMapChanges();
                if (changes != null && !changes.isEmpty()) {
                    for (Map.Entry<PlainChangesLog, SessionImpl> entry : changes.entrySet()) {
                        SessionImpl session = entry.getValue();
                        TransactionableDataManager txManager = session.getTransientNodesManager().getTransactManager();
                        txManager.removeLog(entry.getKey());
                    }
                }
                Object var11_13 = null;
                ctx.remove(this.xid);
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                ctx.remove(this.xid);
                throw throwable;
            }
        }
    }
}

