/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.quota.DummyRPCServiceImpl;
import org.exoplatform.services.jcr.impl.quota.QuotaManager;
import org.exoplatform.services.jcr.impl.quota.QuotaManagerException;
import org.exoplatform.services.jcr.impl.quota.QuotaPersister;
import org.exoplatform.services.jcr.impl.quota.RepositoryQuotaManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.rpc.RPCService;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="QuotaManager")})
public abstract class BaseQuotaManager
implements QuotaManager,
Startable {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.BaseQuotaManager");
    public static final String CACHE_CONFIGURATION_PROPERTIES_PARAM = "cache-configuration";
    public static final String EXCEEDED_QUOTA_BEHAVIOUR_PARAM = "exceeded-quota-behaviour";
    protected Map<String, RepositoryQuotaManager> rQuotaManagers = new ConcurrentHashMap<String, RepositoryQuotaManager>();
    protected final RPCService rpcService;
    protected final ExceededQuotaBehavior exceededQuotaBehavior;
    protected final QuotaPersister quotaPersister;
    protected final InitParams initParams;
    protected final ConfigurationManager cfm;

    public BaseQuotaManager(InitParams initParams, RPCService rpcService, ConfigurationManager cfm, InitialContextInitializer contextInitializer) throws RepositoryConfigurationException, QuotaManagerException {
        ValueParam param = initParams.getValueParam(EXCEEDED_QUOTA_BEHAVIOUR_PARAM);
        this.exceededQuotaBehavior = param == null ? ExceededQuotaBehavior.WARNING : ExceededQuotaBehavior.valueOf(param.getValue().toUpperCase());
        this.cfm = cfm;
        this.initParams = initParams;
        this.rpcService = rpcService == null ? new DummyRPCServiceImpl() : rpcService;
        this.quotaPersister = this.initQuotaPersister();
    }

    public BaseQuotaManager(InitParams initParams, ConfigurationManager cfm, InitialContextInitializer contextInitializer) throws RepositoryConfigurationException, QuotaManagerException {
        this(initParams, null, cfm, contextInitializer);
    }

    public long getNodeDataSize(String repositoryName, String workspaceName, String nodePath) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        return rqm.getNodeDataSize(workspaceName, nodePath);
    }

    public void setNodeQuota(String repositoryName, String workspaceName, String nodePath, long quotaLimit, boolean asyncUpdate) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        rqm.setNodeQuota(workspaceName, nodePath, quotaLimit, asyncUpdate);
    }

    public void removeNodeQuota(String repositoryName, String workspaceName, String nodePath) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        rqm.removeNodeQuota(workspaceName, nodePath);
    }

    public void removeGroupOfNodesQuota(String repositoryName, String workspaceName, String nodePath) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        rqm.removeGroupOfNodesQuota(workspaceName, nodePath);
    }

    public long getNodeQuota(String repositoryName, String workspaceName, String nodePath) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        return rqm.getNodeQuota(workspaceName, nodePath);
    }

    public void setGroupOfNodesQuota(String repositoryName, String workspaceName, String patternPath, long quotaLimit, boolean asyncUpdate) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        rqm.setGroupOfNodesQuota(workspaceName, patternPath, quotaLimit, asyncUpdate);
    }

    public void setWorkspaceQuota(String repositoryName, String workspaceName, long quotaLimit) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        rqm.setWorkspaceQuota(workspaceName, quotaLimit);
    }

    public void removeWorkspaceQuota(String repositoryName, String workspaceName) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        rqm.removeWorkspaceQuota(workspaceName);
    }

    public long getWorkspaceQuota(String repositoryName, String workspaceName) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        return rqm.getWorkspaceQuota(workspaceName);
    }

    public long getWorkspaceDataSize(String repositoryName, String workspaceName) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        return rqm.getWorkspaceDataSize(workspaceName);
    }

    public long getWorkspaceIndexSize(String repositoryName, String workspaceName) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        return rqm.getWorkspaceIndexSize(workspaceName);
    }

    public void setRepositoryQuota(String repositoryName, long quotaLimit) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        rqm.setRepositoryQuota(quotaLimit);
    }

    public void removeRepositoryQuota(String repositoryName) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        rqm.removeRepositoryQuota();
    }

    public long getRepositoryQuota(String repositoryName) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        return rqm.getRepositoryQuota();
    }

    public long getRepositoryDataSize(String repositoryName) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        return rqm.getRepositoryDataSize();
    }

    public long getRepositoryIndexSize(String repositoryName) throws QuotaManagerException {
        RepositoryQuotaManager rqm = this.getRepositoryQuotaManager(repositoryName);
        return rqm.getRepositoryIndexSize();
    }

    @Managed
    @ManagedDescription(value="Returns global data size")
    public long getGlobalDataSize() throws QuotaManagerException {
        return this.quotaPersister.getGlobalDataSize();
    }

    @Managed
    @ManagedDescription(value="Returns global quota limit")
    public void setGlobalQuota(@ManagedName(value="quotaLimit") long quotaLimit) throws QuotaManagerException {
        this.quotaPersister.setGlobalQuota(quotaLimit);
    }

    @Managed
    @ManagedDescription(value="Removes global quota limit")
    public void removeGlobalQuota() throws QuotaManagerException {
        this.quotaPersister.removeGlobalQuota();
    }

    @Managed
    @ManagedDescription(value="Returns global quota limit")
    public long getGlobalQuota() throws QuotaManagerException {
        return this.quotaPersister.getGlobalQuota();
    }

    @Managed
    @ManagedDescription(value="Returns global index size")
    public long getGlobalIndexSize() throws QuotaManagerException {
        long size = 0L;
        for (RepositoryQuotaManager rqm : this.rQuotaManagers.values()) {
            size += rqm.getRepositoryIndexSize();
        }
        return size;
    }

    public void start() {
    }

    public void stop() {
        this.quotaPersister.destroy();
        this.rQuotaManagers.clear();
    }

    protected void registerRepositoryQuotaManager(String repositoryName, RepositoryQuotaManager rQuotaManager) {
        this.rQuotaManagers.put(repositoryName, rQuotaManager);
    }

    protected void unregisterRepositoryQuotaManager(String repositoryName) {
        this.rQuotaManagers.remove(repositoryName);
    }

    public long getGlobalDataSizeDirectly() throws QuotaManagerException {
        long size = 0L;
        for (RepositoryQuotaManager rqm : this.rQuotaManagers.values()) {
            size += rqm.getRepositoryDataSizeDirectly();
        }
        return size;
    }

    private RepositoryQuotaManager getRepositoryQuotaManager(String repositoryName) throws IllegalStateException {
        RepositoryQuotaManager rqm = this.rQuotaManagers.get(repositoryName);
        if (rqm == null) {
            throw new IllegalStateException("Repository " + repositoryName + " is not registered");
        }
        return rqm;
    }

    protected abstract QuotaPersister initQuotaPersister() throws RepositoryConfigurationException, QuotaManagerException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExceededQuotaBehavior {
        WARNING,
        EXCEPTION;

    }
}

