/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.quota;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.WorkspaceManagingListener;
import org.exoplatform.services.jcr.impl.proccess.WorkerThread;
import org.exoplatform.services.jcr.impl.quota.ApplyPersistedChangesTask;
import org.exoplatform.services.jcr.impl.quota.BaseQuotaManager;
import org.exoplatform.services.jcr.impl.quota.ChangesItem;
import org.exoplatform.services.jcr.impl.quota.QuotaManagerException;
import org.exoplatform.services.jcr.impl.quota.QuotaPersister;
import org.exoplatform.services.jcr.impl.quota.UnknownDataSizeException;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaContext;
import org.exoplatform.services.jcr.impl.quota.WorkspaceQuotaManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="RepositoryQuotaManager")})
public class RepositoryQuotaManager
implements Startable,
WorkspaceManagingListener {
    protected final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RepositoryQuotaManager");
    private Map<String, WorkspaceQuotaManager> wsQuotaManagers = new ConcurrentHashMap<String, WorkspaceQuotaManager>();
    protected final String rName;
    protected final BaseQuotaManager globalQuotaManager;
    protected final QuotaPersister quotaPersister;
    protected final RepositoryImpl repository;
    protected final PushTask pushTask;
    protected final long DEFAULT_TIMEOUT = 5000L;

    public RepositoryQuotaManager(RepositoryImpl repository, BaseQuotaManager quotaManager, RepositoryEntry rEntry) {
        this.rName = rEntry.getName();
        this.globalQuotaManager = quotaManager;
        this.quotaPersister = this.globalQuotaManager.quotaPersister;
        this.repository = repository;
        this.pushTask = new PushTask("PushQuotaChangesTask-" + this.rName, 5000L);
        this.pushTask.start();
        this.globalQuotaManager.registerRepositoryQuotaManager(this.rName, this);
        this.repository.addWorkspaceManagingListener(this);
    }

    public long getNodeDataSize(String workspaceName, String nodePath) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        return wqm.getNodeDataSize(nodePath);
    }

    public long getNodeQuota(String workspaceName, String nodePath) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        return wqm.getNodeQuota(nodePath);
    }

    public void setNodeQuota(String workspaceName, String nodePath, long quotaLimit, boolean asyncUpdate) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        wqm.setNodeQuota(nodePath, quotaLimit, asyncUpdate);
    }

    public void setGroupOfNodesQuota(String workspaceName, String patternPath, long quotaLimit, boolean asyncUpdate) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        wqm.setGroupOfNodesQuota(patternPath, quotaLimit, asyncUpdate);
    }

    public void removeNodeQuota(String workspaceName, String nodePath) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        wqm.removeNodeQuota(nodePath);
    }

    public void removeGroupOfNodesQuota(String workspaceName, String nodePath) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        wqm.removeGroupOfNodesQuota(nodePath);
    }

    public long getWorkspaceQuota(String workspaceName) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        return wqm.getWorkspaceQuota();
    }

    public void setWorkspaceQuota(String workspaceName, long quotaLimti) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        wqm.setWorkspaceQuota(quotaLimti);
    }

    public void removeWorkspaceQuota(String workspaceName) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        wqm.removeWorkspaceQuota();
    }

    public long getWorkspaceDataSize(String workspaceName) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        return wqm.getWorkspaceDataSize();
    }

    public long getWorkspaceIndexSize(String workspaceName) throws QuotaManagerException {
        WorkspaceQuotaManager wqm = this.getWorkspaceQuotaManager(workspaceName);
        return wqm.getWorkspaceIndexSize();
    }

    @Managed
    @ManagedDescription(value="Sets repository quta limit")
    public void setRepositoryQuota(@ManagedName(value="quotaLimit") long quotaLimit) throws QuotaManagerException {
        this.quotaPersister.setRepositoryQuota(this.rName, quotaLimit);
    }

    @Managed
    @ManagedDescription(value="Removes repository quta limit")
    public void removeRepositoryQuota() throws QuotaManagerException {
        this.quotaPersister.removeRepositoryQuota(this.rName);
    }

    @Managed
    @ManagedDescription(value="Returns repository quta limit")
    public long getRepositoryQuota() throws QuotaManagerException {
        return this.quotaPersister.getRepositoryQuota(this.rName);
    }

    @Managed
    @ManagedDescription(value="Returns repository data size")
    public long getRepositoryDataSize() throws QuotaManagerException {
        return this.quotaPersister.getRepositoryDataSize(this.rName);
    }

    @Managed
    @ManagedDescription(value="Returns repository index size")
    public long getRepositoryIndexSize() throws QuotaManagerException {
        long size = 0L;
        for (WorkspaceQuotaManager wQuotaManager : this.wsQuotaManagers.values()) {
            size += wQuotaManager.getWorkspaceIndexSize();
        }
        return size;
    }

    public void start() {
    }

    public void stop() {
        this.wsQuotaManagers.clear();
        this.globalQuotaManager.unregisterRepositoryQuotaManager(this.rName);
        this.repository.removeWorkspaceManagingListener(this);
        this.pushTask.halt();
    }

    public void registerWorkspaceQuotaManager(String workspaceName, WorkspaceQuotaManager wQuotaManager) {
        this.wsQuotaManagers.put(workspaceName, wQuotaManager);
    }

    public void unregisterWorkspaceQuotaManager(String workspaceName) {
        this.wsQuotaManagers.remove(workspaceName);
    }

    public long getRepositoryDataSizeDirectly() throws QuotaManagerException {
        long size = 0L;
        for (WorkspaceQuotaManager wQuotaManager : this.wsQuotaManagers.values()) {
            size += wQuotaManager.getWorkspaceDataSizeDirectly();
        }
        return size;
    }

    public void onWorkspaceRemove(String workspaceName) {
        long dataSize;
        try {
            dataSize = this.quotaPersister.getWorkspaceDataSize(this.rName, workspaceName);
        }
        catch (UnknownDataSizeException e) {
            return;
        }
        ChangesItem changesItem = new ChangesItem();
        changesItem.updateWorkspaceChangedSize(-dataSize);
        WorkspaceQuotaContext context = new WorkspaceQuotaContext(workspaceName, this.rName, null, null, null, null, this.quotaPersister, null, null);
        ApplyPersistedChangesTask task = new ApplyPersistedChangesTask(context, changesItem);
        task.run();
        this.quotaPersister.setWorkspaceDataSize(this.rName, workspaceName, dataSize);
    }

    private WorkspaceQuotaManager getWorkspaceQuotaManager(String workspaceName) throws IllegalStateException {
        WorkspaceQuotaManager wqm = this.wsQuotaManagers.get(workspaceName);
        if (wqm == null) {
            throw new IllegalStateException("Workspace " + workspaceName + " is not registered in " + this.rName);
        }
        return wqm;
    }

    private class PushTask
    extends WorkerThread {
        public PushTask(String name, long timeout) {
            super(name, timeout);
        }

        protected void callPeriodically() throws Exception {
            for (WorkspaceQuotaManager wqm : RepositoryQuotaManager.this.wsQuotaManagers.values()) {
                wqm.pushAllChangesToCoordinator();
            }
        }
    }
}

