/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jcr.InvalidItemStateException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;

public class H2MultiDbJDBCConnection
extends MultiDbJDBCConnection {
    public H2MultiDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        return this.traverseQPathSQ(cpid);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        if (this.containerConfig.useSequenceForOrderNumber) {
            this.FIND_LAST_ORDER_NUMBER = "call " + this.JCR_ITEM_SEQ + ".NEXTVAL";
        }
    }

    protected ResultSet findLastOrderNumber(int localMaxOrderNumber, boolean increment) throws SQLException {
        if (this.findLastOrderNumber == null) {
            this.findLastOrderNumber = this.dbConnection.prepareStatement(this.FIND_LAST_ORDER_NUMBER);
        }
        if (!increment) {
            int result = -1;
            while (result < localMaxOrderNumber - 1) {
                ResultSet count = this.findLastOrderNumber.executeQuery();
                if (!count.next()) continue;
                result = count.getInt(1);
            }
        }
        return this.findLastOrderNumber.executeQuery();
    }
}

