/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;

public class OracleMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    public OracleMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODES_BY_PARENTID_CQ_QUERY = this.FIND_NODES_BY_PARENTID_CQ_QUERY.replaceFirst("select", "select /*+ INDEX(I " + this.JCR_IDX_ITEM_PARENT_ID + ") INDEX(P " + this.JCR_IDX_ITEM_PARENT_ID + ") INDEX(V " + this.JCR_IDX_VALUE_PROPERTY + ")*/");
        this.FIND_PROPERTIES_BY_PARENTID_CQ_QUERY = this.FIND_PROPERTIES_BY_PARENTID_CQ_QUERY.replaceFirst("select", "select /*+ INDEX(I " + this.JCR_IDX_ITEM_PARENT_ID + ") INDEX(V " + this.JCR_IDX_VALUE_PROPERTY + ")*/");
        this.FIND_ITEM_QPATH_BY_ID_CQ_QUERY = this.FIND_ITEM_QPATH_BY_ID_CQ_QUERY.replaceFirst("SELECT", "SELECT /*+ INDEX(" + this.JCR_ITEM + " " + this.JCR_PK_ITEM + ") */");
        this.FIND_NODES_BY_PARENTID_CQ = this.FIND_NODES_BY_PARENTID_CQ_QUERY;
        this.FIND_PROPERTIES_BY_PARENTID_CQ = this.FIND_PROPERTIES_BY_PARENTID_CQ_QUERY;
        this.FIND_ITEM_QPATH_BY_ID_CQ = this.FIND_ITEM_QPATH_BY_ID_CQ_QUERY;
        this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE = "select /*+ INDEX(I " + this.JCR_FK_ITEM_PARENT + ") INDEX(V " + this.JCR_IDX_VALUE_PROPERTY + ")*/" + " I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED," + " V.ORDER_NUM, V.DATA, V.STORAGE_DESC from " + this.JCR_ITEM + " I LEFT OUTER JOIN " + this.JCR_VALUE + " V ON (V.PROPERTY_ID=I.ID)";
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from " + this.JCR_VALUE + " V, " + this.JCR_ITEM + " P" + " join ( select * from ( select A.*, ROWNUM r__ from (" + " select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from " + this.JCR_ITEM + " I " + " where I.I_CLASS=1 order by I.ID) A where ROWNUM <= ?) where r__ > ?) J on P.PARENT_ID = J.ID" + " where P.I_CLASS=2 and V.PROPERTY_ID=P.ID order by J.ID";
        if (this.containerConfig.useSequenceForOrderNumber) {
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = "select /*+ USE_NL(V) INDEX(I " + this.JCR_IDX_ITEM_N_ORDER_NUM + ") INDEX(P " + this.JCR_IDX_ITEM_PARENT_FK + ") INDEX(V " + this.JCR_IDX_VALUE_PROPERTY + ") */" + " I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from " + this.JCR_VALUE + " V, " + this.JCR_ITEM + " P " + " join ( select * from ( select A.*, ROWNUM r__ from ( select J.* from " + this.JCR_ITEM + " J " + " where J.I_CLASS=1 and J.PARENT_ID=? order by J.N_ORDER_NUM, J.ID " + " ) A where ROWNUM <= ?) where r__ > ?)  I on P.PARENT_ID = I.ID" + " where P.I_CLASS=2 and P.PARENT_ID=I.ID and" + " (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or" + " P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or" + " P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or" + " P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')" + " and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
            this.FIND_LAST_ORDER_NUMBER = "SELECT " + this.JCR_ITEM_NEXT_VAL + " ('" + this.JCR_ITEM_SEQ + "', ?, ?) FROM dual";
        } else {
            this.FIND_NODES_BY_PARENTID_LAZILY_CQ = this.FIND_NODES_BY_PARENTID_LAZILY_CQ.replaceFirst("select", "select /*+ USE_NL(V) INDEX(I " + this.JCR_IDX_ITEM_N_ORDER_NUM + ") INDEX(P " + this.JCR_IDX_ITEM_PARENT_FK + ") INDEX(V " + this.JCR_IDX_VALUE_PROPERTY + ") */");
        }
        this.FIND_REFERENCES = this.FIND_REFERENCES.replaceFirst("select", "select /*+ INDEX(R " + this.JCR_PK_REF + ")*/");
        this.FIND_PROPERTIES_BY_PARENTID = this.FIND_PROPERTIES_BY_PARENTID.replaceFirst("select", "select /*+ INDEX(" + this.JCR_ITEM + " " + this.JCR_IDX_ITEM_PARENT_NAME + ")*/");
        this.FIND_ITEM_BY_NAME = this.FIND_ITEM_BY_NAME.replaceFirst("select", "select /*+ INDEX(I " + this.JCR_IDX_ITEM_PARENT + ") */");
        this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ = this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ.replaceFirst("select", "select /*+ INDEX(I " + this.JCR_IDX_ITEM_PARENT_NAME + ") */");
        this.DELETE_ITEM = "delete /*+ INDEX(I " + this.JCR_PK_ITEM + ")*/ from " + this.JCR_ITEM + " I where I.ID=?";
    }

    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setInt(1, offset + limit);
        this.findNodesAndProperties.setInt(2, offset);
        return this.findNodesAndProperties.executeQuery();
    }

    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int offset, int limit) throws SQLException {
        if (!this.containerConfig.useSequenceForOrderNumber) {
            return super.findChildNodesByParentIdentifier(parentCid, fromOrderNum, offset, limit);
        }
        if (this.findNodesByParentIdLazilyCQ == null) {
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ);
        } else {
            this.findNodesByParentIdLazilyCQ.clearParameters();
        }
        this.findNodesByParentIdLazilyCQ.setString(1, parentCid);
        this.findNodesByParentIdLazilyCQ.setInt(2, offset + limit);
        this.findNodesByParentIdLazilyCQ.setInt(3, offset);
        return this.findNodesByParentIdLazilyCQ.executeQuery();
    }
}

