/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringEscapeUtils;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.query.Ordering;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.chromattic.core.query.QueryImpl;
import org.chromattic.ext.ntdef.NTFile;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.chromattic.entity.ActivityProfileEntity;
import org.exoplatform.social.core.chromattic.entity.DisabledEntity;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProfileEntity;
import org.exoplatform.social.core.chromattic.entity.ProfileXpEntity;
import org.exoplatform.social.core.chromattic.entity.ProviderEntity;
import org.exoplatform.social.core.chromattic.entity.RelationshipEntity;
import org.exoplatform.social.core.chromattic.entity.RelationshipListEntity;
import org.exoplatform.social.core.chromattic.entity.SpaceRef;
import org.exoplatform.social.core.identity.IdentityResult;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.ActiveIdentityFilter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.exception.NodeAlreadyExistsException;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.SpaceStorageImpl;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.QueryFunction;
import org.exoplatform.social.core.storage.query.WhereExpression;

public class IdentityStorageImpl
extends AbstractStorage
implements IdentityStorage {
    private static final Log LOG = ExoLogger.getLogger(IdentityStorageImpl.class);
    private IdentityStorage identityStorage;
    private RelationshipStorage relationshipStorage;
    private SpaceStorage spaceStorage;
    private OrganizationService organizationService;

    private Map<String, List<String>> createEntityParamMap(Object value) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        List map = (List)value;
        for (Map data : map) {
            ArrayList got = (ArrayList)params.get(data.get("key"));
            if (got == null) {
                got = new ArrayList();
            }
            got.add(data.get("value"));
            params.put((String)data.get("key"), got);
        }
        return params;
    }

    private void fillProfileParam(ProfileEntity profileEntity, List<Map<String, String>> dataList, String name) {
        for (String currentValue : profileEntity.getProperty(name)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", PropNs.cleanPrefix(name));
            map.put("value", currentValue);
            dataList.add(map);
        }
    }

    private void putParam(ProfileEntity profileEntity, Object value, PropNs propNs) {
        Map<String, List<String>> params = this.createEntityParamMap(value);
        for (String paramKey : params.keySet()) {
            profileEntity.setProperty(propNs.nameOf(paramKey), params.get(paramKey));
        }
    }

    private void clearPropertyForPrefix(ProfileEntity profileEntity, String prefix) {
        for (String key : profileEntity.getProperties().keySet()) {
            if (!key.startsWith(prefix)) continue;
            profileEntity.setProperty(key, null);
        }
    }

    private void putParam(ProfileEntity profileEntity, Object value, String key) {
        Map<String, List<String>> params = this.createEntityParamMap(value);
        Iterator<List<String>> valuesItr = params.values().iterator();
        List<String> values = null;
        if (valuesItr.hasNext()) {
            values = valuesItr.next();
        }
        profileEntity.setProperty(key, values);
    }

    private IdentityStorage getStorage() {
        return this.identityStorage != null ? this.identityStorage : this;
    }

    private RelationshipStorage getRelationshipStorage() {
        if (this.relationshipStorage == null) {
            this.relationshipStorage = (RelationshipStorage)PortalContainer.getInstance().getComponentInstanceOfType(RelationshipStorage.class);
        }
        return this.relationshipStorage;
    }

    private OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        }
        return this.organizationService;
    }

    private SpaceStorage getSpaceStorage() {
        if (this.spaceStorage == null) {
            this.spaceStorage = (SpaceStorage)PortalContainer.getInstance().getComponentInstanceOfType(SpaceStorage.class);
        }
        return this.spaceStorage;
    }

    private QueryResult<ProfileEntity> getSpaceMemberIdentitiesByProfileFilterQueryBuilder(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, long offset, long limit, boolean count) throws IdentityStorageException {
        if (offset < 0L) {
            offset = 0L;
        }
        String inputName = profileFilter.getName().replace("*", "%");
        StorageUtils.processUsernameSearchPattern(inputName.trim());
        List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.startGroup();
        whereExpression.like(JCRProperties.path, this.getProviderRoot().getProviders().get("organization").getPath() + "/" + "%").and().not().equals(ProfileEntity.deleted, "true");
        StorageUtils.applyExcludes(whereExpression, excludedIdentityList);
        StorageUtils.applyFilter(whereExpression, profileFilter);
        ArrayList<Identity> relations = new ArrayList<Identity>();
        try {
            Space gotSpace = this.getSpaceStorage().getSpaceById(space.getId());
            String[] members = null;
            switch (type) {
                case MEMBER: {
                    members = gotSpace.getMembers();
                    break;
                }
                case MANAGER: {
                    members = gotSpace.getManagers();
                    List<String> wildcardUsers = SpaceUtils.findMembershipUsersByGroupAndTypes(space.getGroupId(), "*");
                    for (String remoteId : wildcardUsers) {
                        relations.add(this.findIdentity("organization", remoteId));
                    }
                    break;
                }
            }
            for (int i = 0; i < members.length; ++i) {
                Identity identity = this.findIdentity("organization", members[i]);
                if (relations.contains(identity)) continue;
                relations.add(identity);
            }
        }
        catch (IdentityStorageException e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_FIND_IDENTITY);
        }
        whereExpression.endGroup();
        whereExpression.and();
        StorageUtils.applyWhereFromIdentity(whereExpression, relations);
        builder.where(whereExpression.toString());
        this.applyOrder(builder, profileFilter);
        if (count) {
            return builder.where(whereExpression.toString()).get().objects();
        }
        return builder.where(whereExpression.toString()).get().objects(Long.valueOf(offset), Long.valueOf(limit));
    }

    private void applyOrder(QueryBuilder builder, ProfileFilter profileFilter) {
        Sorting sorting = profileFilter == null ? new Sorting(Sorting.SortBy.TITLE, Sorting.OrderBy.ASC) : profileFilter.getSorting();
        Ordering ordering = Ordering.valueOf((String)sorting.orderBy.toString());
        switch (sorting.sortBy) {
            case DATE: {
                builder.orderBy(ProfileEntity.createdTime.getName(), ordering);
                break;
            }
            case RELEVANCY: {
                builder.orderBy(JCRProperties.JCR_RELEVANCY.getName(), ordering);
            }
            case TITLE: {
                builder.orderBy(ProfileEntity.lastName.getName(), ordering).orderBy(ProfileEntity.firstName.getName(), ordering);
            }
        }
    }

    protected IdentityEntity _createIdentity(Identity identity) throws NodeAlreadyExistsException {
        ProviderEntity providerEntity = this.getProviderRoot().getProvider(identity.getProviderId());
        if (providerEntity.getIdentities().containsKey(identity.getRemoteId())) {
            throw new NodeAlreadyExistsException("Identity " + identity.getRemoteId() + " already exists");
        }
        IdentityEntity identityEntity = providerEntity.createIdentity();
        providerEntity.getIdentities().put(identity.getRemoteId(), identityEntity);
        identityEntity.setProviderId(identity.getProviderId());
        identityEntity.setRemoteId(identity.getRemoteId());
        identityEntity.setDeleted(identity.isDeleted());
        identity.setId(identityEntity.getId());
        this.getSession().save();
        LOG.debug((Object)String.format("Identity %s:%s (%s) created", identity.getProviderId(), identity.getRemoteId(), identity.getId()));
        return identityEntity;
    }

    protected void _saveIdentity(Identity identity) throws NodeAlreadyExistsException, NodeNotFoundException {
        IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
        if (!identityEntity.getName().equals(identity.getRemoteId())) {
            identityEntity.setName(identity.getRemoteId());
        }
        if (!identityEntity.getProviderId().equals(identity.getProviderId())) {
            ProviderEntity providerEntity = this.getProviderRoot().getProvider(identity.getProviderId());
            providerEntity.getIdentities().put(identity.getRemoteId(), identityEntity);
        }
        identityEntity.setProviderId(identity.getProviderId());
        identityEntity.setRemoteId(identity.getRemoteId());
        identityEntity.setDeleted(identity.isDeleted());
        identity.setId(identityEntity.getId());
        this.getSession().save();
        LOG.debug((Object)String.format("Identity %s:%s (%s) saved", identity.getProviderId(), identity.getRemoteId(), identity.getId()));
    }

    protected void _deleteIdentity(Identity identity) throws NodeNotFoundException {
        if (identity == null || identity.getId() == null) {
            throw new IllegalArgumentException();
        }
        IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
        identity.setProviderId(identityEntity.getProviderId());
        identity.setRemoteId(identityEntity.getRemoteId());
        this.getSession().remove((Object)identityEntity);
        this.getSession().save();
        LOG.debug((Object)String.format("Identity %s:%s (%s) deleted", identity.getProviderId(), identity.getRemoteId(), identity.getId()));
    }

    protected void _hardDeleteIdentity(Identity identity) throws NodeNotFoundException {
        if (identity == null || identity.getId() == null) {
            throw new IllegalArgumentException();
        }
        IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
        this._removeRelationshipList(identityEntity.getSender());
        this._removeRelationshipList(identityEntity.getReceiver());
        this._removeRelationshipList(identityEntity.getRelationship());
        this._removeRelationshipList(identityEntity.getIgnore());
        this._removeRelationshipList(identityEntity.getIgnored());
        this._removeSpaceMembership(SpaceStorageImpl.RefType.MANAGER, identityEntity);
        this._removeSpaceMembership(SpaceStorageImpl.RefType.MEMBER, identityEntity);
        this._removeSpaceMembership(SpaceStorageImpl.RefType.PENDING, identityEntity);
        this._removeSpaceMembership(SpaceStorageImpl.RefType.INVITED, identityEntity);
        identity.setProviderId(identityEntity.getProviderId());
        identity.setRemoteId(identityEntity.getRemoteId());
        identityEntity.setDeleted(Boolean.TRUE);
        Profile profile = this.loadProfile(new Profile(new Identity(identityEntity.getId())));
        profile.setProperty("deleted", "true");
        this.saveProfile(profile);
        this.getSession().save();
        LOG.debug((Object)String.format("Identity %s:%s (%s) deleted", identity.getProviderId(), identity.getRemoteId(), identity.getId()));
    }

    protected void _removeRelationshipList(RelationshipListEntity listEntity) {
        for (RelationshipEntity relationshipEntity : listEntity.getRelationships().values()) {
            this.getRelationshipStorage().removeRelationship(this.getRelationshipStorage().getRelationship(relationshipEntity.getId()));
        }
    }

    protected void _removeSpaceMembership(SpaceStorageImpl.RefType refType, IdentityEntity identity) {
        for (SpaceRef ref : refType.refsOf(identity).getRefs().values()) {
            Space space = this.getSpaceStorage().getSpaceById(ref.getSpaceRef().getId());
            String[] ids = refType.idsOf(space);
            if (ids == null || ids.length == 0) continue;
            ArrayList<String> idList = new ArrayList<String>(Arrays.asList(ids));
            idList.remove(identity.getRemoteId());
            refType.setIds(space, idList.toArray(new String[0]));
            this.getSpaceStorage().saveSpace(space, false);
        }
    }

    protected Profile _createProfile(Profile profile) throws NodeNotFoundException {
        Identity identity = profile.getIdentity();
        if (identity.getId() == null) {
            throw new IllegalArgumentException();
        }
        IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
        ProfileEntity profileEntity = identityEntity.createProfile();
        identityEntity.setProfile(profileEntity);
        profile.setId(profileEntity.getId());
        ActivityProfileEntity activityPEntity = profileEntity.createActivityProfile();
        profileEntity.setActivityProfile(activityPEntity);
        profile.setCreatedTime(System.currentTimeMillis());
        this.getSession().save();
        LOG.debug((Object)String.format("Profile '%s' for %s:%s (%s) created", profile.getId(), identity.getProviderId(), identity.getRemoteId(), identity.getId()));
        this._saveProfile(profile);
        return profile;
    }

    protected Profile _loadProfile(Profile profile) throws NodeNotFoundException {
        if (profile.getIdentity().getId() == null) {
            throw new IllegalArgumentException();
        }
        String identityId = profile.getIdentity().getId();
        IdentityEntity identityEntity = this._findById(IdentityEntity.class, identityId);
        ProfileEntity profileEntity = identityEntity.getProfile();
        if (profileEntity == null) {
            throw new NodeNotFoundException("The identity " + identityId + " has no profile");
        }
        profile.setId(profileEntity.getId());
        this.populateProfile(profile, profileEntity);
        LOG.debug((Object)String.format("Profile '%s' for %s:%s (%s) loaded", profile.getId(), identityEntity.getProviderId(), identityEntity.getRemoteId(), identityEntity.getId()));
        return profile;
    }

    protected void _saveProfile(Profile profile) throws NodeNotFoundException {
        if (profile.getIdentity().getId() == null || profile.getId() == null) {
            throw new NullPointerException();
        }
        ProfileEntity profileEntity = this._findById(ProfileEntity.class, profile.getId());
        String providerId = profile.getIdentity().getProviderId();
        HashMap phonesData = new HashMap();
        for (String key : profile.getProperties().keySet()) {
            if (!this.isJcrProperty(key)) continue;
            Object value = profile.getProperty(key);
            if ("ims".equals(key)) {
                this.clearPropertyForPrefix(profileEntity, PropNs.IM.prefix);
                this.putParam(profileEntity, value, PropNs.IM);
                continue;
            }
            if ("phones".equals(key)) {
                this.clearPropertyForPrefix(profileEntity, PropNs.PHONE.prefix);
                this.putParam(profileEntity, value, PropNs.PHONE);
                continue;
            }
            if ("urls".equals(key)) {
                this.clearPropertyForPrefix(profileEntity, PropNs.URL.prefix);
                this.putParam(profileEntity, value, PropNs.URL.toString().toLowerCase());
                continue;
            }
            if ("experiences".equals(key)) {
                for (ProfileXpEntity xpEntity : profileEntity.getXps().values()) {
                    this._removeById(ProfileXpEntity.class, xpEntity.getId());
                }
                ArrayList<String> skills = new ArrayList<String>();
                ArrayList<String> organizations = new ArrayList<String>();
                ArrayList<String> jobsDescription = new ArrayList<String>();
                for (Map currentXp : (List)value) {
                    ProfileXpEntity xpEntity = profileEntity.createXp();
                    profileEntity.getXps().put(String.valueOf(System.currentTimeMillis()), xpEntity);
                    xpEntity.setSkills((String)currentXp.get("skills"));
                    xpEntity.setPosition((String)currentXp.get("position"));
                    xpEntity.setStartDate((String)currentXp.get("startDate"));
                    xpEntity.setEndDate((String)currentXp.get("endDate"));
                    xpEntity.setCompany((String)currentXp.get("company"));
                    xpEntity.setDescription((String)currentXp.get("description"));
                    if (xpEntity.getSkills() != null) {
                        skills.add(xpEntity.getSkills());
                    }
                    if (xpEntity.getCompany() != null) {
                        organizations.add(xpEntity.getCompany());
                    }
                    if (xpEntity.getDescription() == null) continue;
                    jobsDescription.add(xpEntity.getDescription());
                }
                profileEntity.setProperty(PropNs.INDEX.nameOf("skills"), skills);
                profileEntity.setProperty(PropNs.INDEX.nameOf("company"), organizations);
                profileEntity.setProperty(PropNs.INDEX.nameOf("description"), jobsDescription);
                continue;
            }
            if ("avatar".equals(key)) {
                AvatarAttachment attachement = (AvatarAttachment)value;
                NTFile avatar = profileEntity.getAvatar();
                if (avatar == null) {
                    avatar = profileEntity.createAvatar();
                    profileEntity.setAvatar(avatar);
                }
                avatar.setContentResource(new Resource(attachement.getMimeType(), null, attachement.getImageBytes()));
                continue;
            }
            if ("skills".equals(key)) continue;
            if (value != null) {
                ArrayList<String> lvalue = new ArrayList<String>();
                lvalue.add((String)value);
                profileEntity.setProperty(PropNs.VOID.nameOf(key), lvalue);
                continue;
            }
            profileEntity.setProperty(PropNs.VOID.nameOf(key), null);
        }
        profileEntity.setParentId(profile.getIdentity().getId());
        profileEntity.setCreatedTime(profile.getCreatedTime());
        if (!"organization".equals(providerId) && !"space".equals(providerId)) {
            profileEntity.setExternalUrl(profile.getUrl());
            profileEntity.setExternalAvatarUrl(profile.getAvatarUrl());
        }
        this.getSession().save();
        LOG.debug((Object)String.format("Profile '%s' for %s:%s (%s) saved", profile.getId(), profileEntity.getIdentity().getProviderId(), profileEntity.getIdentity().getRemoteId(), profileEntity.getIdentity().getId()));
    }

    protected Identity _findIdentity(String providerId, String remoteId) throws NodeNotFoundException {
        IdentityEntity identityEntity = this._findIdentityEntity(providerId, remoteId);
        Identity identity = new Identity(providerId, remoteId);
        identity.setDeleted(identityEntity.isDeleted());
        identity.setEnable(this._getMixin(identityEntity, DisabledEntity.class, false) == null);
        identity.setId(identityEntity.getId());
        try {
            this._loadProfile(identity.getProfile());
        }
        catch (NodeNotFoundException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        LOG.debug((Object)String.format("Identity  %s:%s (%s) found", identity.getProviderId(), identity.getRemoteId(), identity.getId()));
        return identity;
    }

    protected Identity _findIdentityEntity(String providerId, String remoteId, boolean forceLoadProfile) {
        Identity identity = null;
        try {
            if (!forceLoadProfile) {
                IdentityEntity identityEntity = this._findIdentityEntity(providerId, remoteId);
                identity = new Identity("organization", remoteId);
                identity.setId(identityEntity.getId());
                identity.setEnable(this._getMixin(identityEntity, DisabledEntity.class, false) == null);
            } else {
                identity = this._findIdentity(providerId, remoteId);
            }
        }
        catch (NodeNotFoundException e) {
            LOG.warn((Object)e.getMessage());
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        return identity;
    }

    protected IdentityEntity _findIdentityEntity(String providerId, String remoteId) throws NodeNotFoundException {
        ProviderEntity providerEntity;
        try {
            providerEntity = this.getProviderRoot().getProviders().get(providerId);
        }
        catch (Exception ex) {
            this.lifeCycle.getProviderRoot().set(null);
            providerEntity = this.getProviderRoot().getProviders().get(providerId);
        }
        if (providerEntity == null) {
            throw new NodeNotFoundException("The node " + providerId + " doesn't exist");
        }
        IdentityEntity identityEntity = providerEntity.getIdentities().get(remoteId);
        if (identityEntity == null) {
            throw new NodeNotFoundException("The node " + providerId + "/" + remoteId + " doesn't exist");
        }
        return identityEntity;
    }

    private Identity createIdentityFromEntity(IdentityEntity identityEntity) {
        return this.getStorage().findIdentityById(identityEntity.getId());
    }

    private void populateProfile(Profile profile, ProfileEntity profileEntity) {
        IdentityEntity identity = profileEntity.getIdentity();
        String providerId = identity.getProviderId();
        String remoteId = identity.getRemoteId();
        profile.setId(profileEntity.getId());
        profile.setCreatedTime(profileEntity.getCreatedTime());
        ArrayList<Map<String, String>> phones = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> ims = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> urls = new ArrayList<Map<String, String>>();
        try {
            for (String name : profileEntity.getProperties().keySet()) {
                if (!this.isJcrProperty(name)) continue;
                switch (PropNs.nsOf(name)) {
                    case VOID: 
                    case INDEX: {
                        profile.setProperty(PropNs.cleanPrefix(name), profileEntity.getProperty(name).get(0));
                        break;
                    }
                    case PHONE: {
                        this.fillProfileParam(profileEntity, phones, name);
                        break;
                    }
                    case IM: {
                        this.fillProfileParam(profileEntity, ims, name);
                        break;
                    }
                    case URL: {
                        this.fillProfileParam(profileEntity, urls, name);
                    }
                }
            }
        }
        catch (UndeclaredRepositoryException e) {
            LOG.warn((Object)e.getMessage());
        }
        if ("organization".equals(providerId) || "space".equals(providerId)) {
            if ("organization".equals(providerId)) {
                profile.setUrl(LinkProvider.getUserProfileUri(remoteId));
            } else if ("space".equals(providerId)) {
                this.spaceStorage = this.getSpaceStorage();
                if (this.spaceStorage.getSpaceByPrettyName(remoteId) != null) {
                    profile.setUrl(LinkProvider.getSpaceUri(remoteId));
                }
            }
            NTFile avatar = profileEntity.getAvatar();
            if (avatar != null) {
                try {
                    String avatarPath = this.getSession().getPath((Object)avatar);
                    long lastModified = avatar.getLastModified().getTime();
                    String avatarUrl = StorageUtils.encodeUrl(avatarPath) + "/?upd=" + lastModified;
                    profile.setAvatarUrl(LinkProvider.escapeJCRSpecialCharacters(avatarUrl));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to build file url from fileResource: " + e.getMessage()));
                }
            }
        } else {
            profile.setUrl(profileEntity.getExternalUrl());
            profile.setAvatarUrl(profileEntity.getExternalAvatarUrl());
        }
        if (phones.size() > 0) {
            profile.setProperty("phones", phones);
        }
        if (ims.size() > 0) {
            profile.setProperty("ims", ims);
        }
        if (urls.size() > 0) {
            profile.setProperty("urls", urls);
        }
        ArrayList xpData = new ArrayList();
        for (ProfileXpEntity xpEntity : profileEntity.getXps().values()) {
            HashMap<String, Object> xpMap = new HashMap<String, Object>();
            xpMap.put("skills", xpEntity.getSkills());
            xpMap.put("position", xpEntity.getPosition());
            xpMap.put("startDate", xpEntity.getStartDate());
            xpMap.put("endDate", xpEntity.getEndDate());
            xpMap.put("company", xpEntity.getCompany());
            xpMap.put("description", xpEntity.getDescription());
            xpMap.put("isCurrent", xpEntity.isCurrent());
            xpData.add(xpMap);
        }
        profile.setProperty("experiences", xpData);
    }

    @Override
    public void saveIdentity(Identity identity) throws IdentityStorageException {
        try {
            try {
                this._findById(IdentityEntity.class, identity.getId());
                this._saveIdentity(identity);
            }
            catch (NodeNotFoundException e) {
                this._createIdentity(identity);
                this._saveIdentity(identity);
            }
        }
        catch (NodeAlreadyExistsException e1) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_SAVE_IDENTITY, e1.getMessage(), e1);
        }
        catch (NodeNotFoundException e1) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_SAVE_IDENTITY, e1.getMessage(), e1);
        }
    }

    @Override
    public Identity updateIdentity(Identity identity) throws IdentityStorageException {
        this.saveIdentity(identity);
        return this.findIdentityById(identity.getId());
    }

    @Override
    public void updateIdentityMembership(String remoteId) throws IdentityStorageException {
    }

    @Override
    public void hardDeleteIdentity(Identity identity) throws IdentityStorageException {
        try {
            this._hardDeleteIdentity(identity);
        }
        catch (NodeNotFoundException e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_DELETE_IDENTITY, e.getMessage(), e);
        }
    }

    @Override
    public Identity findIdentityById(String nodeId) throws IdentityStorageException {
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, nodeId);
            Identity identity = new Identity(nodeId);
            identity.setDeleted(identityEntity.isDeleted());
            identity.setRemoteId(identityEntity.getRemoteId());
            identity.setProviderId(identityEntity.getProviderId());
            identity.setEnable(this._getMixin(identityEntity, DisabledEntity.class, false) == null);
            return identity;
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public void deleteIdentity(Identity identity) throws IdentityStorageException {
        try {
            this._deleteIdentity(identity);
        }
        catch (NodeNotFoundException e) {
            throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_DELETE_IDENTITY, e.getMessage(), e);
        }
    }

    @Override
    public Profile loadProfile(Profile profile) throws IdentityStorageException {
        try {
            profile = this._loadProfile(profile);
        }
        catch (NodeNotFoundException e) {
            try {
                profile = this._createProfile(profile);
            }
            catch (NodeNotFoundException e1) {
                throw new IdentityStorageException(IdentityStorageException.Type.FAIL_TO_FIND_IDENTITY_BY_NODE_ID, e1.getMessage(), e1);
            }
        }
        profile.clearHasChanged();
        return profile;
    }

    @Override
    public Identity findIdentity(String providerId, String remoteId) throws IdentityStorageException {
        try {
            return this._findIdentity(providerId, remoteId);
        }
        catch (NodeNotFoundException e) {
            return null;
        }
    }

    @Override
    public void saveProfile(Profile profile) throws IdentityStorageException {
        try {
            if (profile.getId() == null) {
                this._createProfile(profile);
            } else {
                this._saveProfile(profile);
            }
        }
        catch (NodeNotFoundException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        profile.clearHasChanged();
    }

    @Override
    public void updateProfile(Profile profile) throws IdentityStorageException {
        this.saveProfile(profile);
    }

    @Override
    public int getIdentitiesCount(String providerId) throws IdentityStorageException {
        ProviderEntity providerEntity = this.getProviderRoot().getProviders().get(providerId);
        Iterator<IdentityEntity> iter = providerEntity.getIdentities().values().iterator();
        int number = 0;
        while (iter.hasNext()) {
            if (this._getMixin(iter.next(), DisabledEntity.class, false) != null) continue;
            ++number;
        }
        return number;
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        if (offset < 0L) {
            offset = 0L;
        }
        String inputName = profileFilter.getName().replace("*", "%");
        StorageUtils.processUsernameSearchPattern(inputName.trim());
        List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, this.getProviderRoot().getProviders().get(providerId).getPath() + "/" + "%").and().not().equals(ProfileEntity.deleted, "true");
        StorageUtils.applyExcludes(whereExpression, excludedIdentityList);
        StorageUtils.applyFilter(whereExpression, profileFilter);
        builder.where(whereExpression.toString());
        this.applyOrder(builder, profileFilter);
        QueryImpl queryImpl = (QueryImpl)builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl)queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult results = queryImpl.objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            ProfileEntity profileEntity = (ProfileEntity)results.next();
            Identity identity = this.createIdentityFromEntity(profileEntity.getIdentity());
            if (!identity.isEnable()) continue;
            Profile profile = this.getStorage().loadProfile(new Profile(identity));
            identity.setProfile(profile);
            listIdentity.add(identity);
        }
        return listIdentity;
    }

    @Override
    public List<Identity> getIdentitiesForMentions(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        if (offset < 0L) {
            offset = 0L;
        }
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, this.getProviderRoot().getProviders().get(providerId).getPath() + "/" + "%").and().not().equals(ProfileEntity.deleted, "true");
        if (profileFilter != null) {
            List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
            StorageUtils.applyExcludes(whereExpression, excludedIdentityList);
            StorageUtils.applyFilter(whereExpression, profileFilter);
        }
        builder.where(whereExpression.toString());
        this.applyOrder(builder, profileFilter);
        QueryImpl queryImpl = (QueryImpl)builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl)queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult results = queryImpl.objects();
        IdentityResult identityResult = new IdentityResult(offset, limit, results.size());
        while (results.hasNext()) {
            ProfileEntity profileEntity = (ProfileEntity)results.next();
            Identity identity = this.createIdentityFromEntity(profileEntity.getIdentity());
            if (!identity.isEnable()) continue;
            Profile profile = this.getStorage().loadProfile(new Profile(identity));
            identity.setProfile(profile);
            identityResult.add(identity);
            if (identityResult.addMore()) continue;
            break;
        }
        return identityResult.result();
    }

    @Override
    public List<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter, long offset, long limit) throws IdentityStorageException {
        if (offset < 0L) {
            offset = 0L;
        }
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, this.getProviderRoot().getProviders().get(providerId).getPath() + "/" + "%").and().not().equals(ProfileEntity.deleted, "true");
        this._applyUnifiedSearchFilter(whereExpression, profileFilter);
        builder.where(whereExpression.toString());
        this.applyOrder(builder, profileFilter);
        QueryImpl queryImpl = (QueryImpl)builder.get();
        QueryResult results = queryImpl.objects(Long.valueOf(offset), Long.valueOf(limit));
        while (results.hasNext()) {
            ProfileEntity profileEntity = (ProfileEntity)results.next();
            Identity identity = this.createIdentityFromEntity(profileEntity.getIdentity());
            if (!identity.isEnable()) continue;
            Profile profile = this.getStorage().loadProfile(new Profile(identity));
            identity.setProfile(profile);
            listIdentity.add(identity);
        }
        return listIdentity;
    }

    @Override
    public int getIdentitiesByProfileFilterCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, this.getProviderRoot().getProviders().get(providerId).getPath() + "/" + "%").and().not().equals(ProfileEntity.deleted, "true");
        StorageUtils.applyExcludes(whereExpression, excludedIdentityList);
        StorageUtils.applyFilter(whereExpression, profileFilter);
        builder.where(whereExpression.toString());
        QueryResult results = builder.get().objects();
        return this.getCountFromQueryResult((QueryResult<ProfileEntity>)results);
    }

    private int getCountFromQueryResult(QueryResult<ProfileEntity> results) {
        int count = 0;
        while (results.hasNext()) {
            ProfileEntity profileEntity = (ProfileEntity)results.next();
            if (this._getMixin(profileEntity.getIdentity(), DisabledEntity.class, false) != null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getIdentitiesByFirstCharacterOfNameCount(String providerId, ProfileFilter profileFilter) throws IdentityStorageException {
        List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, this.getProviderRoot().getProviders().get(providerId).getPath() + "/" + "%").and().not().equals(ProfileEntity.deleted, "true");
        StorageUtils.applyExcludes(whereExpression, excludedIdentityList);
        StorageUtils.applyFilter(whereExpression, profileFilter);
        builder.where(whereExpression.toString());
        QueryResult results = builder.get().objects();
        return this.getCountFromQueryResult((QueryResult<ProfileEntity>)results);
    }

    @Override
    public List<Identity> getIdentitiesByFirstCharacterOfName(String providerId, ProfileFilter profileFilter, long offset, long limit, boolean forceLoadOrReloadProfile) throws IdentityStorageException {
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, this.getProviderRoot().getProviders().get(providerId).getPath() + "/" + "%").and().not().equals(ProfileEntity.deleted, "true");
        if (profileFilter != null) {
            List<Identity> excludedIdentityList = profileFilter.getExcludedIdentityList();
            StorageUtils.applyExcludes(whereExpression, excludedIdentityList);
            StorageUtils.applyFilter(whereExpression, profileFilter);
        }
        builder.where(whereExpression.toString());
        this.applyOrder(builder, profileFilter);
        QueryImpl queryImpl = (QueryImpl)builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl)queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult results = queryImpl.objects();
        IdentityResult identityResult = new IdentityResult(offset, limit, results.size());
        while (results.hasNext()) {
            ProfileEntity profileEntity = (ProfileEntity)results.next();
            Identity identity = this.createIdentityFromEntity(profileEntity.getIdentity());
            if (!identity.isEnable()) continue;
            Profile profile = this.getStorage().loadProfile(new Profile(identity));
            identity.setProfile(profile);
            identityResult.add(identity);
            if (identityResult.addMore()) continue;
            break;
        }
        return identityResult.result();
    }

    @Override
    public String getType(String nodetype, String property) {
        Session jcrSession = this.getSession().getJCRSession();
        try {
            PropertyDefinition[] pDefs;
            NodeTypeManager ntManager = jcrSession.getWorkspace().getNodeTypeManager();
            NodeType nt = ntManager.getNodeType(nodetype);
            for (PropertyDefinition pDef : pDefs = nt.getDeclaredPropertyDefinitions()) {
                if (!pDef.getName().equals(property)) continue;
                return PropertyType.nameFromValue((int)pDef.getRequiredType());
            }
        }
        catch (RepositoryException e) {
            return null;
        }
        return null;
    }

    @Override
    public void addOrModifyProfileProperties(Profile profile) throws IdentityStorageException {
        this.getStorage().updateProfile(profile);
    }

    public void setStorage(IdentityStorage storage) {
        this.identityStorage = storage;
    }

    @Override
    public List<Identity> getSpaceMemberIdentitiesByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, long offset, long limit) throws IdentityStorageException {
        ArrayList<Identity> listIdentity = new ArrayList<Identity>();
        QueryResult<ProfileEntity> results = this.getSpaceMemberIdentitiesByProfileFilterQueryBuilder(space, profileFilter, type, offset, limit, false);
        while (results.hasNext()) {
            ProfileEntity profileEntity = (ProfileEntity)results.next();
            Identity identity = this.createIdentityFromEntity(profileEntity.getIdentity());
            if (!identity.isEnable()) continue;
            Profile profile = this.getStorage().loadProfile(new Profile(identity));
            identity.setProfile(profile);
            listIdentity.add(identity);
        }
        return listIdentity;
    }

    public int getSpaceMemberIdentitiesByProfileFilterCount(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, long offset, long limit) throws IdentityStorageException {
        return this.getSpaceMemberIdentitiesByProfileFilterQueryBuilder(space, profileFilter, type, offset, limit, true).size();
    }

    @Override
    public void updateProfileActivityId(Identity identity, String activityId, Profile.AttachedActivityType type) {
        try {
            ProfileEntity profileEntity = this._findById(ProfileEntity.class, identity.getProfile().getId());
            ActivityProfileEntity activityPEntity = profileEntity.getActivityProfile();
            if (activityPEntity == null) {
                activityPEntity = profileEntity.createActivityProfile();
            }
            profileEntity.setActivityProfile(activityPEntity);
            type.setActivityId(activityPEntity, activityId);
        }
        catch (NodeNotFoundException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getProfileActivityId(Profile profile, Profile.AttachedActivityType type) {
        try {
            ProfileEntity profileEntity = this._findById(ProfileEntity.class, profile.getId());
            ActivityProfileEntity activityPEntity = profileEntity.getActivityProfile();
            return type.getActivityId(activityPEntity);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void processEnabledIdentity(Identity identity, boolean isEnable) {
        try {
            IdentityEntity identityEntity = this._findById(IdentityEntity.class, identity.getId());
            if (isEnable) {
                this._removeMixin(identityEntity, DisabledEntity.class);
            } else {
                this._getMixin(identityEntity, DisabledEntity.class, true);
            }
            this.getSession().save();
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Process enable identity of user %s unsuccessfully.", identity.getRemoteId()));
            LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void _applyUnifiedSearchFilter(WhereExpression whereExpression, ProfileFilter profileFilter) {
        if (profileFilter == null) {
            return;
        }
        String searchCondition = StorageUtils.escapeSpecialCharacter(profileFilter.getAll());
        if (searchCondition != null && searchCondition.length() != 0 && this.isValidInput(searchCondition)) {
            List<String> unifiedSearchConditions = StorageUtils.processUnifiedSearchCondition(searchCondition);
            if (unifiedSearchConditions.size() > 0) {
                whereExpression.and().startGroup();
            }
            boolean first = true;
            for (String condition : unifiedSearchConditions) {
                if (!first) {
                    whereExpression.or();
                }
                if (condition.contains("%")) {
                    String conditionEscapeHtml = StringEscapeUtils.escapeHtml((String)condition).toLowerCase();
                    whereExpression.startGroup();
                    whereExpression.like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.fullName), condition.toLowerCase()).or().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.firstName), condition.toLowerCase()).or().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.lastName), condition.toLowerCase()).or().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.position), conditionEscapeHtml).or().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.skills), conditionEscapeHtml).or().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.positions), conditionEscapeHtml).or().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.organizations), conditionEscapeHtml).or().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.jobsDescription), conditionEscapeHtml);
                    whereExpression.endGroup();
                } else {
                    whereExpression.startGroup();
                    whereExpression.contains(ProfileEntity.fullName, condition).or().contains(ProfileEntity.firstName, condition).or().contains(ProfileEntity.lastName, condition).or().contains(ProfileEntity.position, condition).or().contains(ProfileEntity.skills, condition).or().contains(ProfileEntity.positions, condition).or().contains(ProfileEntity.organizations, condition).or().contains(ProfileEntity.jobsDescription, condition);
                    whereExpression.endGroup();
                }
                first = false;
            }
            if (unifiedSearchConditions.size() > 0) {
                whereExpression.endGroup();
            }
        }
    }

    private boolean isValidInput(String input) {
        if (input == null || input.length() == 0) {
            return false;
        }
        String cleanString = input.replaceAll("\\*", "");
        return (cleanString = cleanString.replaceAll("\\%", "")).length() != 0;
    }

    @Override
    public Set<String> getActiveUsers(ActiveIdentityFilter filter) {
        HashSet<String> activeUsers = new HashSet();
        if (filter.getUserGroups() != null) {
            StringTokenizer stringToken = new StringTokenizer(filter.getUserGroups(), ",");
            try {
                while (stringToken.hasMoreTokens()) {
                    try {
                        User[] users;
                        ListAccess listAccess = this.getOrganizationService().getUserHandler().findUsersByGroupId(stringToken.nextToken().trim());
                        for (User u : users = (User[])listAccess.load(0, listAccess.getSize())) {
                            activeUsers.add(u.getUserName());
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
        }
        if (filter.getDays() > 0) {
            activeUsers = StorageUtils.getLastLogin(filter.getDays());
        }
        if (CommonsUtils.getService(UserStateService.class) != null) {
            List onlines = ((UserStateService)CommonsUtils.getService(UserStateService.class)).online();
            for (UserStateModel user : onlines) {
                activeUsers.add(user.getUserId());
            }
        }
        return activeUsers;
    }

    static enum PropNs {
        VOID("void"),
        IM("im"),
        PHONE("phone"),
        URL("url"),
        INDEX("index");

        private String prefix;
        private static final String SEPARATOR = "-";

        private PropNs(String prefix) {
            this.prefix = prefix;
        }

        public String nameOf(String prop) {
            return String.format("%s%s%s", this.prefix, SEPARATOR, prop);
        }

        public static PropNs nsOf(String fullName) {
            int index = fullName.indexOf(SEPARATOR);
            String prefix = index >= 0 ? fullName.substring(0, index) : fullName;
            return PropNs.valueOf(prefix.toUpperCase());
        }

        public static String cleanPrefix(String name) {
            int index = name.indexOf(SEPARATOR) + 1;
            return index >= 0 ? name.substring(index) : name;
        }
    }
}

