/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.space;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.SpaceRestResources;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.service.rest.api.models.ActivityRestIn;

@Path(value="v1/social/spaces")
@Api(tags={"v1/social/spaces"}, value="v1/social/spaces", description="Operations on spaces with their activities and users")
public class SpaceRestResourcesV1
implements SpaceRestResources {
    @Override
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets spaces of user", httpMethod="GET", response=Response.class, notes="This returns a list of spaces in the following cases: <br/><ul><li>the authenticated user is a member of the spaces</li><li>the spaces are \"public\"</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaces(@Context UriInfo uriInfo, @ApiParam(value="Space name search information", required=false) @QueryParam(value="q") String q, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of spaces found or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        ListAccess listAccess = null;
        SpaceFilter spaceFilter = null;
        if (q != null) {
            spaceFilter = new SpaceFilter();
            spaceFilter.setSpaceNameSearchCondition(q);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        listAccess = RestUtils.isMemberOfAdminGroup() ? spaceService.getAllSpacesByFilter(spaceFilter) : spaceService.getAccessibleSpacesByFilter(authenticatedUser, spaceFilter);
        ArrayList<DataEntity> spaceInfos = new ArrayList<DataEntity>();
        for (Space space : (Space[])listAccess.load(offset, limit)) {
            SpaceEntity spaceInfo = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand);
            spaceInfos.add(spaceInfo.getDataEntity());
        }
        CollectionEntity collectionSpace = new CollectionEntity(spaceInfos, "spaces", offset, limit);
        if (returnSize) {
            collectionSpace.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates a space", httpMethod="POST", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response createSpace(@Context UriInfo uriInfo, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Space object to be created, ex:<br />{<br />\"displayName\": \"My space\",<br />\"description\": \"This is my space\",<br />\"groupId\": \"/spaces/my_space\",<br />\"visibility\": \"private\",<br />\"subscription\": \"validation\"<br />}", required=true) SpaceEntity model) throws Exception {
        if (model == null || model.getDisplayName() == null || model.getDisplayName().length() == 0) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (spaceService.getSpaceByDisplayName(model.getDisplayName()) != null) {
            throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = new Space();
        this.fillSpaceFromModel(space, model);
        space.setPriority("2");
        space.setGroupId("/spaces/space" + space.getPrettyName());
        space.setType("classic");
        String[] managers = new String[]{authenticatedUser};
        String[] members = new String[]{authenticatedUser};
        space.setManagers(managers);
        space.setMembers(members);
        spaceService.createSpace(space, authenticatedUser);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific space by id", httpMethod="GET", response=Response.class, notes="This returns the space in the following cases: <br/><ul><li>the authenticated user is a member of the space</li><li>the space is \"public\"</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaceById(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceById(id);
        if (space == null || "hidden".equals(space.getVisibility()) && !spaceService.isMember(space, authenticatedUser) && !RestUtils.isMemberOfAdminGroup()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific space by id", httpMethod="PUT", response=Response.class, notes="This updates the space in the following cases: <br/><ul><li>the authenticated user is a manager of the space</li><li>the authenticated user is the owner of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response updateSpaceById(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: members or managers", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Space object to be updated", required=true) SpaceEntity model) throws Exception {
        if (model == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceById(id);
        if (space == null || !spaceService.isManager(space, authenticatedUser) && !RestUtils.isMemberOfAdminGroup()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (model.getGroupId() != null && model.getGroupId().length() > 0) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.fillSpaceFromModel(space, model);
        spaceService.updateSpace(space);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific space by id", httpMethod="DELETE", response=Response.class, notes="This deletes the space in the following cases: <br/><ul><li>the authenticated user is a manager of the space</li><li>the authenticated user is the owner of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteSpaceById(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceById(id);
        if (space == null || !spaceService.isManager(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        spaceService.deleteSpace(space);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/users")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets users of a specific space", httpMethod="GET", response=Response.class, notes="This returns a list of users if the authenticated user is a member or manager of the space.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaceMembers(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Role of the target user in this space, ex: manager", required=false, defaultValue="0") @QueryParam(value="role") String role, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of users or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceById(id);
        if (space == null || !spaceService.isMember(space, authenticatedUser) && !RestUtils.isMemberOfAdminGroup()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String[] users = role != null && role.equals("manager") ? space.getManagers() : space.getMembers();
        int size = users.length;
        if (limit > 0) {
            users = Arrays.copyOfRange(users, offset > size - 1 ? size - 1 : offset, offset + limit > size ? size : offset + limit);
        }
        List<DataEntity> profileInfos = EntityBuilder.buildEntityProfiles(users, uriInfo.getPath(), expand);
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(size);
        }
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/activities")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets space activities by space id", httpMethod="GET", response=Response.class, notes="This returns the space's activities if the authenticated user is a member of the space.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpaceActivitiesById(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Base time to load older activities (yyyy-MM-dd HH:mm:ss)", required=false) @QueryParam(value="before") String before, @ApiParam(value="Base time to load newer activities (yyyy-MM-dd HH:mm:ss)", required=false) @QueryParam(value="after") String after, @ApiParam(value="Returning the number of activities or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceById(id);
        if (space == null || !spaceService.isMember(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity spaceIdentity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("space", space.getPrettyName(), false);
        RealtimeListAccess listAccess = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivitiesOfSpaceWithListAccess(spaceIdentity);
        List activities = null;
        activities = after != null && RestUtils.getBaseTime(after) > 0L ? listAccess.loadNewer(Long.valueOf(RestUtils.getBaseTime(after)), limit) : (before != null && RestUtils.getBaseTime(before) > 0L ? listAccess.loadOlder(Long.valueOf(RestUtils.getBaseTime(before)), limit) : listAccess.loadAsList(offset, limit));
        ArrayList<DataEntity> activityEntities = new ArrayList<DataEntity>();
        BaseEntity as = new BaseEntity(spaceIdentity.getRemoteId());
        as.setProperty("type", "space");
        for (ExoSocialActivity activity : activities) {
            ActivityEntity activityInfo = EntityBuilder.buildEntityFromActivity(activity, uriInfo.getPath(), expand);
            activityInfo.setActivityStream(as.getDataEntity());
            activityEntities.add(activityInfo.getDataEntity());
        }
        CollectionEntity collectionActivity = new CollectionEntity(activityEntities, "activities", offset, limit);
        if (returnSize) {
            if (before != null || after != null) {
                collectionActivity.setSize(activities.size());
            } else {
                collectionActivity.setSize(listAccess.getSize());
            }
        }
        return EntityBuilder.getResponse(collectionActivity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @Path(value="{id}/activities")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Posts an activity to a specific space", httpMethod="POST", response=Response.class, notes="This posts the activity if the authenticated user is a member of the space.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response postActivityOnSpace(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Activity object to be created", required=true) ActivityRestIn model) throws Exception {
        if (model == null || model.getTitle() == null || model.getTitle().length() == 0) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        Space space = spaceService.getSpaceById(id);
        if (space == null || !spaceService.isMember(space, authenticatedUser)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity spaceIdentity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("space", space.getPrettyName(), false);
        Identity poster = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, false);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(model.getTitle());
        activity.setUserId(poster.getId());
        ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromActivity((ExoSocialActivity)activity, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    private void fillSpaceFromModel(Space space, SpaceEntity model) {
        if (model.getDisplayName() != null && model.getDisplayName().length() > 0) {
            space.setDisplayName(model.getDisplayName());
        }
        if (model.getDescription() != null && model.getDescription().length() > 0) {
            space.setDescription(StringEscapeUtils.escapeHtml((String)model.getDescription()));
        }
        if (space.getGroupId() == null) {
            String groupId = model.getDisplayName();
            if (model.getGroupId() != null && model.getGroupId().length() > 0) {
                groupId = model.getGroupId();
                if (groupId.indexOf("/") >= 0) {
                    groupId = groupId.substring(groupId.lastIndexOf("/") + 1);
                }
                if (groupId == "") {
                    groupId = model.getDisplayName();
                }
            }
            space.setPrettyName(groupId);
        }
        if (model.getVisibility() != null && (model.getVisibility().equals("hidden") || model.getVisibility().equals("private"))) {
            space.setVisibility(model.getVisibility());
        } else if (space.getVisibility() == null || space.getVisibility().length() == 0) {
            space.setVisibility("private");
        }
        if ("open".equals(model.getSubscription()) || "close".equals(model.getSubscription())) {
            space.setRegistration(model.getSubscription());
        } else if (space.getRegistration() == null || space.getRegistration().length() == 0) {
            space.setRegistration("validation");
        }
    }
}

