/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.ed.ph.snuggletex.DOMOutputOptions;
import uk.ac.ed.ph.snuggletex.SessionConfiguration;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinCommand;
import uk.ac.ed.ph.snuggletex.definitions.BuiltinEnvironment;
import uk.ac.ed.ph.snuggletex.definitions.DefinitionMap;
import uk.ac.ed.ph.snuggletex.definitions.GlobalBuiltins;
import uk.ac.ed.ph.snuggletex.internal.util.ConstraintUtilities;
import uk.ac.ed.ph.snuggletex.utilities.SimpleStylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetCache;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;

public final class SnuggleEngine {
    private final List<DefinitionMap> definitionMaps = new ArrayList<DefinitionMap>();
    private final StylesheetManager stylesheetManager;
    private SessionConfiguration defaultSessionConfiguration = new SessionConfiguration();
    private DOMOutputOptions defaultDOMOptions = new DOMOutputOptions();

    public SnuggleEngine() {
        this(new SimpleStylesheetCache());
    }

    public SnuggleEngine(StylesheetCache stylesheetCache) {
        this.stylesheetManager = new StylesheetManager(stylesheetCache);
        this.definitionMaps.add(GlobalBuiltins.getDefinitionMap());
    }

    public void registerDefinitions(DefinitionMap definitionMap) {
        this.definitionMaps.add(definitionMap);
    }

    public SnuggleSession createSession() {
        return this.createSession(this.defaultSessionConfiguration);
    }

    public SnuggleSession createSession(SessionConfiguration configuration) {
        ConstraintUtilities.ensureNotNull(configuration, "configuration");
        return new SnuggleSession(this, configuration);
    }

    public BuiltinCommand getCommandByTeXName(String texName) {
        DefinitionMap map;
        ConstraintUtilities.ensureNotNull(texName, "texName");
        BuiltinCommand result = null;
        Iterator<DefinitionMap> i$ = this.definitionMaps.iterator();
        while (i$.hasNext() && (result = (map = i$.next()).getCommandByTeXName(texName)) == null) {
        }
        return result;
    }

    public BuiltinEnvironment getEnvironmentByTeXName(String texName) {
        DefinitionMap map;
        ConstraintUtilities.ensureNotNull(texName, "texName");
        BuiltinEnvironment result = null;
        Iterator<DefinitionMap> i$ = this.definitionMaps.iterator();
        while (i$.hasNext() && (result = (map = i$.next()).getEnvironmentByTeXName(texName)) == null) {
        }
        return result;
    }

    public SessionConfiguration getDefaultSessionConfiguration() {
        return this.defaultSessionConfiguration;
    }

    public void setDefaultSessionConfiguration(SessionConfiguration defaultSessionConfiguration) {
        ConstraintUtilities.ensureNotNull(defaultSessionConfiguration, "defaultSessionConfiguration");
        this.defaultSessionConfiguration = defaultSessionConfiguration;
    }

    public DOMOutputOptions getDefaultDOMOptions() {
        return this.defaultDOMOptions;
    }

    public void setDefaultDOMOptions(DOMOutputOptions defaultDOMOptions) {
        ConstraintUtilities.ensureNotNull(defaultDOMOptions, "defaultDOMOptions");
        this.defaultDOMOptions = defaultDOMOptions;
    }

    public StylesheetManager getStylesheetManager() {
        return this.stylesheetManager;
    }
}

