/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleLogicException;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.SnuggleInputReader;

public final class WorkingDocument {
    private final SnuggleInput input;
    private final StringBuilder buffer;
    private final List<Slice> scoreBoard = new ArrayList<Slice>();
    private int length;
    private int freezeIndex = 0;
    int lastResolvedSliceIndex = 0;

    WorkingDocument(CharSequence initialData, SnuggleInputReader inputReader) {
        this.buffer = new StringBuilder(initialData);
        this.length = this.buffer.length();
        this.input = inputReader.getInput();
        CharacterSource initialComponent = new CharacterSource(inputReader);
        this.scoreBoard.add(new Slice(0, this.length, initialComponent, 0));
    }

    public SnuggleInput getInput() {
        return this.input;
    }

    public FrozenSlice freezeSlice(int startIndex, int endIndex) {
        this.checkRange(startIndex, endIndex);
        this.freezeIndex = Math.max(this.freezeIndex, endIndex);
        return new FrozenSlice(this, startIndex, endIndex);
    }

    public void unfreeze(int newFreezeIndex) {
        this.freezeIndex = newFreezeIndex;
    }

    public int length() {
        return this.length;
    }

    public IndexResolution resolveIndex(int index, boolean fallLeftOnBoundaries) {
        this.checkIndex(index, "Index");
        if (fallLeftOnBoundaries && index == 0) {
            return null;
        }
        IndexResolution result = null;
        int sliceIndex = this.lastResolvedSliceIndex;
        int numSlices = this.scoreBoard.size();
        while (sliceIndex >= 0 && sliceIndex < numSlices) {
            Slice mapping = this.scoreBoard.get(sliceIndex);
            if (mapping.startIndex > index) {
                --sliceIndex;
                continue;
            }
            if (index < mapping.endIndex || fallLeftOnBoundaries && index == mapping.endIndex) {
                result = new IndexResolution(sliceIndex, mapping, index + mapping.componentIndexOffset);
                break;
            }
            ++sliceIndex;
        }
        this.lastResolvedSliceIndex = result != null ? sliceIndex : this.lastResolvedSliceIndex;
        return result;
    }

    public int charAt(int index) {
        if (index >= 0 && index < this.length) {
            return this.buffer.charAt(index);
        }
        return -1;
    }

    public boolean matchesAt(int index, char c) {
        return this.charAt(index) == c;
    }

    public boolean matchesAt(int index, String s) {
        if (this.length() - index < s.length()) {
            return false;
        }
        return s.equals(this.extract(index, index + s.length()));
    }

    public int indexOf(int startSearchIndex, char c) {
        for (int i = startSearchIndex; i < this.length(); ++i) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int startSearchIndex, String s) {
        int lastSearchIndex = this.length() - s.length();
        for (int i = startSearchIndex; i <= lastSearchIndex; ++i) {
            if (!this.matchesAt(i, s)) continue;
            return i;
        }
        return -1;
    }

    public boolean isRegionWhitespace(int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return false;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            if (Character.isWhitespace(this.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public CharSequence extract() {
        return this.buffer;
    }

    public CharSequence extract(int startIndex, int endIndex) {
        this.checkRange(startIndex, endIndex);
        return this.buffer.subSequence(startIndex, endIndex);
    }

    public CharacterSource substitute(int startIndex, int endIndex, CharSequence replacement) {
        this.checkRange(startIndex, endIndex);
        SubstitutionContext context = new SubstitutionContext(replacement);
        if (startIndex < this.freezeIndex) {
            throw new IllegalArgumentException("Cannot modify frozen part of document (startIndex=" + startIndex + ",freezeIndex=" + this.freezeIndex + ",attemptedText=" + this.buffer.substring(this.freezeIndex, Math.min(this.freezeIndex + 20, this.length)) + ")");
        }
        IndexResolution startResolution = this.resolveIndex(startIndex, false);
        if (startResolution == null) {
            CharacterSource toAppend = new CharacterSource(context);
            int newStartIndex = this.length;
            this.buffer.append(replacement);
            int newLength = this.buffer.length();
            Slice newEndSlice = new Slice(newStartIndex, newLength, toAppend, -newStartIndex);
            this.scoreBoard.add(newEndSlice);
            this.length = newLength;
            return toAppend;
        }
        CharSequence beingReplaced = this.buffer.subSequence(startIndex, endIndex);
        this.buffer.delete(startIndex, endIndex);
        this.buffer.insert(startIndex, replacement);
        int startSliceIndex = startResolution.scoreboardIndex;
        ArrayList<Slice> newScoreBoard = new ArrayList<Slice>();
        for (int i = 0; i < startSliceIndex; ++i) {
            newScoreBoard.add(this.scoreBoard.get(i));
        }
        Slice startSlice = startResolution.slice;
        if (startIndex > startSlice.startIndex) {
            Slice bitBefore = new Slice(startSlice.startIndex, startIndex, startSlice.resolvedComponent, startSlice.componentIndexOffset);
            newScoreBoard.add(bitBefore);
        }
        int currentIndex = startIndex;
        int substitutionSize = replacement.length();
        CharacterSource result = new CharacterSource(context, startResolution.slice.resolvedComponent, startResolution.indexInComponent, beingReplaced);
        Slice substitutionSlice = new Slice(currentIndex, currentIndex + substitutionSize, result, -currentIndex);
        currentIndex += substitutionSize;
        newScoreBoard.add(substitutionSlice);
        IndexResolution endResolution = this.resolveIndex(endIndex, true);
        Slice endSlice = endResolution.slice;
        if (endIndex < endSlice.endIndex) {
            int bitAfterSize = endSlice.endIndex - endIndex;
            int resultOffset = endSlice.componentIndexOffset + endIndex - currentIndex;
            Slice bitAfter = new Slice(currentIndex, currentIndex + bitAfterSize, endSlice.resolvedComponent, resultOffset);
            newScoreBoard.add(bitAfter);
            currentIndex += bitAfterSize;
        }
        int size = this.scoreBoard.size();
        for (int i = endResolution.scoreboardIndex + 1; i < size; ++i) {
            Slice trailingSlice = this.scoreBoard.get(i);
            int afterSliceLength = trailingSlice.endIndex - trailingSlice.startIndex;
            int shiftedOffset = trailingSlice.componentIndexOffset + trailingSlice.startIndex - currentIndex;
            Slice shiftedTrailingSlice = new Slice(currentIndex, currentIndex + afterSliceLength, trailingSlice.resolvedComponent, shiftedOffset);
            newScoreBoard.add(shiftedTrailingSlice);
            currentIndex += afterSliceLength;
        }
        this.scoreBoard.clear();
        this.scoreBoard.addAll(newScoreBoard);
        if (this.buffer.length() != currentIndex) {
            throw new SnuggleLogicException("Failed sanity check: buffer length is " + this.buffer.length() + ", last board index=" + currentIndex);
        }
        this.length = currentIndex;
        return result;
    }

    private void checkRange(int startIndex, int endIndex) {
        this.checkIndex(startIndex, "Start Index");
        this.checkIndex(endIndex, "End Index");
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("Start index " + startIndex + " must be <= end index " + endIndex);
        }
    }

    private void checkIndex(int index, String errorStart) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException(errorStart + " " + index + " is outwith the current bounds [0," + this.length + ")");
        }
    }

    public void dumpScoreboard() {
        for (Slice mapping : this.scoreBoard) {
            System.out.println(mapping);
        }
    }

    public static final class SubstitutionContext
    implements SourceContext {
        public CharSequence replacement;

        public SubstitutionContext(CharSequence replacement) {
            this.replacement = replacement;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(replacement=" + this.replacement + ")";
        }
    }

    public static interface SourceContext {
    }

    public static class IndexResolution {
        public final int scoreboardIndex;
        public final Slice slice;
        public final int indexInComponent;

        public IndexResolution(int scoreboardIndex, Slice slice, int indexInComponent) {
            this.scoreboardIndex = scoreboardIndex;
            this.slice = slice;
            this.indexInComponent = indexInComponent;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(sbIndex=" + this.scoreboardIndex + ", slice=" + this.slice + ", indexInComponent=" + this.indexInComponent + ")";
        }
    }

    public static final class Slice {
        public final int startIndex;
        public final int endIndex;
        public final CharacterSource resolvedComponent;
        public final int componentIndexOffset;

        public Slice(int startIndex, int endIndex, CharacterSource resolvedComponent, int componentIndexOffset) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.resolvedComponent = resolvedComponent;
            this.componentIndexOffset = componentIndexOffset;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(span=[" + this.startIndex + "," + this.endIndex + ") => " + this.resolvedComponent + "; offset " + this.componentIndexOffset + ")";
        }
    }

    public static final class CharacterSource {
        public final SourceContext context;
        public final CharacterSource substitutedSource;
        public final int substitutionOffset;
        public final CharSequence substitutedText;
        private transient String stringRepresentation;

        public CharacterSource(SourceContext context) {
            this(context, null, 0, null);
        }

        public CharacterSource(SourceContext context, CharacterSource substitutedSource, int substitutionOffset, CharSequence substitutedText) {
            this.context = context;
            this.substitutedSource = substitutedSource;
            this.substitutionOffset = substitutionOffset;
            this.substitutedText = substitutedText;
        }

        public String toString() {
            if (this.stringRepresentation == null) {
                StringBuilder resultBuilder = new StringBuilder(this.getClass().getSimpleName()).append("(context=").append(this.context);
                if (this.substitutedSource != null) {
                    resultBuilder.append(",substituted=").append(this.substitutedSource).append(",offset=").append(this.substitutionOffset).append(",substitutedText=").append(this.substitutedText);
                }
                resultBuilder.append(")");
                this.stringRepresentation = resultBuilder.toString();
            }
            return this.stringRepresentation;
        }
    }
}

