/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.folksonomy.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.folksonomy.impl.TagPermissionPlugin;
import org.exoplatform.services.cms.folksonomy.impl.TagStylePlugin;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class NewFolksonomyServiceImpl
implements NewFolksonomyService,
Startable {
    private static final String USER_FOLKSONOMY_ALIAS = "userPrivateFolksonomy";
    private static final String GROUPS_ALIAS = "groupsPath";
    private static final String TAG_STYLE_ALIAS = "exoTagStylePath";
    private static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    private static final String EXO_TRASH_FOLDER = "exo:trashFolder";
    private static final String EXO_HIDDENABLE = "exo:hiddenable";
    private static final String TAG_PERMISSION_LIST = "tagPermissionList";
    private static final Log LOG = ExoLogger.getLogger((String)NewFolksonomyServiceImpl.class.getName());
    private NodeHierarchyCreator nodeHierarchyCreator;
    private LinkManager linkManager;
    private InitParams initParams_;
    private List<TagStylePlugin> plugin_ = new ArrayList<TagStylePlugin>();
    private List<TagPermissionPlugin> tagPermissionPlugin_ = new ArrayList<TagPermissionPlugin>();
    private ExoCache<String, List<String>> tagPermissionList;
    private Map<String, String> sitesTagPath = new HashMap<String, String>();
    private ListenerService listenerService;
    private ActivityCommonService activityService;
    private DataDistributionType dataDistributionType;

    public NewFolksonomyServiceImpl(InitParams initParams, NodeHierarchyCreator nodeHierarchyCreator, LinkManager linkManager, DataDistributionManager dataDistributionManager, SessionProviderService sessionProviderService, CacheService cacheService) throws Exception {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.linkManager = linkManager;
        this.initParams_ = initParams;
        this.listenerService = WCMCoreUtils.getService(ListenerService.class);
        this.activityService = WCMCoreUtils.getService(ActivityCommonService.class);
        this.tagPermissionList = cacheService.getCacheInstance(NewFolksonomyServiceImpl.class.getName());
        if (initParams != null && initParams.getValueParam("tagDistributionMode") != null) {
            String strTagDistributionMode = initParams.getValueParam("tagDistributionMode").getValue();
            if ("none".equals(strTagDistributionMode)) {
                this.dataDistributionType = dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE);
            } else if ("readable".equals(strTagDistributionMode)) {
                this.dataDistributionType = dataDistributionManager.getDataDistributionType(DataDistributionMode.READABLE);
            } else if ("optimized".equals(strTagDistributionMode)) {
                this.dataDistributionType = dataDistributionManager.getDataDistributionType(DataDistributionMode.OPTIMIZED);
            }
        } else {
            this.dataDistributionType = dataDistributionManager.getDataDistributionType(DataDistributionMode.READABLE);
        }
    }

    public void start() {
        block2: {
            try {
                this.init();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"===>>>>Exception when init FolksonomySerice", (Throwable)e);
            }
        }
    }

    public void stop() {
        this.tagPermissionList.clearCache();
    }

    @Override
    public void addPrivateTag(String[] tagsName, Node documentNode, String workspace, String userName) throws Exception {
        Node userFolksonomyNode = this.getUserFolksonomyFolder(userName);
        userFolksonomyNode.getSession().save();
        Node targetNode = this.getTargetNode(documentNode);
        boolean firstTagFlag = true;
        StringBuffer tagValue = new StringBuffer();
        for (String tag : tagsName) {
            try {
                Node tagNode = this.getTagNode(userFolksonomyNode, tag);
                this.addTag(tagNode, targetNode);
                userFolksonomyNode.getSession().save();
                if (firstTagFlag) {
                    firstTagFlag = false;
                    tagValue.append(tag);
                    continue;
                }
                tagValue.append(",").append(tag);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("can't add tag '" + tag + "' to node: " + targetNode.getPath() + " for user: " + userName));
            }
        }
        this.broadcastActivityTag(documentNode, tagValue.toString());
    }

    private void broadcastActivityTag(Node documentNode, String tagValue) {
        block4: {
            if (this.listenerService != null && this.activityService != null) {
                try {
                    if (this.activityService.isAcceptedNode(documentNode) || documentNode.getPrimaryNodeType().getName().equals("nt:file")) {
                        this.listenerService.broadcast(ActivityCommonService.TAG_ADDED_ACTIVITY, (Object)documentNode, (Object)tagValue);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)("Can not notify Tag Added Activity because of: " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public void addGroupsTag(String[] tagsName, Node documentNode, String workspace, String[] roles) throws Exception {
        Node targetNode = this.getTargetNode(documentNode);
        for (String group : roles) {
            Node groupFolksonomyNode = this.getGroupFolksonomyFolder(group, workspace);
            for (String tag : tagsName) {
                try {
                    Node tagNode = this.getTagNode(groupFolksonomyNode, tag);
                    this.addTag(tagNode, targetNode);
                    groupFolksonomyNode.getSession().save();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("can't add tag '" + tag + "' to node: " + targetNode.getPath() + " for group: " + group));
                }
            }
        }
    }

    @Override
    public void addPublicTag(String treePath, String[] tagsName, Node documentNode, String workspace) throws Exception {
        Node publicFolksonomyTreeNode = this.getNode(workspace, treePath);
        Node targetNode = this.getTargetNode(documentNode);
        boolean firstTagFlag = true;
        StringBuffer tagValue = new StringBuffer();
        for (String tag : tagsName) {
            try {
                Node tagNode = this.getTagNode(publicFolksonomyTreeNode, tag);
                this.addTag(tagNode, targetNode);
                publicFolksonomyTreeNode.getSession().save();
                if (firstTagFlag) {
                    firstTagFlag = false;
                    tagValue.append(tag);
                    continue;
                }
                tagValue.append(",").append(tag);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("can't add tag '" + tag + "' to node: " + targetNode.getPath() + " in public folksonomy tree!"));
            }
        }
        this.broadcastActivityTag(documentNode, tagValue.toString());
    }

    private Node getTargetNode(Node showingNode) throws Exception {
        Node targetNode = null;
        if (this.linkManager.isLink((Item)showingNode)) {
            try {
                targetNode = this.linkManager.getTarget(showingNode);
            }
            catch (ItemNotFoundException e) {
                targetNode = showingNode;
            }
        } else {
            targetNode = showingNode;
        }
        return targetNode;
    }

    @Override
    public void addSiteTag(String siteName, String[] tagsName, Node node, String workspace) throws Exception {
        if (this.sitesTagPath.get(this.getRepoName()) == null) {
            this.createSiteTagPath();
        }
        this.addPublicTag(this.sitesTagPath.get(this.getRepoName()) + "/" + siteName, tagsName, node, workspace);
    }

    @Override
    public List<Node> getAllDocumentsByTag(String tagPath, String workspace, SessionProvider sessionProvider) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        Node tagNode = this.getNode(workspace, tagPath, sessionProvider);
        NodeIterator nodeIter = tagNode.getNodes();
        while (nodeIter.hasNext()) {
            Node targetNode;
            block3: {
                Node node = nodeIter.nextNode();
                if (!this.linkManager.isLink((Item)node)) continue;
                targetNode = null;
                try {
                    targetNode = this.linkManager.getTarget(node);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)e.getMessage());
                }
            }
            if (targetNode == null || ((Node)targetNode.getAncestor(1)).isNodeType(EXO_TRASH_FOLDER)) continue;
            ret.add(targetNode);
        }
        return ret;
    }

    @Override
    public List<Node> getAllGroupTags(String[] roles, String workspace) throws Exception {
        TreeSet<Node> tagSet = new TreeSet<Node>(new NodeComparator());
        for (String group : roles) {
            Node groupFolksonomyNode = this.getGroupFolksonomyFolder(group, workspace);
            List<Node> tagNodes = this.queryTagNodes(groupFolksonomyNode);
            for (Node tag : tagNodes) {
                if (((Node)tag.getAncestor(1)).isNodeType(EXO_TRASH_FOLDER)) continue;
                tagSet.add(tag);
            }
        }
        return new ArrayList<Node>(tagSet);
    }

    private List<Node> queryTagNodes(Node rootNode) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        StringBuilder queryStr = new StringBuilder().append("select * from ").append("exo:tagged").append(" where jcr:path like '").append(rootNode.getPath()).append("/%'");
        Query query = rootNode.getSession().getWorkspace().getQueryManager().createQuery(queryStr.toString(), "sql");
        NodeIterator iter = query.execute().getNodes();
        while (iter.hasNext()) {
            ret.add(iter.nextNode());
        }
        Collections.sort(ret, new NodeComparator());
        return ret;
    }

    @Override
    public List<Node> getAllGroupTags(String role, String workspace) throws Exception {
        ArrayList<Node> tagSet = new ArrayList<Node>();
        Node groupFolksonomyNode = this.getGroupFolksonomyFolder(role, workspace);
        for (Node tagNode : this.queryTagNodes(groupFolksonomyNode)) {
            tagSet.add(tagNode);
        }
        return tagSet;
    }

    @Override
    public List<Node> getAllPrivateTags(String userName) throws Exception {
        Node userFolksonomyNode = this.getUserFolksonomyFolder(userName);
        return this.queryTagNodes(userFolksonomyNode);
    }

    @Override
    public List<Node> getAllPublicTags(String treePath, String workspace) throws Exception {
        Node publicFolksonomyTreeNode = this.getNode(workspace, treePath);
        return this.queryTagNodes(publicFolksonomyTreeNode);
    }

    @Override
    public List<Node> getAllSiteTags(String siteName, String workspace) throws Exception {
        if (this.sitesTagPath.get(this.getRepoName()) == null) {
            this.createSiteTagPath();
        }
        return this.getAllPublicTags(this.sitesTagPath.get(this.getRepoName()) + "/" + siteName, workspace);
    }

    private String getRepoName() {
        try {
            String repositoryName = WCMCoreUtils.getRepository().getConfiguration().getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The repository name is: " + repositoryName));
            }
            return repositoryName;
        }
        catch (NullPointerException e) {
            String repositoryName = System.getProperty("gatein.tenant.repository.name");
            if (repositoryName != null) {
                return repositoryName;
            }
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Repository exception occurs:", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public List<Node> getAllTagStyle(String workspace) throws Exception {
        String tagStylesPath = this.nodeHierarchyCreator.getJcrPath(TAG_STYLE_ALIAS);
        Node tagStylesNode = this.getNode(workspace, tagStylesPath);
        return this.getChildNodes(tagStylesNode);
    }

    @Override
    public String getTagStyle(String tagStylePath, String workspace) throws Exception {
        Node tagStyleNode = this.getNode(workspace, tagStylePath);
        return tagStyleNode.getProperty("exo:htmlStyle").getString();
    }

    public void addTagStylePlugin(ComponentPlugin plugin) {
        if (plugin instanceof TagStylePlugin) {
            this.plugin_.add((TagStylePlugin)plugin);
        }
    }

    @Override
    public void init() throws Exception {
        for (TagStylePlugin plugin : this.plugin_) {
            try {
                plugin.init();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"can not init tag style: ", (Throwable)e);
            }
        }
        this.initTagPermissionListCache();
    }

    @Override
    public void initTagPermissionListCache() throws Exception {
        ArrayList<String> _tagPermissionList = new ArrayList<String>();
        for (TagPermissionPlugin plugin : this.tagPermissionPlugin_) {
            try {
                _tagPermissionList.addAll(plugin.initPermission());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"can not init tag permission: ", (Throwable)e);
            }
        }
        this.tagPermissionList.clearCache();
        this.tagPermissionList.put((Serializable)((Object)TAG_PERMISSION_LIST), _tagPermissionList);
    }

    @Override
    @Deprecated
    public Node modifyTagName(String tagPath, String newTagName, String workspace) throws Exception {
        Node oldTagNode = this.getNode(workspace, tagPath);
        if (oldTagNode.getParent().hasNode(newTagName)) {
            throw new ItemExistsException("node " + newTagName + " has already existed!");
        }
        StringBuilder newPath = new StringBuilder(oldTagNode.getParent().getPath()).append('/').append(newTagName);
        ManageableRepository manageableRepository = WCMCoreUtils.getRepository();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        session.move(tagPath, newPath.toString());
        session.save();
        return this.getNode(workspace, newPath.toString());
    }

    @Override
    public Node modifyPublicTagName(String tagPath, String newTagName, String workspace, String treePath) throws Exception {
        Node oldTagNode = this.getNode(workspace, tagPath);
        Node publicFolksonomyTreeNode = this.getNode(workspace, treePath);
        Node newTagNode = null;
        try {
            newTagNode = this.dataDistributionType.getDataNode(publicFolksonomyTreeNode, newTagName);
            throw new ItemExistsException("node " + newTagName + " has already existed!");
        }
        catch (PathNotFoundException e) {
            newTagNode = this.dataDistributionType.getOrCreateDataNode(publicFolksonomyTreeNode, newTagName);
            newTagNode.addMixin("exo:tagged");
            if (oldTagNode.hasProperty("exo:total")) {
                newTagNode.setProperty("exo:total", oldTagNode.getProperty("exo:total").getValue());
            }
            HashMap<String, String> pathMap = new HashMap<String, String>();
            NodeIterator iter = oldTagNode.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                pathMap.put(node.getPath(), newTagNode.getPath() + "/" + node.getName());
            }
            Session session = newTagNode.getSession();
            for (Map.Entry entry : pathMap.entrySet()) {
                session.move((String)entry.getKey(), (String)entry.getValue());
            }
            oldTagNode.remove();
            session.save();
            return newTagNode;
        }
    }

    @Override
    public void removeTag(String tagPath, String workspace) throws Exception {
        Node tagNode = this.getNode(workspace, tagPath);
        NodeIterator nodeIterator = tagNode.getNodes();
        Exception e = null;
        while (nodeIterator.hasNext()) {
            try {
                Node document = this.linkManager.getTarget(nodeIterator.nextNode());
                this.removeTagOfDocument(tagPath, document, workspace);
            }
            catch (Exception exception) {
                if (e != null) {
                    e.addSuppressed(exception);
                    continue;
                }
                e = exception;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public void removeTagOfDocument(String tagPath, Node document, String workspace) throws Exception {
        block11: {
            Node tagNode = this.getNode(workspace, tagPath);
            NodeIterator nodeIter = tagNode.getNodes();
            StringBuffer removedTags = new StringBuffer();
            boolean isFirstFlag = true;
            while (nodeIter.hasNext()) {
                Node targetNode;
                Node link;
                block10: {
                    link = nodeIter.nextNode();
                    if (!this.linkManager.isLink((Item)link)) continue;
                    targetNode = null;
                    try {
                        targetNode = this.linkManager.getTarget(link);
                    }
                    catch (RepositoryException e) {
                        if (!LOG.isWarnEnabled()) break block10;
                        LOG.warn((Object)e.getMessage());
                    }
                }
                if (!document.isSame((Item)targetNode)) continue;
                String tagName = tagNode.getName();
                if (isFirstFlag) {
                    removedTags.append(tagName);
                    isFirstFlag = false;
                } else {
                    removedTags.append(ActivityCommonService.VALUE_SEPERATOR).append(tagName);
                }
                link.remove();
                long total = tagNode.getProperty("exo:total").getLong();
                tagNode.setProperty("exo:total", total - 1L);
                Node parentNode = tagNode.getParent();
                if (tagNode.getProperty("exo:total").getLong() == 0L) {
                    tagNode.remove();
                }
                parentNode.getSession().save();
                break;
            }
            if (this.listenerService != null && this.activityService != null) {
                try {
                    if (this.activityService.isAcceptedNode(document) || document.getPrimaryNodeType().getName().equals("nt:file") && this.activityService.isBroadcastNTFileEvents(document)) {
                        this.listenerService.broadcast(ActivityCommonService.TAG_REMOVED_ACTIVITY, (Object)document, (Object)removedTags.toString());
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block11;
                    LOG.error((Object)("Can not notify RemoveTag Activity because of: " + e.getMessage()));
                }
            }
        }
    }

    @Override
    public void updateTagStyle(String styleName, String tagRange, String htmlStyle, String workspace) throws Exception {
        String tagStylesPath = this.nodeHierarchyCreator.getJcrPath(TAG_STYLE_ALIAS);
        Node tagStylesNode = this.getNode(workspace, tagStylesPath);
        Node styleNode = tagStylesNode.getNode(styleName);
        styleNode.setProperty("exo:styleRange", tagRange);
        styleNode.setProperty("exo:htmlStyle", htmlStyle);
        tagStylesNode.getSession().save();
    }

    @Override
    public void addTagStyle(String styleName, String tagRange, String htmlStyle, String workspace) throws Exception {
        String tagStylesPath = this.nodeHierarchyCreator.getJcrPath(TAG_STYLE_ALIAS);
        Node tagStylesNode = this.getNode(workspace, tagStylesPath);
        Node styleNode = tagStylesNode.addNode(styleName, "exo:tagStyle");
        styleNode.addMixin("exo:privilegeable");
        styleNode.setProperty("exo:styleRange", tagRange);
        styleNode.setProperty("exo:htmlStyle", htmlStyle);
        tagStylesNode.getSession().save();
    }

    @Override
    public void removeTagsOfNodeRecursively(Node node, String workspace, String username, String groups) throws Exception {
        int[] scopes = new int[]{1, 0, 3, 2};
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "");
        map.put(1, username);
        map.put(3, groups);
        map.put(2, "");
        for (int scope : scopes) {
            for (Node child : this.getAllNodes(node)) {
                List<Node> tags = this.getLinkedTagsOfDocumentByScope(scope, (String)map.get(scope), child, workspace);
                for (Node tag : tags) {
                    this.removeTagOfDocument(tag.getPath(), child, workspace);
                }
            }
        }
    }

    private List<Node> getAllNodes(Node node) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        this.getAllNodes(node, ret);
        return ret;
    }

    private void getAllNodes(Node node, List<Node> list) throws Exception {
        list.add(node);
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            this.getAllNodes(iter.nextNode(), list);
        }
    }

    private List<Node> getChildNodes(Node node) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        NodeIterator nodeIter = node.getNodes();
        while (nodeIter.hasNext()) {
            ret.add(nodeIter.nextNode());
        }
        Collections.sort(ret, new NodeComparator());
        return ret;
    }

    private Node getGroupFolksonomyFolder(String group, String workspace) throws Exception {
        String groupsPath = this.nodeHierarchyCreator.getJcrPath(GROUPS_ALIAS);
        String folksonomyPath = "ApplicationData/Tags";
        Node groupsNode = this.getNode(workspace, groupsPath);
        return groupsNode.getNode(group.substring(1)).getNode(folksonomyPath);
    }

    private Node getUserFolksonomyFolder(String userName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, userName);
        String folksonomyPath = this.nodeHierarchyCreator.getJcrPath(USER_FOLKSONOMY_ALIAS);
        return userNode.getNode(folksonomyPath);
    }

    private Node getNode(String workspace, String path) throws Exception {
        ManageableRepository manageableRepository = WCMCoreUtils.getRepository();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        return (Node)sessionProvider.getSession(workspace, manageableRepository).getItem(path);
    }

    private Node getNode(String workspace, String path, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = WCMCoreUtils.getRepository();
        return (Node)sessionProvider.getSession(workspace, manageableRepository).getItem(path);
    }

    private boolean existSymlink(Node parentNode, Node targetNode) throws Exception {
        NodeIterator nodeIter = parentNode.getNodes();
        while (nodeIter.hasNext()) {
            Node pointTo;
            block5: {
                Node link = nodeIter.nextNode();
                pointTo = null;
                try {
                    if (this.linkManager.isLink((Item)link)) {
                        pointTo = this.linkManager.getTarget(link, true);
                    }
                }
                catch (ItemNotFoundException e) {
                    continue;
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)e.getMessage());
                }
            }
            if (targetNode == null || !targetNode.isSame(pointTo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Node> getLinkedTagsOfDocument(Node documentNode, String workspace) throws Exception {
        HashSet<Node> ret = new HashSet<Node>();
        StringBuilder queryStr = new StringBuilder("SELECT * FROM ").append("exo:tagged");
        ManageableRepository manageableRepository = WCMCoreUtils.getRepository();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        QueryManager queryManager = sessionProvider.getSession(workspace, manageableRepository).getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryStr.toString(), "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIter = queryResult.getNodes();
        while (nodeIter.hasNext()) {
            Node tagNode = nodeIter.nextNode();
            if (!this.existSymlink(tagNode, documentNode)) continue;
            ret.add(tagNode);
        }
        return new ArrayList<Node>(ret);
    }

    @Override
    public List<Node> getLinkedTagsOfDocumentByScope(int scope, String value, Node documentNode, String workspace) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        if (scope == 1) {
            Node userFolksonomyNode = this.getUserFolksonomyFolder(value);
            for (Node tagNode : this.queryTagNodes(userFolksonomyNode)) {
                if (!this.existSymlink(tagNode, documentNode)) continue;
                ret.add(tagNode);
            }
        } else if (scope == 0) {
            String publicTagNodePath = this.nodeHierarchyCreator.getJcrPath(PUBLIC_TAG_NODE_PATH);
            Node publicFolksonomyTreeNode = this.getNode(workspace, publicTagNodePath);
            for (Node tagNode : this.queryTagNodes(publicFolksonomyTreeNode)) {
                if (!this.existSymlink(tagNode, documentNode)) continue;
                ret.add(tagNode);
            }
        } else if (scope == 3) {
            String[] roles;
            for (String group : roles = value.split(";")) {
                if (group.length() < 1) continue;
                Node groupFolksonomyNode = this.getGroupFolksonomyFolder(group, workspace);
                for (Node tagNode : this.queryTagNodes(groupFolksonomyNode)) {
                    if (!this.existSymlink(tagNode, documentNode)) continue;
                    ret.add(tagNode);
                }
            }
        }
        Collections.sort(ret, new NodeComparator());
        return ret;
    }

    public void addTagPermissionPlugin(ComponentPlugin plugin) {
        if (plugin instanceof TagPermissionPlugin) {
            this.tagPermissionPlugin_.add((TagPermissionPlugin)plugin);
        }
    }

    @Override
    public void addTagPermission(String usersOrGroups) {
        ArrayList<String> _tagPermissionList = (ArrayList<String>)this.tagPermissionList.get((Serializable)((Object)TAG_PERMISSION_LIST));
        if (_tagPermissionList != null && !_tagPermissionList.contains(usersOrGroups)) {
            _tagPermissionList.add(usersOrGroups);
            this.tagPermissionList.put((Serializable)((Object)TAG_PERMISSION_LIST), _tagPermissionList);
        } else if (_tagPermissionList == null) {
            _tagPermissionList = new ArrayList<String>();
            _tagPermissionList.add(usersOrGroups);
            this.tagPermissionList.put((Serializable)((Object)TAG_PERMISSION_LIST), _tagPermissionList);
        }
    }

    @Override
    public void removeTagPermission(String usersOrGroups) {
        List _tagPermissionList = (List)this.tagPermissionList.get((Serializable)((Object)TAG_PERMISSION_LIST));
        if (_tagPermissionList != null && _tagPermissionList.contains(usersOrGroups)) {
            _tagPermissionList.remove(usersOrGroups);
            this.tagPermissionList.put((Serializable)((Object)TAG_PERMISSION_LIST), (Object)_tagPermissionList);
        }
    }

    @Override
    public List<String> getTagPermissionList() {
        return (List)this.tagPermissionList.get((Serializable)((Object)TAG_PERMISSION_LIST));
    }

    @Override
    public boolean canEditTag(int scope, List<String> memberships) {
        if (scope == 0) {
            List _tagPermissionList = (List)this.tagPermissionList.get((Serializable)((Object)TAG_PERMISSION_LIST));
            if (_tagPermissionList == null || _tagPermissionList.size() == 0) {
                return false;
            }
            for (String membership : memberships) {
                if (_tagPermissionList.contains(membership)) {
                    return true;
                }
                if (!membership.contains(":") || !_tagPermissionList.contains("*" + membership.substring(membership.indexOf(":")))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public List<String> getAllTagNames(String workspace, int scope, String value) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        List<Object> tags = new ArrayList();
        switch (scope) {
            case 0: {
                tags = this.getAllPublicTags(value, workspace);
                break;
            }
            case 1: {
                tags = this.getAllPrivateTags(value);
                break;
            }
            case 3: {
                tags = value.indexOf(";") >= 0 ? this.getAllGroupTags(value.split(";"), workspace) : this.getAllGroupTags(value, workspace);
                break;
            }
            case 2: {
                tags = this.getAllSiteTags(value, workspace);
            }
        }
        for (Node tag : tags) {
            ret.add(tag.getName());
        }
        Collections.sort(ret);
        return ret;
    }

    private void createSiteTagPath() throws Exception {
        if (this.sitesTagPath.get(this.getRepoName()) == null) {
            Node rootNode;
            ManageableRepository manageableRepository = WCMCoreUtils.getRepository();
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Session session = sessionProvider.getSession(this.initParams_.getValueParam("workspace").getValue(), manageableRepository);
            String[] paths = this.initParams_.getValueParam("path").getValue().split("/");
            Node currentNode = rootNode = session.getRootNode();
            int depth = 0;
            for (String path : paths) {
                Node cnode;
                if (path.length() <= 0) continue;
                currentNode = cnode = currentNode.hasNode(path) ? currentNode.getNode(path) : currentNode.addNode(path);
                if (depth++ != 0 || currentNode.isNodeType(EXO_HIDDENABLE)) continue;
                currentNode.addMixin(EXO_HIDDENABLE);
            }
            session.save();
            this.sitesTagPath.put(this.getRepoName(), currentNode.getPath());
        }
    }

    private Node getTagNode(Node folksonomyHome, String tagName) throws Exception {
        Node tagNode = this.dataDistributionType.getOrCreateDataNode(folksonomyHome, tagName);
        if (!tagNode.isNodeType("exo:tagged")) {
            tagNode.addMixin("exo:tagged");
            tagNode.setProperty("exo:total", 0L);
        }
        return tagNode;
    }

    private void addTag(Node tagNode, Node targetNode) throws Exception {
        if (!this.existSymlink(tagNode, targetNode)) {
            this.linkManager.createLink(tagNode, targetNode);
            long total = tagNode.getProperty("exo:total").getLong();
            tagNode.setProperty("exo:total", total + 1L);
        }
    }

    @Override
    public DataDistributionType getDataDistributionType() {
        return this.dataDistributionType;
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            try {
                if (o1.isSame((Item)o2)) {
                    return 0;
                }
                int pathComparison = o1.getPath().compareTo(o2.getPath());
                return pathComparison == 0 ? 1 : pathComparison;
            }
            catch (RepositoryException e) {
                return 1;
            }
        }
    }
}

