/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.web.redirect;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.mop.SiteKey;
import org.gatein.portal.encoder.EncoderService;
import org.gatein.web.redirect.api.RedirectKey;
import org.gatein.web.redirect.api.RedirectType;

public class RedirectCookieService {
    protected static final String DEFAULT_PREFIX = "gtn.site";
    protected static final String NAME_PREFERENCE_FLAG = ".preference";
    protected static final int DEFAULT_MAXAGE = 2600000;
    protected Integer maxAge;
    protected String comment;
    protected String path;
    protected Boolean secure;
    protected String cookiePrefix;
    private EncoderService encoderService;

    public RedirectCookieService(InitParams params) {
        ValueParam cookiePrefixValueParam;
        ValueParam cookieSecureValueParam;
        ValueParam cookiePathValueParam;
        ValueParam cookieMaxAgeValueParam = params.getValueParam("redirect.cookie.maxage");
        this.maxAge = cookieMaxAgeValueParam != null ? Integer.valueOf(Integer.parseInt(cookieMaxAgeValueParam.getValue())) : Integer.valueOf(2600000);
        ValueParam cookieCommentValueParam = params.getValueParam("redirect.cookie.comment");
        if (cookieCommentValueParam != null) {
            this.comment = cookieCommentValueParam.getValue();
        }
        if ((cookiePathValueParam = params.getValueParam("redirect.cookie.path")) != null) {
            this.path = cookiePathValueParam.getValue();
        }
        if ((cookieSecureValueParam = params.getValueParam("redirect.cookie.secure")) != null) {
            this.secure = Boolean.parseBoolean(cookieSecureValueParam.getValue());
        }
        this.cookiePrefix = (cookiePrefixValueParam = params.getValueParam("redirect.cookie.prefix")) != null ? cookiePrefixValueParam.getValue() : DEFAULT_PREFIX;
        PortalContainer portalContainer = PortalContainer.getInstance();
        this.encoderService = (EncoderService)portalContainer.getComponentInstanceOfType(EncoderService.class);
    }

    public Cookie createCookie(String originSite, RedirectKey redirect, String cookiePath) {
        if (originSite != null && redirect != null) {
            String originName = this.cookiePrefix + NAME_PREFERENCE_FLAG;
            String redirectValue = redirect.getType() == RedirectType.REDIRECT ? redirect.getRedirect() : originSite;
            String encodedValue = null;
            try {
                encodedValue = this.encoderService.encode64(redirectValue);
            }
            catch (Exception e) {
                // empty catch block
            }
            Cookie cookie = new Cookie(originName, encodedValue == null ? redirectValue : encodedValue);
            if (this.comment != null) {
                cookie.setComment(this.comment);
            }
            if (this.path != null) {
                cookie.setPath(this.path);
            } else {
                cookie.setPath(cookiePath);
            }
            if (this.secure != null) {
                cookie.setSecure(this.secure.booleanValue());
            }
            cookie.setMaxAge(this.maxAge.intValue());
            return cookie;
        }
        throw new IllegalArgumentException("RedirectCookie requires that both the origin site [" + originSite + "] and the redirect site [" + redirect + "] be not null.");
    }

    public RedirectKey getRedirect(SiteKey origin, HttpServletRequest request) {
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                String cookieValue;
                if (!cookie.getName().equals(this.cookiePrefix + NAME_PREFERENCE_FLAG)) continue;
                String decodedValue = null;
                try {
                    decodedValue = this.encoderService.decode64(cookie.getValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                String string = cookieValue = decodedValue == null ? cookie.getValue() : decodedValue;
                if (cookieValue.equals(origin.getName())) {
                    return RedirectKey.noRedirect();
                }
                if (cookieValue == null || cookieValue.isEmpty()) break;
                return RedirectKey.redirect(cookieValue);
            }
        }
        return null;
    }
}

