/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.ArrayList;
import java.util.Arrays;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.LockManager;

public abstract class AbstractLockingInterceptor
extends CommandInterceptor {
    LockManager lockManager;
    DataContainer dataContainer;
    EntryFactory entryFactory;
    ClusteringDependentLogic cdl;

    @Inject
    public void setDependencies(LockManager lockManager, DataContainer dataContainer, EntryFactory entryFactory, ClusteringDependentLogic cll) {
        this.lockManager = lockManager;
        this.dataContainer = dataContainer;
        this.entryFactory = entryFactory;
        this.cdl = cll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
            for (Object key : command.getKeys()) {
                this.lockKey(ctx, key, lockTimeout, skipLocking);
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    @Override
    public final Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        if (command.isCausedByALocalWrite(this.cdl.getAddress())) {
            this.getLog().trace("Skipping invalidation as the write operation originated here.");
            return null;
        }
        Object[] keys = command.getKeys();
        try {
            ArrayList<Object> keysCopy;
            if (keys != null && keys.length >= 1) {
                keysCopy = new ArrayList<Object>(Arrays.asList(keys));
                for (Object key : command.getKeys()) {
                    boolean skipLocking = this.hasSkipLocking(command);
                    try {
                        this.lockKey(ctx, key, 0L, skipLocking);
                    }
                    catch (TimeoutException te) {
                        this.getLog().unableToLockToInvalidate(key, this.cdl.getAddress());
                        keysCopy.remove(key);
                        if (!keysCopy.isEmpty()) continue;
                        Object var11_12 = null;
                        command.setKeys(keys);
                        if (!ctx.isInTxScope()) {
                            this.lockManager.unlockAll(ctx);
                        }
                        return var11_12;
                    }
                }
                command.setKeys(keysCopy.toArray());
            }
            keysCopy = this.invokeNextInterceptor(ctx, command);
            return keysCopy;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            command.setKeys(keys);
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    protected final Throwable cleanLocksAndRethrow(InvocationContext ctx, Throwable te) {
        this.lockManager.unlockAll(ctx);
        return te;
    }

    protected final void lockKey(InvocationContext ctx, Object key, long timeoutMillis, boolean skipLocking) throws InterruptedException {
        this.lockManager.acquireLockNoCheck(ctx, key, timeoutMillis, skipLocking);
    }
}

