/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.internal.macro.chart.ChartImageWriter;
import org.xwiki.rendering.internal.macro.chart.ImageId;
import org.xwiki.rendering.macro.MacroExecutionException;

@Component
@Named(value="tmp")
@Singleton
public class TemporaryChartImageWriter
implements ChartImageWriter {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String MODULE_NAME = "chart";
    private static final String SPACE = "space";
    private static final String PAGE = "page";
    @Inject
    private Environment environment;
    @Inject
    private ModelContext modelContext;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    @Override
    public void writeImage(ImageId imageId, byte[] imageData) throws MacroExecutionException {
        File imageFile = this.getStorageLocation(imageId);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(imageFile);
            fos.write(imageData);
            fos.close();
        }
        catch (IOException e) {
            try {
                throw new MacroExecutionException("Failed to write the generated chart image", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    protected File getStorageLocation(ImageId imageId) throws MacroExecutionException {
        File directory;
        try {
            String currentWiki = URLEncoder.encode(this.getCurrentWiki(), DEFAULT_ENCODING);
            directory = new File(this.environment.getTemporaryDirectory(), String.format("temp/%s/%s/%s/%s", MODULE_NAME, currentWiki, SPACE, PAGE));
            directory.mkdirs();
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to compute chart image location", (Throwable)e);
        }
        File locationFile = new File(directory, String.format("%s.png", imageId.getId()));
        return locationFile;
    }

    private String getCurrentWiki() throws MacroExecutionException {
        EntityReference reference = this.modelContext.getCurrentEntityReference();
        if (reference == null) {
            throw new MacroExecutionException("The current wiki couldn't be computed");
        }
        return reference.extractReference(EntityType.WIKI).getName();
    }

    @Override
    public String getURL(ImageId imageId) throws MacroExecutionException {
        DocumentReference reference = new DocumentReference(this.getCurrentWiki(), SPACE, PAGE);
        String prefix = this.documentAccessBridge.getDocumentURL(reference, "temp", null, null);
        return String.format("%s/%s/%s.png", prefix, MODULE_NAME, imageId.getId());
    }
}

