/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionData;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionLog;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationHistory;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIVersionViewer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/publication/lifecycle/stageversion/ui/UIPublicationPanel.gtmpl", events={@EventConfig(listeners={DraftActionListener.class}), @EventConfig(listeners={LiveActionListener.class}), @EventConfig(name="obsolete", listeners={ObsoleteActionListener.class}), @EventConfig(listeners={ChangeVersionActionListener.class}), @EventConfig(listeners={PreviewVersionActionListener.class}), @EventConfig(listeners={RestoreVersionActionListener.class}), @EventConfig(listeners={SeeAllVersionActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIPublicationPanel
extends UIForm {
    private NodeLocation currentNodeLocation;
    private NodeLocation currentRevisionLocation;
    private Map<String, VersionData> revisionsDataMap = new HashMap<String, VersionData>();
    private List<NodeLocation> viewedRevisions = new ArrayList<NodeLocation>(3);
    private WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
    private String sitename = Util.getPortalRequestContext().getPortalOwner();
    private String remoteuser = Util.getPortalRequestContext().getRemoteUser();

    public void init(Node node) throws Exception {
        this.currentNodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        this.currentRevisionLocation = NodeLocation.getNodeLocationByNode((Node)node);
        this.viewedRevisions = NodeLocation.getLocationsByNodeList(this.getLatestRevisions(3, node));
        this.revisionsDataMap = this.getRevisionData(node);
        this.cleanPublicationData(node);
    }

    private void cleanPublicationData(Node node) throws Exception {
        if (this.viewedRevisions.size() == 1 && this.revisionsDataMap.size() > 1) {
            node.setProperty("publication:revisionData", new Value[0]);
            node.setProperty("publication:history", new Value[0]);
            node.setProperty("publication:liveRevision", (Value)null);
            node.save();
            this.revisionsDataMap = this.getRevisionData(node);
        }
    }

    public List<Node> getAllRevisions(Node node) throws Exception {
        ArrayList<Node> allversions = new ArrayList<Node>();
        VersionIterator iterator = node.getVersionHistory().getAllVersions();
        while (iterator.hasNext()) {
            Version version = iterator.nextVersion();
            if (version.getName().equals("jcr:rootVersion")) continue;
            allversions.add((Node)version);
        }
        Collections.sort(allversions, new NodeNameComparator());
        allversions.add(node);
        Collections.reverse(allversions);
        return allversions;
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNodeLocation);
    }

    public Node getCurrentRevision() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentRevisionLocation);
    }

    public String getRevisionAuthor(Node revision) throws Exception {
        VersionData revisionData = this.revisionsDataMap.get(revision.getUUID());
        Node currentNode = this.getCurrentNode();
        if (revisionData != null) {
            return revisionData.getAuthor();
        }
        if (revision.getUUID().equalsIgnoreCase(currentNode.getUUID())) {
            return currentNode.getProperty("exo:owner").getString();
        }
        return null;
    }

    public Node getRevisionByUUID(String revisionUUID) throws Exception {
        Session session = this.getCurrentNode().getSession();
        return session.getNodeByUUID(revisionUUID);
    }

    public String getRevisionCreatedDate(Node revision) throws Exception {
        UIPublicationContainer container = (UIPublicationContainer)this.getAncestorOfType(UIPublicationContainer.class);
        DateFormat dateFormater = container.getDateTimeFormater();
        Calendar calendar = null;
        calendar = revision instanceof Version ? ((Version)revision).getCreated() : (revision.hasProperty("exo:dateCreated") ? revision.getProperty("exo:dateCreated").getDate() : revision.getProperty("jcr:created").getDate());
        return dateFormater.format(calendar.getTime());
    }

    public List<Node> getRevisions() {
        return NodeLocation.getNodeListByLocationList(this.viewedRevisions);
    }

    public String getRevisionState(Node revision) throws Exception {
        VersionData revisionData = this.revisionsDataMap.get(revision.getUUID());
        Node currentNode = this.getCurrentNode();
        if (revisionData != null) {
            return revisionData.getState();
        }
        if (revision.getUUID().equalsIgnoreCase(currentNode.getUUID())) {
            return currentNode.getProperty("publication:currentState").getString();
        }
        return null;
    }

    public void setCurrentRevision(Node revision) {
        this.currentRevisionLocation = NodeLocation.getNodeLocationByNode((Node)revision);
    }

    public void setRevisions(List<Node> revisions) {
        this.viewedRevisions = NodeLocation.getLocationsByNodeList(revisions);
    }

    public void updatePanel() throws Exception {
        UIPublicationContainer publicationContainer = (UIPublicationContainer)this.getAncestorOfType(UIPublicationContainer.class);
        UIPublicationHistory publicationHistory = (UIPublicationHistory)publicationContainer.getChild(UIPublicationHistory.class);
        publicationHistory.updateGrid();
        Node currentNode = this.getCurrentNode();
        this.revisionsDataMap = this.getRevisionData(currentNode);
        this.viewedRevisions = NodeLocation.getLocationsByNodeList(this.getLatestRevisions(3, currentNode));
    }

    private List<Node> getLatestRevisions(int limit, Node node) throws Exception {
        List<Node> allversions = this.getAllRevisions(node);
        List<Object> latestVersions = new ArrayList();
        latestVersions = allversions.size() > limit ? allversions.subList(0, limit) : allversions;
        return latestVersions;
    }

    private Map<String, VersionData> getRevisionData(Node node) throws Exception {
        HashMap<String, VersionData> map = new HashMap<String, VersionData>();
        try {
            for (Value v : node.getProperty("publication:revisionData").getValues()) {
                VersionData versionData = VersionData.toVersionData(v.getString());
                map.put(versionData.getUUID(), versionData);
            }
        }
        catch (Exception e) {
            return map;
        }
        return map;
    }

    private class NodeNameComparator
    implements Comparator<Node> {
        private NodeNameComparator() {
        }

        @Override
        public int compare(Node node0, Node node1) {
            try {
                String name0 = node0.getName();
                String name1 = node1.getName();
                try {
                    int name0Int = Integer.parseInt(name0);
                    int name1Int = Integer.parseInt(name1);
                    return name0Int - name1Int;
                }
                catch (NumberFormatException e) {
                    return name0.compareTo(name1);
                }
            }
            catch (RepositoryException e) {
                return 0;
            }
        }
    }

    public static class SeeAllVersionActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            publicationPanel.setRevisions(publicationPanel.getAllRevisions(publicationPanel.getCurrentNode()));
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    public static class RestoreVersionActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            Node currentNode = publicationPanel.getCurrentNode();
            String versionUUID = event.getRequestContext().getRequestParameter("objectId");
            Version version = (Version)publicationPanel.getRevisionByUUID(versionUUID);
            String userId = "";
            try {
                userId = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (Exception ex) {
                userId = currentNode.getSession().getUserID();
            }
            try {
                currentNode.restore(version, true);
                ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
                ActivityCommonService activityService = (ActivityCommonService)WCMCoreUtils.getService(ActivityCommonService.class);
                if (activityService.isAcceptedNode(currentNode)) {
                    listenerService.broadcast(ActivityCommonService.NODE_REVISION_CHANGED, (Object)currentNode, (Object)version.getName());
                }
                if (!currentNode.isCheckedOut()) {
                    currentNode.checkout();
                }
                Value[] values = currentNode.getProperty("publication:revisionData").getValues();
                String currentState = "";
                for (Value value : values) {
                    String revisionData = value.getString();
                    if (revisionData.indexOf("published") > 0) {
                        currentState = "published";
                        break;
                    }
                    currentState = "obsolete";
                }
                currentNode.setProperty("publication:currentState", "draft");
                Map revisionsDataMap = publicationPanel.getRevisionData(currentNode);
                ((VersionData)revisionsDataMap.get(currentNode.getUUID())).setState("draft");
                ArrayList<Value> valueList = new ArrayList<Value>();
                ValueFactory factory = currentNode.getSession().getValueFactory();
                for (VersionData versionData : revisionsDataMap.values()) {
                    valueList.add(factory.createValue(versionData.toStringValue()));
                }
                currentNode.setProperty("publication:revisionData", valueList.toArray(new Value[0]));
                VersionLog versionLog = new VersionLog(currentNode.getName(), currentNode.getProperty("publication:currentState").getString(), userId, GregorianCalendar.getInstance(), "PublicationService.StageAndVersionPublicationPlugin.restoreVersion from " + version.getName());
                values = currentNode.getProperty("publication:history").getValues();
                ValueFactory valueFactory = currentNode.getSession().getValueFactory();
                ArrayList<Value> list = new ArrayList<Value>(Arrays.asList(values));
                list.add(valueFactory.createValue(versionLog.toString()));
                currentNode.setProperty("publication:history", list.toArray(new Value[0]));
                currentNode.getSession().save();
                publicationPanel.setCurrentRevision(currentNode);
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            }
            UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIPublicationPanel.msg.restore-complete", null));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp);
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    public static class PreviewVersionActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            Node revision;
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            UIVersionViewer versionViewer = (UIVersionViewer)publicationContainer.createUIComponent(UIVersionViewer.class, null, "UIVersionViewer");
            String versionUUID = event.getRequestContext().getRequestParameter("objectId");
            Node frozenNode = revision = publicationPanel.getRevisionByUUID(versionUUID);
            if (revision instanceof Version) {
                frozenNode = revision.getNode("jcr:frozenNode");
            }
            versionViewer.setOriginalNode(publicationPanel.getCurrentNode());
            versionViewer.setNode(frozenNode);
            if (versionViewer.getTemplate() == null || versionViewer.getTemplate().trim().length() == 0) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPublicationPanel.msg.have-no-view-template", null));
                return;
            }
            if (publicationContainer.getChildById("UIVersionViewer") == null) {
                publicationContainer.addChild((UIComponent)versionViewer);
            } else {
                publicationContainer.replaceChild("UIVersionViewer", (UIComponent)versionViewer);
            }
            publicationContainer.setActiveTab((UIComponent)versionViewer, event.getRequestContext());
        }
    }

    public static class ObsoleteActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            Node currentNode = publicationPanel.getCurrentNode();
            publicationPanel.wcmPublicationService.updateLifecyleOnChangeContent(currentNode, publicationPanel.sitename, publicationPanel.remoteuser, "obsolete");
            try {
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            }
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    public static class LiveActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            Node currentNode = publicationPanel.getCurrentNode();
            publicationPanel.wcmPublicationService.updateLifecyleOnChangeContent(currentNode, publicationPanel.sitename, publicationPanel.remoteuser, "published");
            try {
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            }
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    public static class DraftActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            Node currentNode = publicationPanel.getCurrentNode();
            publicationPanel.wcmPublicationService.updateLifecyleOnChangeContent(currentNode, publicationPanel.sitename, publicationPanel.remoteuser, "draft");
            try {
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            }
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    public static class CloseActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            UIPopupContainer uiPopupContainer = (UIPopupContainer)publicationPanel.getAncestorOfType(UIPopupContainer.class);
            uiPopupContainer.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }

    public static class ChangeVersionActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            String versionUUID = event.getRequestContext().getRequestParameter("objectId");
            Node revision = publicationPanel.getRevisionByUUID(versionUUID);
            publicationPanel.setCurrentRevision(revision);
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }
}

