/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.client;

import java.io.IOException;
import java.net.ConnectException;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.HandshakeResponse;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.cometd.bayeux.Message;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.TransportListener;
import org.cometd.websocket.client.AbstractWebSocketTransport;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class WebSocketTransport
extends AbstractWebSocketTransport {
    private final WebSocketContainer _webSocketContainer;
    private boolean _webSocketSupported;
    private boolean _webSocketConnected;

    public WebSocketTransport(Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketContainer webSocketContainer) {
        this(null, options, scheduler, webSocketContainer);
    }

    public WebSocketTransport(String url, Map<String, Object> options, ScheduledExecutorService scheduler, WebSocketContainer webSocketContainer) {
        super(url, options, scheduler);
        this._webSocketContainer = webSocketContainer;
        this._webSocketSupported = true;
    }

    public boolean accept(String version) {
        return this._webSocketSupported;
    }

    public void init() {
        super.init();
        this._webSocketContainer.setDefaultMaxSessionIdleTimeout(this.getIdleTimeout());
        int maxMessageSize = this.getOption("maxMessageSize", this._webSocketContainer.getDefaultMaxTextMessageBufferSize());
        this._webSocketContainer.setDefaultMaxTextMessageBufferSize(maxMessageSize);
        this._webSocketSupported = true;
        this._webSocketConnected = false;
    }

    protected AbstractWebSocketTransport.Delegate connect(String uri, TransportListener listener, List<Message.Mutable> messages) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Opening websocket session to {}", (Object)uri);
            }
            this._webSocketContainer.setDefaultMaxSessionIdleTimeout(this.getIdleTimeout());
            Configurator configurator = new Configurator();
            String protocol = this.getProtocol();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().preferredSubprotocols(protocol == null ? null : Collections.singletonList(protocol)).configurator((ClientEndpointConfig.Configurator)configurator).build();
            AbstractWebSocketTransport.Delegate delegate = this.connect(this._webSocketContainer, config, uri);
            this._webSocketConnected = true;
            return delegate;
        }
        catch (ConnectException | SocketTimeoutException | UnresolvedAddressException x) {
            listener.onFailure((Throwable)x, messages);
        }
        catch (Throwable x) {
            this._webSocketSupported = this.isStickyReconnect() && this._webSocketConnected;
            listener.onFailure(x, messages);
        }
        return null;
    }

    protected AbstractWebSocketTransport.Delegate connect(WebSocketContainer container, ClientEndpointConfig configuration, String uri) throws IOException {
        try {
            WebSocketDelegate delegate = this.newDelegate();
            container.connectToServer(delegate._endpoint, configuration, new URI(uri));
            return delegate;
        }
        catch (URISyntaxException | DeploymentException x) {
            throw new IOException(x);
        }
    }

    protected WebSocketDelegate newDelegate() {
        return new WebSocketDelegate();
    }

    public static class Factory
    extends ContainerLifeCycle
    implements ClientTransport.Factory {
        private final WebSocketContainer container = ContainerProvider.getWebSocketContainer();

        public Factory() {
            this.addBean(this.container, true);
        }

        public ClientTransport newClientTransport(String url, Map<String, Object> options) {
            ScheduledExecutorService scheduler = (ScheduledExecutorService)options.get("scheduler");
            return new WebSocketTransport(url, options, scheduler, this.container);
        }
    }

    private class Configurator
    extends ClientEndpointConfig.Configurator {
        private Configurator() {
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            CookieStore cookieStore = WebSocketTransport.this.getCookieStore();
            List<HttpCookie> cookies = cookieStore.get(URI.create(WebSocketTransport.this.getURL()));
            if (!cookies.isEmpty()) {
                List<String> cookieHeader = headers.get("Cookie");
                if (cookieHeader == null) {
                    cookieHeader = headers.get("cookie");
                }
                if (cookieHeader == null) {
                    cookieHeader = new ArrayList<String>();
                    headers.put("Cookie", cookieHeader);
                }
                for (HttpCookie cookie : cookies) {
                    cookieHeader.add(cookie.getName() + "=" + cookie.getValue());
                }
            }
        }

        public void afterResponse(HandshakeResponse hr) {
            Map headers = hr.getHeaders();
            WebSocketTransport.this.storeCookies(headers);
            WebSocketTransport.this._webSocketSupported = false;
            for (String name : headers.keySet()) {
                if (!"Sec-WebSocket-Accept".equalsIgnoreCase(name)) continue;
                WebSocketTransport.this._webSocketSupported = true;
                break;
            }
        }
    }

    protected class WebSocketDelegate
    extends AbstractWebSocketTransport.Delegate
    implements MessageHandler.Whole<String> {
        private final Endpoint _endpoint;
        private Session _session;

        protected WebSocketDelegate() {
            super((AbstractWebSocketTransport)WebSocketTransport.this);
            this._endpoint = new WebSocketEndpoint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onOpen(Session session) {
            WebSocketDelegate webSocketDelegate = this;
            synchronized (webSocketDelegate) {
                this._session = session;
            }
            session.addMessageHandler((MessageHandler)this);
            if (WebSocketTransport.this.logger.isDebugEnabled()) {
                WebSocketTransport.this.logger.debug("Opened websocket session {}", (Object)session);
            }
        }

        public void onMessage(String data) {
            this.onData(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(String content) {
            Session session;
            WebSocketDelegate webSocketDelegate = this;
            synchronized (webSocketDelegate) {
                session = this._session;
            }
            try {
                if (session == null) {
                    throw new IOException("Unconnected");
                }
                session.getAsyncRemote().sendText(content).get();
            }
            catch (Throwable x) {
                this.fail(x, "Exception");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void shutdown(String reason) {
            Session session;
            WebSocketDelegate webSocketDelegate = this;
            synchronized (webSocketDelegate) {
                session = this._session;
                this.close();
            }
            if (session != null) {
                if (WebSocketTransport.this.logger.isDebugEnabled()) {
                    WebSocketTransport.this.logger.debug("Closing ({}) websocket session {}", (Object)reason, (Object)session);
                }
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, reason));
                }
                catch (IOException x) {
                    WebSocketTransport.this.logger.trace("Could not close websocket session " + session, (Throwable)x);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isOpen() {
            WebSocketDelegate webSocketDelegate = this;
            synchronized (webSocketDelegate) {
                return this._session != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            WebSocketDelegate webSocketDelegate = this;
            synchronized (webSocketDelegate) {
                this._session = null;
            }
        }

        private class WebSocketEndpoint
        extends Endpoint {
            private WebSocketEndpoint() {
            }

            public void onOpen(Session session, EndpointConfig config) {
                WebSocketDelegate.this.onOpen(session);
            }

            public void onClose(Session session, CloseReason closeReason) {
                WebSocketDelegate.this.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
            }

            public void onError(Session session, Throwable failure) {
                WebSocketDelegate.this.failMessages(failure);
            }
        }
    }
}

