/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsContainBinaryFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsVersionableFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={CreateNewVersionActionListener.class})})
public class CreateNewVersionManageComponent
extends UIAbstractManagerComponent {
    private static Log log = ExoLogger.getExoLogger(CreateNewVersionManageComponent.class);
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsVersionableFilter(), new IsNotInTrashFilter(), new IsNotEditingDocumentFilter(), new IsNotLockedFilter(), new IsContainBinaryFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class CreateNewVersionActionListener
    extends UIWorkingAreaActionListener<CreateNewVersionManageComponent> {
        public void processEvent(Event<CreateNewVersionManageComponent> event) throws Exception {
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((CreateNewVersionManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            if (nodePath == null) {
                nodePath = uiExplorer.getCurrentWorkspace() + ':' + uiExplorer.getCurrentPath();
            }
            Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
            String wsName = null;
            if (!matcher.find()) {
                throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
            }
            wsName = matcher.group(1);
            nodePath = matcher.group(2);
            Session session = uiExplorer.getSessionByWorkspace(wsName);
            Node node = uiExplorer.getNodeByPath(nodePath, session);
            AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
            autoVersionService.autoVersion(node);
            String msg = event.getRequestContext().getApplicationResourceBundle().getString("DocumentAuto.message");
            msg = msg.replace("{0}", ContentReader.simpleEscapeHtml((String)("<span style='font-weight:bold;'>" + node.getName() + "</span>")));
            event.getRequestContext().getJavascriptManager().require("SHARED/wcm-utils", "wcm_utils").addScripts("eXo.ecm.WCMUtils.showNotice(\"" + msg + "\", 'true'); ");
        }
    }
}

