/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy.impl.propertysuppression;

import org.apache.commons.betwixt.strategy.PropertySuppressionStrategy;

public class PackageSuppressor
extends PropertySuppressionStrategy {
    private final String suppressedPackage;
    private final boolean exact;

    public PackageSuppressor(String suppressedPackage) {
        if (suppressedPackage.endsWith(".*")) {
            this.exact = false;
            suppressedPackage = suppressedPackage.substring(0, suppressedPackage.length() - 2);
        } else {
            this.exact = true;
        }
        this.suppressedPackage = suppressedPackage;
    }

    public boolean suppressProperty(Class classContainingTheProperty, Class propertyType, String propertyName) {
        Package propertyTypePackage;
        boolean result = false;
        if (propertyType != null && (propertyTypePackage = propertyType.getPackage()) != null) {
            String packageName = propertyTypePackage.getName();
            if (this.exact) {
                result = this.suppressedPackage.equals(packageName);
            } else if (packageName != null) {
                result = packageName.startsWith(this.suppressedPackage);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Suppressing package ");
        buffer.append(this.suppressedPackage);
        if (this.exact) {
            buffer.append("(exact)");
        }
        return buffer.toString();
    }
}

