/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.WindowState;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UISocialNavigation
extends UIComponent {
    private boolean useAJAX = true;
    protected UserNode selectedNode_;
    protected Object selectedParent_;

    public UIComponent getViewModeUIComponent() {
        return null;
    }

    public void setUseAjax(boolean bl) {
        this.useAJAX = bl;
    }

    public boolean isUseAjax() {
        return this.useAJAX;
    }

    public List<UserNavigation> getNavigations() throws Exception {
        ArrayList<UserNavigation> result = new ArrayList<UserNavigation>();
        List navigations = SpaceUtils.getUserPortal().getNavigations();
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        for (UserNavigation userNavigation : navigations) {
            if (!userNavigation.getKey().getName().equals(portalRequest.getPortalOwner()) || !userNavigation.getKey().getTypeName().equals("portal")) continue;
            result.add(userNavigation);
        }
        return result;
    }

    public UserNavigation getSelectedNavigation() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UserNode selectedNode = uiPortal.getSelectedUserNode();
        return selectedNode.getNavigation();
    }

    public Object getSelectedParent() {
        return this.selectedParent_;
    }

    public UserNode getSelectedPageNode() throws Exception {
        if (this.selectedNode_ == null) {
            this.selectedNode_ = Util.getUIPortal().getSelectedUserNode();
        }
        return this.selectedNode_;
    }

    public boolean isSelectedNode(UserNode node) {
        if (this.selectedNode_ != null && node.getURI().equals(this.selectedNode_.getURI())) {
            return true;
        }
        if (this.selectedParent_ != null && this.selectedParent_ instanceof PageNode) {
            return node.getURI().equals(((UserNode)this.selectedParent_).getURI());
        }
        return false;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        if (uiPortal.getSelectedUserNode() != this.selectedNode_) {
            this.setSelectedPageNode(uiPortal.getSelectedUserNode());
        }
        super.processRender(context);
    }

    private void setSelectedPageNode(UserNode selectedNode) throws Exception {
        UserPortal userPortal = SpaceUtils.getUserPortal();
        this.selectedNode_ = selectedNode;
        this.selectedParent_ = null;
        String seletctUri = selectedNode.getURI();
        int index = seletctUri.lastIndexOf("/");
        String parentUri = null;
        if (index > 0) {
            parentUri = seletctUri.substring(0, seletctUri.lastIndexOf("/"));
        }
        List<UserNavigation> pageNavs = this.getNavigations();
        for (UserNavigation pageNav : pageNavs) {
            if (userPortal.resolvePath(pageNav, null, selectedNode.getURI()) == null) continue;
            if (parentUri == null || parentUri.length() < 1) {
                this.selectedParent_ = pageNav;
                break;
            }
            this.selectedParent_ = userPortal.resolvePath(pageNav, null, parentUri);
            break;
        }
    }

    public static class SelectNodeActionListener
    extends EventListener<UISocialNavigation> {
        public void execute(Event<UISocialNavigation> event) throws Exception {
            UserNode selectNode;
            UserPortal userPortal = Util.getUIPortalApplication().getUserPortalConfig().getUserPortal();
            UISocialNavigation uiNavigation = (UISocialNavigation)((Object)event.getSource());
            UIPortal uiPortal = Util.getUIPortal();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            int index = uri.lastIndexOf("::");
            String id = uri.substring(index + 2);
            UserNavigation selectNav = null;
            if (index <= 0) {
                UserNode selectedNode = uiPortal.getSelectedUserNode();
                selectNav = selectedNode.getNavigation();
            } else {
                String navId = uri.substring(0, index);
            }
            uiNavigation.selectedNode_ = selectNode = userPortal.resolvePath(selectNav, null, id);
            String parentUri = null;
            index = uri.lastIndexOf("/");
            if (index > 0) {
                parentUri = uri.substring(0, index);
            }
            uiNavigation.selectedParent_ = parentUri == null || parentUri.length() < 1 ? selectNav : userPortal.resolvePath(selectNav, null, parentUri);
            UIPage uiPage = (UIPage)uiPortal.findFirstComponentOfType(UIPage.class);
            if (uiPage != null && uiPage.getMaximizedUIPortlet() != null) {
                UIPortlet currentPortlet = uiPage.getMaximizedUIPortlet();
                currentPortlet.setCurrentWindowState(WindowState.NORMAL);
                uiPage.setMaximizedUIPortlet(null);
            }
            PageNodeEvent pnevent = new PageNodeEvent((UIComponent)uiPortal, "ChangeNode", selectNode.getNavigation().getKey(), uri);
            uiPortal.broadcast((Event)pnevent, Event.Phase.PROCESS);
        }
    }
}

