/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.setting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.model.GroupProvider;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.GroupProviderPlugin;
import org.exoplatform.commons.api.notification.plugin.config.GroupConfig;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PluginSettingServiceImpl
extends AbstractService
implements PluginSettingService {
    private static final Log LOG = ExoLogger.getLogger(PluginSettingServiceImpl.class);
    private List<PluginConfig> pluginConfigs = new ArrayList<PluginConfig>();
    private Map<String, GroupProvider> groupPluginMap = new ConcurrentHashMap<String, GroupProvider>();
    private static final String NAME_SPACES = "exo:";
    private static final int DAYS_OF_MONTH = 31;
    private SettingService settingService;
    private ChannelManager channelManager;

    public PluginSettingServiceImpl(SettingService settingService, ChannelManager channelManager) {
        this.settingService = settingService;
        this.channelManager = channelManager;
    }

    public void registerPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfigs.add(pluginConfig);
        if (!pluginConfig.isChildPlugin()) {
            PluginInfo pluginInfo = new PluginInfo();
            pluginInfo.setType(pluginConfig.getPluginId()).setOrder(Integer.valueOf(pluginConfig.getOrder()).intValue()).setResourceBundleKey(pluginConfig.getResourceBundleKey()).setBundlePath(pluginConfig.getBundlePath()).setDefaultConfig(pluginConfig.getDefaultConfig());
            ArrayList<String> channels = new ArrayList<String>();
            for (AbstractChannel channel : this.channelManager.getChannels()) {
                channels.add(channel.getId());
            }
            pluginInfo.setChannelActives(this.getSettingPlugins(pluginConfig.getPluginId(), channels));
            String groupId = pluginConfig.getGroupId();
            GroupConfig gConfig = pluginConfig.getGroupConfig();
            if (gConfig != null) {
                groupId = gConfig.getId();
            }
            if (this.groupPluginMap.containsKey(groupId)) {
                this.groupPluginMap.get(groupId).addPluginInfo(pluginInfo);
            } else if (groupId != null && groupId.length() > 0) {
                GroupProvider groupProvider = new GroupProvider(groupId);
                groupProvider.addPluginInfo(pluginInfo);
                if (gConfig != null) {
                    groupProvider.setOrder(Integer.valueOf(gConfig.getOrder()).intValue());
                    groupProvider.setResourceBundleKey(gConfig.getResourceBundleKey());
                }
                this.groupPluginMap.put(groupId, groupProvider);
            }
            this.createParentNodeOfPlugin(pluginConfig.getPluginId());
        }
    }

    public void registerGroupConfig(GroupProviderPlugin groupConfigPlg) {
        for (GroupConfig gconfig : groupConfigPlg.getGroupProviders()) {
            GroupProvider groupProvider = new GroupProvider(gconfig.getId());
            groupProvider.setOrder(Integer.valueOf(gconfig.getOrder()).intValue());
            groupProvider.setResourceBundleKey(gconfig.getResourceBundleKey());
            if (this.groupPluginMap.containsKey(gconfig.getId())) {
                groupProvider.setPluginInfos(this.groupPluginMap.get(gconfig.getId()).getPluginInfos());
            }
            this.groupPluginMap.put(gconfig.getId(), groupProvider);
        }
    }

    public PluginConfig getPluginConfig(String pluginId) {
        for (PluginConfig pluginConfig : this.pluginConfigs) {
            if (!pluginConfig.getPluginId().equals(pluginId)) continue;
            return pluginConfig;
        }
        return null;
    }

    public List<GroupProvider> getGroupPlugins() {
        ArrayList<GroupProvider> groupProviders = new ArrayList<GroupProvider>();
        for (GroupProvider groupPlugin : this.groupPluginMap.values()) {
            for (PluginInfo pluginInfo : groupPlugin.getPluginInfos()) {
                pluginInfo.setChannelActives(this.getSettingPlugins(pluginInfo.getType()));
            }
            groupProviders.add(groupPlugin);
        }
        Collections.sort(groupProviders, new ComparatorASC());
        return groupProviders;
    }

    public void saveActivePlugin(String channelId, String pluginId, boolean isActive) {
        List<String> current = this.getSettingPlugins(pluginId);
        if (isActive) {
            if (!current.contains(channelId)) {
                current.add(channelId);
                this.saveActivePlugins(pluginId, current);
            }
        } else if (current.contains(channelId)) {
            current.remove(channelId);
            this.saveActivePlugins(pluginId, current);
        }
    }

    private void saveActivePlugins(String pluginId, List<String> channels) {
        this.saveActivePlugins(pluginId, NotificationUtils.listToString(channels, "{VALUE}"));
    }

    private void saveActivePlugins(String pluginId, String channelIds) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + pluginId, SettingValue.create((String)channelIds));
    }

    private List<String> getSettingPlugins(String pluginId, List<String> defaultValue) {
        return NotificationUtils.stringToList(this.getSetting(pluginId, NotificationUtils.listToString(defaultValue)));
    }

    private List<String> getSettingPlugins(String pluginId) {
        return this.getSettingPlugins(pluginId, null);
    }

    private String getSetting(String pluginId, String defaultValues) {
        SettingValue sValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(null), NAME_SPACES + pluginId);
        String channels = defaultValues;
        String values = "";
        if (sValue != null) {
            values = String.valueOf(sValue.getValue());
            if ("false".equals(values)) {
                channels = defaultValues.replace(UserSetting.EMAIL_CHANNEL, "");
            } else if (!"true".equals(values)) {
                channels = PluginSettingServiceImpl.getValues(values);
            }
        }
        if (!defaultValues.isEmpty() && (sValue == null || values.equals("true") || values.equals("false"))) {
            this.saveActivePlugins(pluginId, NotificationUtils.stringToList(channels));
        }
        return channels;
    }

    private boolean isActive(String channelId, String pluginId, boolean defaultValue) {
        List<String> current = this.getSettingPlugins(pluginId);
        if (current.contains(channelId)) {
            return true;
        }
        return defaultValue;
    }

    public boolean isActive(String channelId, String pluginId) {
        return this.isActive(channelId, pluginId, false);
    }

    public List<String> getActivePluginIds(String channelId) {
        HashSet<String> activePluginIds = new HashSet<String>();
        Collections.sort(this.pluginConfigs, new ComparatorASC());
        for (PluginConfig pluginConfig : this.pluginConfigs) {
            if (pluginConfig.isChildPlugin() || !this.isActive(channelId, pluginConfig.getPluginId())) continue;
            activePluginIds.add(pluginConfig.getPluginId());
        }
        return Collections.unmodifiableList(new ArrayList(activePluginIds));
    }

    public List<PluginInfo> getActivePlugins(String channelId) {
        HashSet<PluginInfo> activePlugins = new HashSet<PluginInfo>();
        for (GroupProvider groupPlugin : this.groupPluginMap.values()) {
            for (PluginInfo pluginInfo : groupPlugin.getPluginInfos()) {
                if (!this.isActive(channelId, pluginInfo.getType())) continue;
                activePlugins.add(pluginInfo);
            }
        }
        return Collections.unmodifiableList(new ArrayList(activePlugins));
    }

    public List<PluginInfo> getAllPlugins() {
        HashSet<PluginInfo> activePlugins = new HashSet<PluginInfo>();
        for (GroupProvider groupPlugin : this.groupPluginMap.values()) {
            for (PluginInfo pluginInfo : groupPlugin.getPluginInfos()) {
                activePlugins.add(pluginInfo);
            }
        }
        return Collections.unmodifiableList(new ArrayList(activePlugins));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentNodeOfPlugin(String pluginId) {
        try (SessionProvider sProvider = SessionProvider.createSystemProvider();){
            NotificationConfiguration configuration = CommonsUtils.getService(NotificationConfiguration.class);
            Node node = this.getMessageNodeByPluginId(sProvider, configuration.getWorkspace(), pluginId);
            for (int i = 1; i <= 31; ++i) {
                this.getOrCreateMessageNode(node, "d" + i);
            }
        }
    }

    public void saveActive(String pluginId, boolean isActive) {
        this.saveActivePlugin(UserSetting.EMAIL_CHANNEL, pluginId, isActive);
    }

    public boolean isActive(String pluginId) {
        return this.isActive(UserSetting.EMAIL_CHANNEL, pluginId);
    }

    private class ComparatorASC
    implements Comparator<Object> {
        private ComparatorASC() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof GroupProvider) {
                Integer order1 = ((GroupProvider)o1).getOrder();
                Integer order2 = ((GroupProvider)o2).getOrder();
                return order1.compareTo(order2);
            }
            if (o1 instanceof PluginConfig) {
                Integer order1 = Integer.valueOf(((PluginConfig)o1).getOrder());
                Integer order2 = Integer.valueOf(((PluginConfig)o2).getOrder());
                return order1.compareTo(order2);
            }
            return 0;
        }
    }
}

