/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public final class ThumbnailUtils {
    private static final Log LOG = ExoLogger.getLogger((String)ThumbnailUtils.class.getName());

    public static synchronized Node getThumbnailFolder(Node parentNode) throws RepositoryException {
        if (!parentNode.hasNode("exo:thumbnails")) {
            try {
                Node thumbnailFolder = parentNode.addNode("exo:thumbnails", "exo:thumbnails");
                parentNode.getSession().save();
                if (thumbnailFolder.canAddMixin("exo:hiddenable")) {
                    thumbnailFolder.addMixin("exo:hiddenable");
                }
                parentNode.getSession().save();
                return thumbnailFolder;
            }
            catch (ItemExistsException e) {
                return parentNode.getNode("exo:thumbnails");
            }
        }
        return parentNode.getNode("exo:thumbnails");
    }

    public static synchronized Node getThumbnailNode(Node thumbnailFolder, String identifier) throws RepositoryException {
        if (!thumbnailFolder.hasNode(identifier)) {
            try {
                Node thumbnailNode = thumbnailFolder.addNode(identifier, "exo:thumbnail");
                thumbnailFolder.getSession().save();
                return thumbnailNode;
            }
            catch (ItemExistsException e) {
                return thumbnailFolder.getNode(identifier);
            }
        }
        return thumbnailFolder.getNode(identifier);
    }
}

