/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableContent {
    private static final Map<String, Object> EMPTY_MAP = ImmutableMap.of();
    private String content;
    private byte[] contentBytes;
    private Charset contentEncoding;
    private HttpResponse contentSource;
    private Document document;
    private int numChanges;
    private final GadgetHtmlParser contentParser;
    private Map<String, Object> pipelinedData;
    private static final String MUTABLE_CONTENT_LISTENER = "MutableContentListener";
    private static final Logger logger = Logger.getLogger(MutableContent.class.getName());

    public static void notifyEdit(Document doc) {
        MutableContent mc = (MutableContent)doc.getUserData(MUTABLE_CONTENT_LISTENER);
        if (mc != null) {
            mc.documentChanged();
        }
    }

    public MutableContent(GadgetHtmlParser contentParser, String content) {
        this.contentParser = contentParser;
        this.content = content;
        this.numChanges = 0;
        this.contentEncoding = Charsets.UTF_8;
    }

    public MutableContent(GadgetHtmlParser contentParser, HttpResponse contentSource) {
        this.contentParser = contentParser;
        this.contentSource = contentSource;
        this.contentEncoding = contentSource != null ? contentSource.getEncodingCharset() : null;
    }

    public String getContent() {
        if (this.content == null) {
            if (this.contentSource != null) {
                this.content = this.contentSource.getResponseAsString();
                this.contentSource = null;
            } else if (this.document != null) {
                this.content = HtmlSerialization.serialize(this.document);
            } else if (this.contentBytes != null) {
                Charset useEncoding = this.contentEncoding != null ? this.contentEncoding : Charsets.UTF_8;
                this.content = useEncoding.decode(ByteBuffer.wrap(this.contentBytes)).toString();
            }
        }
        return this.content;
    }

    public void setContent(String newContent) {
        if (this.content == null || !this.content.equals(newContent)) {
            this.content = newContent;
            this.document = null;
            this.contentSource = null;
            this.contentBytes = null;
            this.incrementNumChanges();
        }
    }

    public InputStream getContentBytes() {
        return new ByteArrayInputStream(this.getRawContentBytes());
    }

    protected byte[] getRawContentBytes() {
        if (this.contentBytes == null) {
            if (this.contentSource != null) {
                try {
                    this.setContentBytesState(IOUtils.toByteArray((InputStream)this.contentSource.getResponse()), this.contentSource.getEncodingCharset());
                    this.contentSource = null;
                }
                catch (IOException iOException) {}
            } else if (this.content != null) {
                this.setContentBytesState(CharsetUtil.getUtf8Bytes((String)this.content), Charsets.UTF_8);
            } else if (this.document != null) {
                this.setContentBytesState(CharsetUtil.getUtf8Bytes((String)HtmlSerialization.serialize(this.document)), Charsets.UTF_8);
            }
        }
        return this.contentBytes;
    }

    public void setContentBytes(byte[] newBytes, Charset newEncoding) {
        if (this.contentBytes == null || !Arrays.equals(this.contentBytes, newBytes)) {
            this.setContentBytesState(newBytes, newEncoding);
            this.document = null;
            this.contentSource = null;
            this.content = null;
            this.incrementNumChanges();
        }
    }

    public final void setContentBytes(byte[] newBytes) {
        this.setContentBytes(newBytes, null);
    }

    protected void setContentBytesState(byte[] newBytes, Charset newEncoding) {
        this.contentBytes = newBytes;
        this.contentEncoding = newEncoding;
    }

    public void documentChanged() {
        if (this.document != null) {
            this.content = null;
            this.contentSource = null;
            this.contentBytes = null;
            this.incrementNumChanges();
        }
    }

    public Document getDocument() {
        if (this.document != null) {
            return this.document;
        }
        try {
            this.document = this.contentParser.parseDom(this.getContent());
            this.document.setUserData(MUTABLE_CONTENT_LISTENER, this, null);
        }
        catch (GadgetException e) {
            logger.log(Level.WARNING, "Got GadgetException when parsing content", e);
            return null;
        }
        return this.document;
    }

    public int getNumChanges() {
        return this.numChanges;
    }

    protected void incrementNumChanges() {
        ++this.numChanges;
    }

    public boolean hasDocument() {
        return this.document != null;
    }

    public void addPipelinedData(String key, Object value) {
        if (null == this.pipelinedData) {
            this.pipelinedData = Maps.newHashMap();
        }
        this.pipelinedData.put(key, value);
    }

    public Map<String, Object> getPipelinedData() {
        return null == this.pipelinedData ? EMPTY_MAP : this.pipelinedData;
    }
}

