/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.exoplatform.commons.utils.secure.SecureCollections;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.security.MembershipHashSet;
import org.exoplatform.services.security.PermissionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identity {
    private String userId;
    private final Set<MembershipEntry> memberships;
    private Subject subject;
    private final Set<String> roles;

    public Identity(String userId) {
        this(userId, new HashSet<MembershipEntry>(), new HashSet<String>());
    }

    public Identity(String userId, Collection<MembershipEntry> memberships) {
        this(userId, memberships, new HashSet<String>());
    }

    public Identity(String userId, Collection<MembershipEntry> memberships, Collection<String> roles) {
        this.userId = userId;
        this.memberships = SecureCollections.secureSet((Set)new MembershipHashSet((Collection<? extends MembershipEntry>)memberships), (Permission)PermissionConstants.MODIFY_IDENTITY_PERMISSION);
        this.roles = SecureCollections.secureSet(new HashSet<String>(roles), (Permission)PermissionConstants.MODIFY_IDENTITY_PERMISSION);
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isMemberOf(String group, String membershipType) {
        return this.containsMembership(new MembershipEntry(group, membershipType));
    }

    public boolean isMemberOf(MembershipEntry me) {
        return this.containsMembership(me);
    }

    public boolean isMemberOf(String group) {
        return this.containsMembership(new MembershipEntry(group));
    }

    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        for (MembershipEntry m : this.memberships) {
            groups.add(m.getGroup());
        }
        return groups;
    }

    @Deprecated
    public void setMemberships(Collection<MembershipEntry> memberships) {
        this.memberships.clear();
        this.memberships.addAll(memberships);
    }

    public Collection<MembershipEntry> getMemberships() {
        return this.memberships;
    }

    public void setRoles(Collection<String> roles) {
        this.roles.clear();
        this.roles.addAll(roles);
    }

    public Collection<String> getRoles() {
        return this.roles;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(PermissionConstants.MODIFY_IDENTITY_PERMISSION);
        }
        this.subject = subject;
    }

    private boolean containsMembership(MembershipEntry checkMe) {
        return this.memberships.contains(checkMe);
    }
}

