/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;

public class Chat
extends ReceiverAdapter {
    JChannel channel;

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("** view: " + new_view);
    }

    @Override
    public void receive(Message msg) {
        String line = "[" + msg.getSrc() + "]: " + msg.getObject();
        System.out.println(line);
    }

    private void start(String props, String name) throws Exception {
        this.channel = new JChannel(props);
        if (name != null) {
            this.channel.setName(name);
        }
        this.channel.setReceiver(this);
        this.channel.connect("ChatCluster");
        this.eventLoop();
        this.channel.close();
    }

    private void eventLoop() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print("> ");
                    System.out.flush();
                    String line = in.readLine().toLowerCase();
                    if (line.startsWith("quit") || line.startsWith("exit")) break block2;
                    Message msg = new Message(null, null, line);
                    this.channel.send(msg);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        String props = "udp.xml";
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            Chat.help();
            return;
        }
        new Chat().start(props, name);
    }

    protected static void help() {
        System.out.println("ChatDemo [-props XML config]");
    }
}

