/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.upgrade;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class UpgradeProductPlugin
extends BaseComponentPlugin {
    public static final String UPGRADE_COMPLETED_STATUS = "Completed";
    private static final Log LOG = ExoLogger.getLogger(UpgradeProductPlugin.class);
    private static final String PRODUCT_GROUP_ID = "product.group.id";
    private static final String OLD_PRODUCT_GROUP_ID = "old.product.group.id";
    private static final String UPGRADE_PLUGIN_EXECUTION_ORDER = "plugin.execution.order";
    private static final String UPGRADE_PLUGIN_ENABLE = "commons.upgrade.{$0}.enable";
    private SettingService settingService;
    private int pluginExecutionOrder;
    protected String productGroupId;
    protected String oldProductGroupId;

    public UpgradeProductPlugin(SettingService settingService, InitParams initParams) {
        this(initParams);
        this.settingService = settingService;
    }

    public UpgradeProductPlugin(InitParams initParams) {
        if (!initParams.containsKey((Object)PRODUCT_GROUP_ID)) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Couldn't find the init value param: product.group.id");
            }
            return;
        }
        this.productGroupId = initParams.getValueParam(PRODUCT_GROUP_ID).getValue();
        ValueParam vp = initParams.getValueParam(OLD_PRODUCT_GROUP_ID);
        this.oldProductGroupId = vp != null ? vp.getValue() : this.productGroupId;
        this.pluginExecutionOrder = !initParams.containsKey((Object)UPGRADE_PLUGIN_EXECUTION_ORDER) ? 0 : Integer.parseInt(initParams.getValueParam(UPGRADE_PLUGIN_EXECUTION_ORDER).getValue());
    }

    public String getProductGroupId() {
        return this.productGroupId;
    }

    public String getOldProductGroupId() {
        return this.oldProductGroupId;
    }

    public boolean isEnabled() {
        String isEnabledProperty = PropertyManager.getProperty((String)UPGRADE_PLUGIN_ENABLE.replace("{$0}", this.getName()));
        return isEnabledProperty == null || isEnabledProperty.equals("true");
    }

    public void addNodeVersion(Node nodeToAddVersion, String versionLabel) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, ItemExistsException, InvalidItemStateException, ReferentialIntegrityException, RepositoryException {
        if (!nodeToAddVersion.isNodeType("mix:versionable")) {
            nodeToAddVersion.addMixin("mix:versionable");
            nodeToAddVersion.save();
            nodeToAddVersion.getSession().save();
            nodeToAddVersion.getSession().refresh(true);
        }
        if (nodeToAddVersion.isCheckedOut()) {
            Version version = nodeToAddVersion.checkin();
            nodeToAddVersion.getVersionHistory().addVersionLabel(version.getName(), versionLabel, false);
        }
        nodeToAddVersion.checkout();
    }

    public abstract void processUpgrade(String var1, String var2);

    public abstract boolean shouldProceedToUpgrade(String var1, String var2);

    public final boolean equals(Object obj) {
        if (obj != null && obj instanceof UpgradeProductPlugin) {
            return this.getName().equals(((UpgradeProductPlugin)((Object)obj)).getName());
        }
        return false;
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public int getPluginExecutionOrder() {
        return this.pluginExecutionOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String paramName) {
        if (this.settingService == null) {
            throw new IllegalStateException("SettingService Service is not set");
        }
        try {
            Scope appId = Scope.APPLICATION.id(this.getName());
            SettingValue paramValue = this.settingService.get(Context.GLOBAL, appId, paramName);
            if (paramValue != null && paramValue.getValue() != null) {
                String string = paramValue.getValue().toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            Scope.APPLICATION.id(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeValueForPlugin(String paramName, String paramValue) {
        if (this.settingService == null) {
            throw new IllegalStateException("SettingService Service is not set");
        }
        try {
            this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id(this.getName()), paramName, SettingValue.create((String)paramValue));
        }
        finally {
            Scope.APPLICATION.id(null);
        }
    }
}

