/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.exportimport;

import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.management.exportimport.AbstractImportTask;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;

public class SiteLayoutImportTask
extends AbstractImportTask<PortalConfig> {
    private final DataStorage dataStorage;
    private PortalConfig rollbackDelete;
    private PortalConfig rollbackSave;

    public SiteLayoutImportTask(PortalConfig data, SiteKey siteKey, DataStorage dataStorage) {
        super(data, siteKey);
        this.dataStorage = dataStorage;
    }

    @Override
    public void importData(ImportMode importMode) throws Exception {
        PortalConfig dst = this.dataStorage.getPortalConfig(this.siteKey.getTypeName(), this.siteKey.getName());
        switch (importMode) {
            case CONSERVE: {
                if (dst == null) {
                    dst = (PortalConfig)this.data;
                    this.rollbackDelete = (PortalConfig)this.data;
                    break;
                }
                dst = null;
                break;
            }
            case INSERT: 
            case MERGE: 
            case OVERWRITE: {
                if (dst == null) {
                    this.rollbackDelete = (PortalConfig)this.data;
                } else {
                    this.rollbackSave = PageUtils.copy(dst);
                }
                dst = (PortalConfig)this.data;
            }
        }
        if (dst != null) {
            if (this.rollbackDelete == null) {
                this.dataStorage.save(dst);
            } else {
                this.dataStorage.create(dst);
            }
            this.dataStorage.save();
        }
    }

    @Override
    public void rollback() throws Exception {
        if (this.rollbackDelete != null) {
            this.dataStorage.remove(this.rollbackDelete);
        } else if (this.rollbackSave != null) {
            this.dataStorage.save(this.rollbackSave);
            this.dataStorage.save();
        }
    }
}

