/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;

public class JCRUtils {
    private static final Log log = ExoLogger.getLogger(JCRUtils.class);
    private static final String JCR_WEBDAV_SERVICE_BASE_URI = "/jcr";

    public static String getCurrentRepositoryWebDavUri() {
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.getDefaultRestBaseURI());
        sb.append(JCR_WEBDAV_SERVICE_BASE_URI);
        sb.append("/");
        RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
        try {
            sb.append(repositoryService.getCurrentRepository().getConfiguration().getName());
        }
        catch (RepositoryException e) {
            sb.append(repositoryService.getConfig().getDefaultRepositoryName());
        }
        sb.append("/");
        return sb.toString();
    }

    public static SessionProvider createSystemProvider() {
        SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
        return sessionProviderService.getSystemSessionProvider(null);
    }

    public static String getWikiType(String jcrPath) throws IllegalArgumentException {
        if (jcrPath.startsWith("/exo:applications/")) {
            return PortalConfig.PORTAL_TYPE;
        }
        if (jcrPath.startsWith("/Groups/")) {
            return PortalConfig.GROUP_TYPE;
        }
        if (jcrPath.startsWith("/Users/")) {
            return PortalConfig.USER_TYPE;
        }
        throw new IllegalArgumentException(jcrPath + " is not jcr path of a wiki page node!");
    }

    public static boolean hasPermission(AccessControlList acl, String[] permission, Identity user) {
        String userId = user.getUserId();
        if (userId.equals(IdentityConstants.SYSTEM)) {
            return true;
        }
        if (userId.equals(acl.getOwner())) {
            return true;
        }
        if (userId.equals(IdentityConstants.ANONIM)) {
            List anyPermissions = acl.getPermissions(IdentityConstants.ANY);
            if (anyPermissions.size() < permission.length) {
                return false;
            }
            for (int i = 0; i < permission.length; ++i) {
                if (anyPermissions.contains(permission[i])) continue;
                return false;
            }
            return true;
        }
        if (acl.getPermissionsSize() > 0 && permission.length > 0) {
            for (int i = 0; i < permission.length; ++i) {
                if (JCRUtils.isPermissionMatch(acl.getPermissionEntries(), permission[i], user)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasPermission(String[] permission, Identity user, WikiPageParams pageParams) {
        UserACL userACL = (UserACL)Util.getUIPortalApplication().getApplicationComponent(UserACL.class);
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        List<Object> permissionEntries = new ArrayList();
        try {
            permissionEntries = wikiService.getWikiPermission(pageParams.getType(), pageParams.getOwner());
        }
        catch (Exception e) {
            log.error((Object)("Cannot get permissions of wiki " + pageParams.getType() + ":" + pageParams.getOwner() + " - Cause : " + e.getMessage()), (Throwable)e);
        }
        ArrayList<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
        for (PermissionEntry permissionEntry : permissionEntries) {
            Permission[] perms;
            for (Permission perm : perms = permissionEntry.getPermissions()) {
                if (!perm.isAllowed()) continue;
                AccessControlEntry ace = new AccessControlEntry(permissionEntry.getId(), perm.getPermissionType().toString());
                aces.add(ace);
            }
        }
        AccessControlList acl = new AccessControlList(userACL.getSuperUser(), aces);
        return JCRUtils.hasPermission(acl, permission, user);
    }

    private static boolean isPermissionMatch(List<AccessControlEntry> existedPermission, String testPermission, Identity user) {
        int length = existedPermission.size();
        for (int i = 0; i < length; ++i) {
            AccessControlEntry ace = existedPermission.get(i);
            if (!testPermission.equals(ace.getPermission())) continue;
            if (IdentityConstants.ANY.equals(ace.getIdentity())) {
                return true;
            }
            if (!(ace.getIdentity().indexOf(":") == -1 ? ace.getIdentity().equals(user.getUserId()) : user.isMemberOf(ace.getMembershipEntry()))) continue;
            return true;
        }
        return false;
    }

    public static String[] getAllPermissionText() {
        return new String[]{"read", "add_node", "remove", "set_property"};
    }

    public static String getReadPermissionText() {
        return "read";
    }

    private static String getAddNodePermissionText() {
        return "add_node";
    }

    private static String getRemovePermissionText() {
        return "remove";
    }

    private static String getSetPropertyPermissionText() {
        return "set_property";
    }

    public static List<PermissionEntry> convertToPermissionEntryList(HashMap<String, String[]> permissions) {
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        Set<Map.Entry<String, String[]>> entries = permissions.entrySet();
        for (Map.Entry<String, String[]> entry : entries) {
            PermissionEntry permissionEntry = new PermissionEntry();
            String key = entry.getKey();
            IDType idType = IDType.USER;
            if (key.indexOf(":") > 0) {
                idType = IDType.MEMBERSHIP;
            } else if (key.indexOf("/") == 0) {
                idType = IDType.GROUP;
            }
            permissionEntry.setIdType(idType);
            permissionEntry.setId(key);
            Permission[] perms = new Permission[2];
            perms[0] = new Permission();
            perms[0].setPermissionType(PermissionType.VIEWPAGE);
            perms[1] = new Permission();
            perms[1].setPermissionType(PermissionType.EDITPAGE);
            for (String action : entry.getValue()) {
                if (JCRUtils.getReadPermissionText().equals(action)) {
                    perms[0].setAllowed(true);
                    continue;
                }
                if (!JCRUtils.getAddNodePermissionText().equals(action) && !JCRUtils.getRemovePermissionText().equals(action) && !JCRUtils.getSetPropertyPermissionText().equals(action)) continue;
                perms[1].setAllowed(true);
            }
            permissionEntry.setPermissions(perms);
            permissionEntries.add(permissionEntry);
        }
        return permissionEntries;
    }

    public static HashMap<String, String[]> convertToPermissionMap(List<PermissionEntry> permissionEntries) {
        HashMap<String, String[]> permissionMap = new HashMap<String, String[]>();
        for (PermissionEntry permissionEntry : permissionEntries) {
            Permission[] permissions = permissionEntry.getPermissions();
            ArrayList<String> permlist = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                Permission permission = permissions[i];
                if (!permission.isAllowed()) continue;
                if (permission.getPermissionType().equals((Object)PermissionType.VIEWPAGE)) {
                    permlist.add(JCRUtils.getReadPermissionText());
                    continue;
                }
                if (!permission.getPermissionType().equals((Object)PermissionType.EDITPAGE)) continue;
                permlist.add(JCRUtils.getAddNodePermissionText());
                permlist.add(JCRUtils.getRemovePermissionText());
                permlist.add(JCRUtils.getSetPropertyPermissionText());
            }
            if (permlist.size() <= 0) continue;
            permissionMap.put(permissionEntry.getId(), permlist.toArray(new String[permlist.size()]));
        }
        return permissionMap;
    }

    public static List<PermissionEntry> convertWikiPermissionsToPermissionEntryList(List<String> permissions) {
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        if (permissions != null) {
            for (String perm : permissions) {
                String[] actions = perm.substring(0, perm.indexOf(":")).split(",");
                perm = perm.substring(perm.indexOf(":") + 1);
                String idType = perm.substring(0, perm.indexOf(":"));
                String id = perm.substring(perm.indexOf(":") + 1);
                PermissionEntry entry = new PermissionEntry();
                if (IDType.USER.toString().equals(idType)) {
                    entry.setIdType(IDType.USER);
                } else if (IDType.GROUP.toString().equals(idType)) {
                    entry.setIdType(IDType.GROUP);
                } else if (IDType.MEMBERSHIP.toString().equals(idType)) {
                    entry.setIdType(IDType.MEMBERSHIP);
                }
                entry.setId(id);
                Permission[] perms = new Permission[4];
                perms[0] = new Permission();
                perms[0].setPermissionType(PermissionType.VIEWPAGE);
                perms[1] = new Permission();
                perms[1].setPermissionType(PermissionType.EDITPAGE);
                perms[2] = new Permission();
                perms[2].setPermissionType(PermissionType.ADMINPAGE);
                perms[3] = new Permission();
                perms[3].setPermissionType(PermissionType.ADMINSPACE);
                for (String action : actions) {
                    if (PermissionType.VIEWPAGE.toString().equals(action)) {
                        perms[0].setAllowed(true);
                        continue;
                    }
                    if (PermissionType.EDITPAGE.toString().equals(action)) {
                        perms[1].setAllowed(true);
                        continue;
                    }
                    if (PermissionType.ADMINPAGE.toString().equals(action)) {
                        perms[2].setAllowed(true);
                        continue;
                    }
                    if (!PermissionType.ADMINSPACE.toString().equals(action)) continue;
                    perms[3].setAllowed(true);
                }
                entry.setPermissions(perms);
                permissionEntries.add(entry);
            }
        }
        return permissionEntries;
    }

    public static List<String> convertPermissionEntryListToWikiPermissions(List<PermissionEntry> permissionEntries) {
        ArrayList<String> wikiPermissions = new ArrayList<String>();
        if (permissionEntries != null) {
            for (PermissionEntry permissionEntry : permissionEntries) {
                StringBuilder wikiPermission = new StringBuilder();
                for (Permission permission : permissionEntry.getPermissions()) {
                    if (!permission.isAllowed()) continue;
                    wikiPermission.append(permission.getPermissionType().toString()).append(",");
                }
                wikiPermission.append(":").append(permissionEntry.getIdType().toString()).append(":").append(permissionEntry.getId());
                wikiPermissions.add(wikiPermission.toString());
            }
        }
        return wikiPermissions;
    }
}

