/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc.configuration;

import org.infinispan.configuration.BuiltBy;
import org.infinispan.loaders.jdbc.AbstractJdbcCacheStoreConfig;
import org.infinispan.loaders.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.loaders.jdbc.configuration.LegacyConnectionFactoryAdaptor;
import org.infinispan.loaders.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.loaders.jdbc.connectionfactory.PooledConnectionFactory;

@BuiltBy(value=PooledConnectionFactoryConfigurationBuilder.class)
public class PooledConnectionFactoryConfiguration
implements ConnectionFactoryConfiguration,
LegacyConnectionFactoryAdaptor {
    private final String connectionUrl;
    private final String driverClass;
    private final String username;
    private final String password;

    PooledConnectionFactoryConfiguration(String connectionUrl, String driverClass, String username, String password) {
        this.connectionUrl = connectionUrl;
        this.driverClass = driverClass;
        this.username = username;
        this.password = password;
    }

    public String connectionUrl() {
        return this.connectionUrl;
    }

    public String driverClass() {
        return this.driverClass;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    @Override
    public Class<? extends ConnectionFactory> connectionFactoryClass() {
        return PooledConnectionFactory.class;
    }

    @Override
    public void adapt(AbstractJdbcCacheStoreConfig config) {
        config.setConnectionFactoryClass(this.connectionFactoryClass().getName());
        config.setConnectionUrl(this.connectionUrl);
        config.setDriverClass(this.driverClass);
        config.setUserName(this.username);
        config.setPassword(this.password);
    }

    public String toString() {
        return "PooledConnectionFactoryConfiguration [connectionUrl=" + this.connectionUrl + ", driverClass=" + this.driverClass + ", username=" + this.username + ", password=" + this.password + "]";
    }
}

