/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.container;

import java.util.HashSet;
import java.util.Set;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectFailedEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectLifeCycleEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.impl.container.DependencyNotResolvedException;

public abstract class LifeCycle
implements ManagedObject {
    private static final ThreadLocal<Set<Object>> faileds = new ThreadLocal();
    private Logger log = LoggerFactory.getLogger(LifeCycle.class);
    private LifeCycleStatus status = LifeCycleStatus.INITIALIZED;
    private boolean active = false;
    private Throwable failure;

    @Override
    public final LifeCycleStatus getStatus() {
        return this.status;
    }

    @Override
    public Throwable getFailure() {
        return this.failure;
    }

    @Override
    public final void managedStart() throws IllegalStateException {
        this.promote(LifeCycleStatus.STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void promote(LifeCycleStatus to) throws IllegalStateException {
        if (this.active) {
            throw new IllegalStateException("Reentrancy detected");
        }
        boolean clearFaileds = false;
        if (faileds.get() == null) {
            clearFaileds = true;
            faileds.set(new HashSet());
        } else if (faileds.get().contains(this)) {
            return;
        }
        this.active = true;
        this.failure = null;
        try {
            while (to.getStage() > this.status.getStage()) {
                LifeCycleStatus current = this.status;
                this.promote();
                if (current != this.status) continue;
                break;
            }
            this.promoteDependents(to);
        }
        finally {
            if (clearFaileds) {
                faileds.set(null);
            }
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promote() throws IllegalStateException {
        LifeCycleStatus to = this.status.getPromotion();
        if (to != null) {
            Throwable failure = null;
            try {
                LifeCycleStatus next = this.status;
                try {
                    switch (to) {
                        case CREATED: {
                            this.invokeCreate();
                            break;
                        }
                        case STARTED: {
                            this.invokeStart();
                        }
                    }
                    next = to;
                }
                catch (DependencyNotResolvedException ignore) {
                }
                catch (Exception e) {
                    this.log.error((Object)("Cannot promote object to " + (Object)((Object)to)), (Throwable)e);
                    failure = e;
                }
                catch (Error e) {
                    this.log.error((Object)("Cannot promote object to " + (Object)((Object)to)), (Throwable)e);
                    failure = e;
                }
                finally {
                    this.status = next;
                    if (failure != null) {
                        faileds.get().add(this);
                    }
                }
                if (failure == null) {
                    if (next == to) {
                        this.getListener().onEvent(new ManagedObjectLifeCycleEvent(this, next));
                    }
                } else {
                    this.getListener().onEvent(new ManagedObjectFailedEvent(this, next));
                }
            }
            finally {
                this.failure = failure;
            }
        }
    }

    @Override
    public final void managedDestroy() {
        this.demote(LifeCycleStatus.INITIALIZED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void demote(LifeCycleStatus to) throws IllegalStateException {
        if (this.active) {
            throw new IllegalStateException("Reentrancy detected");
        }
        this.active = true;
        this.failure = null;
        try {
            this.demoteDependents(to);
            while (to.getStage() < this.status.getStage()) {
                LifeCycleStatus current = this.status;
                this.demote();
                if (current != this.status) continue;
                break;
            }
        }
        finally {
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void demote() throws IllegalStateException {
        to = this.status.getDemotion();
        if (to != null) {
            try {
                switch (1.$SwitchMap$org$gatein$pc$portlet$container$managed$LifeCycleStatus[to.ordinal()]) {
                    case 1: {
                        this.invokeStop();
                        ** break;
lbl8:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        this.invokeDestroy();
                        break;
                    }
                    ** default:
lbl13:
                    // 1 sources

                    break;
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Error during object demotion to " + (Object)to), (Throwable)e);
            }
            catch (Error e) {
                this.log.error((Object)("Error during object demotion to " + (Object)to), (Throwable)e);
            }
            finally {
                this.status = to;
            }
            this.getListener().onEvent(new ManagedObjectLifeCycleEvent(this, to));
        }
    }

    protected void promoteDependents(LifeCycleStatus to) {
    }

    protected void demoteDependents(LifeCycleStatus to) {
    }

    protected abstract void invokeCreate() throws Exception;

    protected abstract void invokeStart() throws Exception;

    protected abstract void invokeStop();

    protected abstract void invokeDestroy() throws Exception;

    protected abstract ManagedObjectRegistryEventListener getListener();
}

