/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.RSyncJob;
import org.exoplatform.services.jcr.impl.core.query.ispn.ISPNIndexInfos;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.stack.IpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Listener
public class RsyncIndexInfos
extends ISPNIndexInfos {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RsyncIndexInfos");
    private final String indexPath;
    private final String urlFormatString;
    private final String rsyncUserName;
    private final String rsyncPassword;

    public RsyncIndexInfos(String wsId, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler, String indexPath, int rsyncPort, String rsyncEntryName, String rsyncEntryPath, String rsyncUserName, String rsyncPassword) throws RepositoryConfigurationException {
        super(wsId, cache, system, modeHandler);
        String relativeIndexPath;
        String absoluteRsyncEntryPath;
        this.rsyncUserName = rsyncUserName;
        this.rsyncPassword = rsyncPassword;
        try {
            this.indexPath = new File(indexPath).getCanonicalPath();
            absoluteRsyncEntryPath = new File(rsyncEntryPath).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Index path or rsyncEntry path is invalid.", e);
        }
        if (this.indexPath.startsWith(absoluteRsyncEntryPath)) {
            relativeIndexPath = this.indexPath.substring(absoluteRsyncEntryPath.length());
            if (File.separatorChar == '\\') {
                relativeIndexPath = relativeIndexPath.replace(File.separatorChar, '/');
            }
        } else {
            throw new RepositoryConfigurationException("Invalid RSync configuration. Index must be placed in folder that is a descendant of RSync Server Entry. Current RSync Server Entry Path is : " + absoluteRsyncEntryPath + " but it doesnt hold Index folder, that is : " + this.indexPath + ". Please fix configuration according to JCR Documentation and restart application.");
        }
        this.urlFormatString = "rsync://%s:" + rsyncPort + "/" + rsyncEntryName + relativeIndexPath + "/";
    }

    @Override
    protected void refreshIndexes(Set<String> set) {
        this.triggerRSyncSynchronization();
        super.refreshIndexes(set);
    }

    @Override
    public void read() throws IOException {
        this.triggerRSyncSynchronization();
        super.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerRSyncSynchronization() {
        if (this.modeHandler.getMode() == IndexerIoMode.READ_ONLY) {
            EmbeddedCacheManager cacheManager = this.cache.getCacheManager();
            if (cacheManager.getCoordinator() instanceof JGroupsAddress && cacheManager.getTransport() instanceof JGroupsTransport) {
                JGroupsTransport transport = (JGroupsTransport)cacheManager.getTransport();
                Address jgAddress = ((JGroupsAddress)cacheManager.getCoordinator()).getJGroupsAddress();
                if (!(jgAddress instanceof IpAddress)) {
                    Channel channel = transport.getChannel();
                    jgAddress = (Address)channel.down(new Event(87, (Object)jgAddress));
                }
                if (jgAddress instanceof IpAddress) {
                    String address = ((IpAddress)jgAddress).getIpAddress().getHostAddress();
                    RSyncJob rSyncJob = new RSyncJob(String.format(this.urlFormatString, address), this.indexPath, this.rsyncUserName, this.rsyncPassword);
                    try {
                        RsyncIndexInfos rsyncIndexInfos = this;
                        synchronized (rsyncIndexInfos) {
                            rSyncJob.execute();
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Failed to retrieve index using RSYNC", (Throwable)e);
                    }
                } else {
                    LOG.error((Object)("Error triggering RSync synchronization, skipped. Unsupported Address object : " + jgAddress.getClass().getName()));
                }
            } else {
                LOG.error((Object)("Error triggering RSync synchronization, skipped. Unsupported Address object : " + cacheManager.getCoordinator().getClass().getName()));
            }
        }
    }
}

